/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIChangeEventSender;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetDecorator;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.utilities.PropertyGroupUIHelper;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import java.util.ArrayList;
import java.util.EventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class PropertyUIWidget
implements Listener,
IPropertyChangeListener,
FocusListener {
    protected IPropertyDescriptor property_;
    protected IPropertyType propertyType_ = null;
    protected IPropertyUIWidgetFactory factory_;
    protected String errorMessage_ = null;
    protected boolean disposed_ = false;
    protected int status_ = 0;
    protected PropertyUIChangeEventSender eventSender_;
    protected Shell shell_;
    protected int widgetStyle_;
    protected int widgetIndent_;
    protected int listenerType_;
    protected PropertyUIWidgetDecorator decorator_;
    protected PropertyUIWidgetInfo widgetInfo_;
    private DelayedEvent delayedTask_;

    public PropertyUIWidget(IPropertyDescriptor pro, IPropertyUIWidgetFactory factory) {
        this(pro, factory, -1);
    }

    public PropertyUIWidget(IPropertyDescriptor pro, IPropertyUIWidgetFactory factory, int style) {
        this(pro, factory, style, null);
    }

    public PropertyUIWidget(IPropertyDescriptor pro, IPropertyUIWidgetFactory factory, int style, PropertyUIWidgetInfo info) {
        this.property_ = pro;
        this.property_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.eventSender_ = new PropertyUIChangeEventSender(this);
        if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)this.property_)) {
            this.propertyType_ = ((ISingleTypedProperty)this.property_).getPropertyType();
        }
        Display currentDisplay = Display.getCurrent();
        this.shell_ = currentDisplay.getActiveShell();
        this.widgetStyle_ = style;
        this.factory_ = factory;
        if (this.factory_ == null) {
            this.factory_ = PropertyUIFactory.instance(false).getUIFactory();
        }
        this.widgetInfo_ = info;
    }

    public abstract void createControl(Composite var1);

    public abstract String getWidgetValue();

    public abstract void setWidgetValue(String var1);

    public abstract void update();

    public abstract void update(int var1);

    public abstract Control[] getUIControls();

    public abstract Control getDefaultFocusControl();

    public abstract void changeColumnNumber(int var1);

    public IPropertyDescriptor getProperty() {
        return this.property_;
    }

    public void setProperty(IPropertyDescriptor pro) {
        this.property_.removePropertyChangeListener((IPropertyChangeListener)this);
        this.property_ = pro;
        this.property_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.errorMessage_ = null;
        this.status_ = 0;
        this.propertyType_ = null;
        if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)this.property_)) {
            this.propertyType_ = ((ISingleTypedProperty)this.property_).getPropertyType();
        }
    }

    public void addPropertyUIListener(String type, EventListener listener) {
        this.eventSender_.addPropertyUIListener(type, listener);
    }

    public void removePropertyUIListener(String type, EventListener listener) {
        this.eventSender_.removePropertyUIListener(type, listener);
    }

    public void addPropertyUIListener(String type, IPropertyUIListener listener) {
        this.eventSender_.addPropertyUIListener(type, listener);
    }

    public void removePropertyUIListener(String type, IPropertyUIListener listener) {
        this.eventSender_.removePropertyUIListener(type, listener);
    }

    public void addPropertyUIChangeListener(IPropertyUIChangeListener listener) {
        this.eventSender_.addPropertyUIChangeListener(listener);
    }

    public void removePropertyUIChangeListener(IPropertyUIChangeListener listener) {
        this.eventSender_.removePropertyUIChangeListener(listener);
    }

    public void addPropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        this.eventSender_.addPropertyUIStatusChangedListener(listener);
    }

    public void removePropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        this.eventSender_.removePropertyUIStatusChangedListener(listener);
    }

    public void setShell(Shell shell) {
        this.shell_ = shell;
    }

    public Shell getShell() {
        return this.shell_;
    }

    public void setWidgetStyle(int newStyle) {
        this.widgetStyle_ = newStyle;
    }

    public void setWidgetIndent(int indent) {
        this.widgetIndent_ = indent;
    }

    public String getWidgetLabel() {
        return this.getWidgetLabel(false);
    }

    protected String getWidgetLabel(boolean isForRequired) {
        return this.getWidgetLabel(this.property_, isForRequired);
    }

    protected String getWidgetLabel(IPropertyDescriptor ipd, boolean isForRequired) {
        return ipd.getDisplayName().trim();
    }

    public Composite getWidgetContainer() {
        Control[] controls = this.getUIControls();
        if (controls == null || controls.length < 1) {
            return null;
        }
        Composite parent = controls[0].getParent();
        while (parent != null && parent.getData("com.ibm.propertygroup.ui.inner_composite") != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Text) {
            int timer;
            int n = timer = this.widgetInfo_ != null ? this.widgetInfo_.delayedTimer_ : 400;
            if (this.delayedTask_ == null) {
                this.delayedTask_ = new DelayedEvent();
            }
            Display.getDefault().timerExec(timer, (Runnable)this.delayedTask_);
        } else {
            this.modifyProperty();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.modifyProperty();
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        if (this.disposed_) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.updateWidget(evt.getPropertyChangeType());
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PropertyUIWidget.this.updateWidget(evt.getPropertyChangeType());
                }
            });
        }
    }

    protected void updateWidget(int propertyChangeType) {
        Control[] controls = this.getUIControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isDisposed()) {
                this.dispose();
                return;
            }
            ++i;
        }
        this.update(propertyChangeType);
        if (propertyChangeType == 0) {
            this.errorMessage_ = null;
            this.status_ = 0;
        }
    }

    public String getErrorMessage() {
        String validationMsg;
        StringBuffer err = new StringBuffer(this.getDisplayString(this.getWidgetLabel(false)));
        err.append(" ");
        String errMsg = this.errorMessage_;
        if (this.status_ != 4 && PropertyHelper.isProperty((IPropertyDescriptor)this.property_) && !((IProperty)this.property_).isValid() && (validationMsg = ((IProperty)this.property_).getValidationMessage()) != null && !"".equals(validationMsg)) {
            errMsg = validationMsg;
        }
        err.append(errMsg);
        return err.toString();
    }

    public int getStatus() {
        return this.status_;
    }

    public boolean setFocus() {
        Control control = this.getDefaultFocusControl();
        if (control == null) {
            return false;
        }
        control.setFocus();
        return true;
    }

    public void setEnabled(boolean enabled) {
        Control[] controls = this.getUIControls();
        if (controls == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(enabled);
            if (controls[i] instanceof Label) {
                controls[i].redraw();
            }
            ++i;
        }
    }

    public void dispose() {
        if (!this.disposed_) {
            this.property_.removePropertyChangeListener((IPropertyChangeListener)this);
            if (this.decorator_ != null) {
                this.decorator_.dispose();
            }
            this.disposed_ = true;
        }
    }

    public IPropertyType getPropertyType() {
        return this.propertyType_;
    }

    public Object getValue() {
        return null;
    }

    public String getValueAsString() {
        return null;
    }

    public Object[] getValues() {
        return null;
    }

    public void setValue(Object newValue) {
    }

    public void setValue(String newValue) {
    }

    public void setListenerType(int newType) {
        this.listenerType_ = newType;
    }

    public void setValues(ArrayList<Object> newValues) {
    }

    private void modifyProperty() {
        String oldValue;
        if (this.disposed_) {
            return;
        }
        String newValue = this.getWidgetValue();
        if ((newValue.equals(oldValue = this.getValueAsString()) || oldValue == null && newValue.length() < 1) && this.status_ != 4) {
            return;
        }
        this.setValue(newValue);
        this.eventSender_.firePropertyUIChange(oldValue, newValue);
    }

    protected void sendPropertyUIStatusChangedEvent(IStatus status) {
        this.eventSender_.firePropertyUIStatusChanged(status);
    }

    protected boolean isEnabled() {
        return this.property_.isEnabled();
    }

    protected void addModificationListner(Control control, int listenerType) {
        if (this.listenerType_ == 1) {
            control.addFocusListener((FocusListener)this);
        } else {
            control.addListener(listenerType, (Listener)this);
        }
    }

    protected void moveWidget(Object obj, boolean moveAbove) {
        block9: {
            Control[] controls;
            if (obj == null) {
                return;
            }
            Control control = null;
            if (obj instanceof PropertyUIWidget) {
                controls = ((PropertyUIWidget)obj).getUIFirstLevelControls();
                if (controls != null && controls.length > 0) {
                    control = moveAbove ? controls[0] : controls[controls.length - 1];
                }
            } else if (obj instanceof Control) {
                control = (Control)obj;
            }
            if (control == null) break block9;
            controls = this.getUIFirstLevelControls();
            if (moveAbove) {
                int i = 0;
                while (i < controls.length) {
                    controls[i].moveAbove(control);
                    ++i;
                }
            } else {
                int i = controls.length - 1;
                while (i >= 0) {
                    controls[i].moveBelow(control);
                    --i;
                }
            }
        }
    }

    protected Control[] getUIFirstLevelControls() {
        Control[] controls = this.getUIControls();
        ArrayList<Control> list = new ArrayList<Control>(controls.length);
        Composite container = this.getWidgetContainer();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            Composite parent = control.getParent();
            while (parent != null && !parent.equals(container)) {
                control = parent;
                parent = parent.getParent();
            }
            if (control != null && list.indexOf(control) == -1) {
                list.add(control);
            }
            ++i;
        }
        controls = new Control[list.size()];
        list.toArray(controls);
        return controls;
    }

    protected Control[] getUIControlsOnComposite(Composite container) {
        if (container == null) {
            return this.getUIFirstLevelControls();
        }
        Control[] controls = this.getUIControls();
        ArrayList<Control> list = new ArrayList<Control>(controls.length);
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            Composite parent = control.getParent();
            while (parent != null && !parent.equals(container)) {
                control = parent;
                parent = parent.getParent();
            }
            if (control != null && list.indexOf(control) == -1) {
                list.add(control);
            }
            ++i;
        }
        controls = new Control[list.size()];
        list.toArray(controls);
        return controls;
    }

    protected void removeModificationListner(Control control, int listenerType) {
        if (this.listenerType_ == 1) {
            control.removeFocusListener((FocusListener)this);
        } else {
            control.removeListener(listenerType, (Listener)this);
        }
    }

    protected void addHoverManager(Control control, String msg) {
        PropertyGroupUIHelper.getDefault().addToolTipToControl(control, msg);
    }

    protected String getDisplayString(String msg) {
        StringBuffer str = new StringBuffer(msg.trim());
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '&') {
                str.deleteCharAt(i);
                break;
            }
            ++i;
        }
        return str.toString();
    }

    protected String processText(String text) {
        return text;
    }

    protected String processText(Class<?> clazz, String text) {
        return text;
    }

    protected String[] processText(String[] text) {
        return text;
    }

    protected String[] processText(Class<?> clazz, String[] text) {
        return text;
    }

    public Control[] getHelpControls() {
        return new Control[]{this.getDefaultFocusControl()};
    }

    public Control[] getWidgetLabelControls() {
        Control[] controls = this.getUIControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Label) {
                return new Control[]{controls[i]};
            }
            ++i;
        }
        return null;
    }

    public void decorateUIWidget(Image image, int position, String hoverHelp, Runnable action) {
        Control[] controls;
        if (this.decorator_ == null && (controls = this.getHelpControls()) != null && controls.length > 0) {
            this.decorator_ = new PropertyUIWidgetDecorator(this.getHelpControls()[0]);
        }
        if (this.decorator_ != null) {
            this.decorator_.decorateUIWidget(image, position, hoverHelp, true, action);
        }
    }

    public void setWidgetValue(String newValue, boolean applyToProperty) {
    }

    public boolean isDisposed() {
        return this.disposed_;
    }

    public PropertyUIWidgetInfo getWidgetInfo() {
        return this.widgetInfo_;
    }

    public void setWidgetInfo(PropertyUIWidgetInfo widgetInfo_) {
        this.widgetInfo_ = widgetInfo_;
    }

    private class DelayedEvent
    implements Runnable {
        boolean cancelEvent = false;

        private DelayedEvent() {
        }

        @Override
        public void run() {
            if (!this.cancelEvent) {
                PropertyUIWidget.this.modifyProperty();
                if (PropertyUIWidget.this.delayedTask_ == this) {
                    PropertyUIWidget.this.delayedTask_ = null;
                }
            }
        }

        public void setCancel(boolean flag) {
            this.cancelEvent = flag;
        }
    }
}

