/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PropertyUIWidgetCheckBox
extends PropertyUIWidgetProperty {
    protected Button checkBox_;
    protected Control label_;
    protected int columnNo_ = 1;

    public PropertyUIWidgetCheckBox(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetCheckBox(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetCheckBox(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.createCheckbox(parent);
        this.initDefaultValue();
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createCheckbox(Composite parent) {
        if (this.widgetInfo_ == null || this.widgetInfo_.labelAdapter_ == null || !this.widgetInfo_.labelAdapter_.generateHyperlinkLabel(this)) {
            this.checkBox_ = this.widgetStyle_ == -1 ? this.factory_.createButton(parent, this.property_.getDisplayName(), 32) : this.factory_.createButton(parent, this.property_.getDisplayName(), this.widgetStyle_);
            GridData gd = new GridData();
            if (this.widgetIndent_ > 0) {
                gd.horizontalIndent = this.widgetIndent_;
            }
            if (this.columnNo_ > 1) {
                gd.horizontalSpan = this.columnNo_;
            }
            this.checkBox_.setLayoutData((Object)gd);
            this.label_ = null;
        } else {
            Composite container = this.createCheckboxContainer(parent);
            this.checkBox_ = this.widgetStyle_ == -1 ? this.factory_.createButton(container, 32) : this.factory_.createButton(container, this.widgetStyle_);
            this.label_ = this.createHyperlinkLabel(container, this.property_.getDisplayName());
        }
        this.addHoverManager((Control)this.checkBox_, this.property_.getDescription());
    }

    protected Composite createCheckboxContainer(Composite parent) {
        Composite composite = this.factory_.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        if (this.columnNo_ > 1) {
            gd.horizontalSpan = this.columnNo_;
        }
        composite.setLayoutData((Object)gd);
        composite.setData("com.ibm.propertygroup.ui.inner_composite", (Object)"PropertyUIWidgetCheckBox");
        return composite;
    }

    @Override
    public void initDefaultValue() {
        this.checkBox_.removeListener(13, (Listener)this);
        Object defaultValue = this.getValue();
        if (defaultValue != null && defaultValue instanceof Boolean) {
            this.checkBox_.setSelection(((Boolean)defaultValue).booleanValue());
        } else {
            if (defaultValue == null) {
                defaultValue = this.getDefaultValue();
            }
            if (defaultValue != null) {
                Boolean value = null;
                if (defaultValue instanceof String) {
                    value = new Boolean((String)defaultValue);
                } else if (defaultValue instanceof Boolean) {
                    value = (Boolean)defaultValue;
                }
                if (value != null) {
                    if (this.isRequired()) {
                        this.setValue(value);
                    }
                    this.checkBox_.setSelection(value.booleanValue());
                }
            }
        }
        this.checkBox_.addListener(13, (Listener)this);
    }

    @Override
    public String getWidgetValue() {
        if (this.checkBox_.getSelection()) {
            return "true";
        }
        return "false";
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setWidgetValue(newValue, true);
    }

    @Override
    public void setWidgetValue(String newValue, boolean applyToProperty) {
        if (!applyToProperty) {
            this.checkBox_.removeListener(13, (Listener)this);
        }
        if ("true".equals(newValue)) {
            this.checkBox_.setSelection(true);
        } else {
            this.checkBox_.setSelection(false);
        }
        if (!applyToProperty) {
            this.checkBox_.addListener(13, (Listener)this);
        }
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                this.handlePropertyValueChanged();
                break;
            }
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    protected void handlePropertyValueChanged() {
        String newValue = this.getValueAsString();
        String widgetValue = this.getWidgetValue();
        if (widgetValue.equalsIgnoreCase(newValue)) {
            return;
        }
        this.checkBox_.removeListener(13, (Listener)this);
        if (newValue != null && newValue.equalsIgnoreCase("TRUE")) {
            this.checkBox_.setSelection(true);
        } else {
            this.checkBox_.setSelection(false);
        }
        this.checkBox_.addListener(13, (Listener)this);
    }

    public Button getCheckBox() {
        return this.checkBox_;
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        if (this.label_ == null) {
            return new Control[]{this.checkBox_};
        }
        return new Control[]{this.checkBox_, this.label_};
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.checkBox_;
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber != this.columnNo_) {
            Object control = this.label_ != null ? this.checkBox_.getParent() : this.checkBox_;
            GridData gd = (GridData)control.getLayoutData();
            gd.horizontalSpan = newNumber;
            this.columnNo_ = newNumber;
        }
    }

    @Override
    public Control[] getWidgetLabelControls() {
        if (this.label_ == null) {
            return new Control[]{this.checkBox_};
        }
        return new Control[]{this.label_};
    }
}

