/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PropertyUIWidgetDecorator
implements PaintListener {
    protected final int LEFT_TOP = 0;
    protected final int LEFT_BOTTOM = 1;
    protected final int RIGHT_TOP = 2;
    protected final int RIGHT_BOTTOM = 3;
    protected Image[] images_ = new Image[4];
    protected String[] hoverText_ = new String[4];
    protected Runnable[] actions_ = new Runnable[4];
    protected Hover hover_;
    protected Control control_;
    protected Control focusControl_;
    protected Cursor hand_;
    protected boolean isActionReady_ = false;
    protected MouseActionAdapter mouseActionAdapter_;
    protected MouseTrackAdapter mouseTrackAdapter_;
    protected Listener shellListener_;
    protected int deltaX_;
    protected int deltaY_;
    protected int left_tal_ = -2;
    protected int right_tal_ = -1;
    protected KeyAdapter accessListener_ = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x100000B) {
                int i;
                int index = -1;
                if (PropertyUIWidgetDecorator.this.isHoverVisible()) {
                    i = PropertyUIWidgetDecorator.this.hover_.currentIndex_ + 1;
                    while (i < PropertyUIWidgetDecorator.this.hoverText_.length) {
                        if (PropertyUIWidgetDecorator.this.hoverText_[i] != null && PropertyUIWidgetDecorator.this.hoverText_[i].length() > 0) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < PropertyUIWidgetDecorator.this.hoverText_.length) {
                        if (PropertyUIWidgetDecorator.this.hoverText_[i] != null && PropertyUIWidgetDecorator.this.hoverText_[i].length() > 0) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index != -1) {
                    int[] loc = PropertyUIWidgetDecorator.this.getDrawingLocation(index);
                    PropertyUIWidgetDecorator.this.showHover(PropertyUIWidgetDecorator.this.control_, PropertyUIWidgetDecorator.this.hoverText_[index], loc, PropertyUIWidgetDecorator.this.actions_[index], index);
                } else if (PropertyUIWidgetDecorator.this.isHoverVisible()) {
                    PropertyUIWidgetDecorator.this.showHover(PropertyUIWidgetDecorator.this.control_, null, null, null, -1);
                }
            }
        }
    };

    public PropertyUIWidgetDecorator(Control control) {
        this(control, null);
    }

    public PropertyUIWidgetDecorator(Control control, Control focusControl) {
        this.control_ = control;
        this.focusControl_ = focusControl;
        this.hand_ = new Cursor((Device)this.control_.getDisplay(), 21);
        this.mouseTrackAdapter_ = new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Control source = (Control)e.widget;
                PropertyUIWidgetDecorator.this.showHover(PropertyUIWidgetDecorator.this.control_, null, null, null, -1);
                int i = 0;
                while (i < PropertyUIWidgetDecorator.this.images_.length) {
                    if (PropertyUIWidgetDecorator.this.images_[i] != null && !PropertyUIWidgetDecorator.this.images_[i].isDisposed()) {
                        Rectangle r = PropertyUIWidgetDecorator.this.images_[i].getBounds();
                        int[] loc = PropertyUIWidgetDecorator.this.getDrawingLocation(i);
                        Point global = PropertyUIWidgetDecorator.this.control_.toDisplay(loc[0], loc[1]);
                        Point local = source.toControl(global);
                        r.x = local.x;
                        r.y = local.y;
                        if (r.contains(e.x, e.y)) {
                            PropertyUIWidgetDecorator.this.showHover(PropertyUIWidgetDecorator.this.control_, PropertyUIWidgetDecorator.this.hoverText_[i], loc, PropertyUIWidgetDecorator.this.actions_[i], i);
                            break;
                        }
                    }
                    ++i;
                }
            }

            public void mouseExit(MouseEvent e) {
                if (PropertyUIWidgetDecorator.this.isHoverVisible()) {
                    PropertyUIWidgetDecorator.this.showHover(PropertyUIWidgetDecorator.this.control_, null, null, null, -1);
                }
            }
        };
        this.shellListener_ = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 10: 
                    case 11: {
                        if (PropertyUIWidgetDecorator.this.hover_ == null) break;
                        PropertyUIWidgetDecorator.this.hover_.setLocation(PropertyUIWidgetDecorator.this.control_, null);
                        break;
                    }
                    case 12: {
                        PropertyUIWidgetDecorator.this.cleanHover();
                        break;
                    }
                    case 19: 
                    case 21: 
                    case 27: {
                        PropertyUIWidgetDecorator.this.showHover(null, null, null, null, -1);
                    }
                }
            }
        };
        this.initDecorator();
    }

    protected void initDecorator() {
        if (this.control_ != null && !this.control_.isDisposed()) {
            this.control_.getParent().removePaintListener((PaintListener)this);
            this.control_.getParent().addPaintListener((PaintListener)this);
            this.mouseActionAdapter_ = new MouseActionAdapter();
            this.control_.getParent().addMouseTrackListener((MouseTrackListener)this.mouseTrackAdapter_);
            Shell shell = this.control_.getShell();
            this.control_.addListener(12, this.shellListener_);
            shell.addListener(11, this.shellListener_);
            shell.addListener(10, this.shellListener_);
            shell.addListener(21, this.shellListener_);
            shell.addListener(27, this.shellListener_);
            shell.addListener(19, this.shellListener_);
        }
    }

    public void decorateUIWidget(Image image, int position, String hoverHelp, boolean keepOthers, Runnable action) {
        if (this.control_ != null && !this.control_.isDisposed()) {
            int index = this.indexForPosition(position);
            int i = 0;
            while (i < this.images_.length) {
                if (i == index) {
                    this.images_[index] = image;
                    this.hoverText_[index] = hoverHelp;
                    this.actions_[i] = action;
                } else if (!keepOthers) {
                    this.images_[i] = null;
                    this.hoverText_[i] = null;
                }
                ++i;
            }
            this.control_.getParent().redraw();
            if (image != null && hoverHelp != null) {
                Control control = null;
                if (this.focusControl_ != null) {
                    control = this.focusControl_;
                } else {
                    control = this.control_;
                    if (control instanceof Composite && ((Composite)control).getChildren().length > 0) {
                        control = this.getFocusControl((Composite)control);
                    }
                }
                if (control != null && !control.isDisposed()) {
                    control.removeKeyListener((KeyListener)this.accessListener_);
                    control.addKeyListener((KeyListener)this.accessListener_);
                }
            }
        }
    }

    protected Control getFocusControl(Composite container) {
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != null && !children[i].isDisposed() && !(children[i] instanceof Label)) {
                if (children[i] instanceof Composite) {
                    Control control = this.getFocusControl((Composite)children[i]);
                    if (control != null) {
                        return control;
                    }
                } else {
                    return children[i];
                }
            }
            ++i;
        }
        return container;
    }

    public void setOffset(int x, int y) {
        this.deltaX_ = x;
        this.deltaY_ = y;
    }

    public void paintControl(PaintEvent e) {
        if (this.control_ == null || this.control_.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.images_.length) {
            if (this.images_[i] != null && !this.images_[i].isDisposed()) {
                int[] loc = this.getDrawingLocation(i);
                Point global = this.control_.toDisplay(loc[0], loc[1]);
                Point local = ((Control)e.widget).toControl(global);
                Composite parent = this.control_.getParent();
                boolean needLayoutParent = false;
                Layout layout = parent.getLayout();
                if (layout != null && layout instanceof GridLayout) {
                    int width;
                    Rectangle pBound = parent.getBounds();
                    Point pPos = parent.toDisplay(0, 0);
                    int imageWidth = this.images_[i].getBounds().width;
                    if (global.x < pPos.x) {
                        width = imageWidth - this.left_tal_;
                        if ((i == 1 || i == 0) && ((GridLayout)layout).marginLeft < width) {
                            ((GridLayout)layout).marginLeft = width;
                            needLayoutParent = true;
                        }
                    } else if (global.x + imageWidth > pPos.x + pBound.width) {
                        width = imageWidth;
                        if ((i == 3 || i == 2) && ((GridLayout)layout).marginRight < width) {
                            ((GridLayout)layout).marginRight = width;
                            needLayoutParent = true;
                        }
                    } else if (((GridLayout)layout).horizontalSpacing < imageWidth) {
                        ((GridLayout)layout).horizontalSpacing = imageWidth;
                        needLayoutParent = true;
                    }
                }
                if (needLayoutParent) {
                    parent.removePaintListener((PaintListener)this);
                    parent.layout();
                    parent.redraw();
                    parent.addPaintListener((PaintListener)this);
                } else {
                    e.gc.drawImage(this.images_[i], local.x, local.y);
                }
            }
            ++i;
        }
    }

    public Control getControl() {
        return this.control_;
    }

    protected int[] getDrawingLocation(int index) {
        int[] loc = new int[2];
        switch (index) {
            case 1: {
                Rectangle ir = this.images_[index].getBounds();
                loc[0] = -ir.width + this.left_tal_;
                loc[1] = this.control_.getBounds().height - ir.height - 2;
                break;
            }
            case 2: {
                loc[0] = this.control_.getBounds().width + this.right_tal_;
                loc[1] = -1;
                break;
            }
            case 3: {
                Rectangle r = this.control_.getBounds();
                loc[0] = r.width + this.right_tal_;
                loc[1] = r.height - this.images_[index].getBounds().height - 2;
                break;
            }
            default: {
                loc[0] = -this.images_[index].getBounds().width + this.left_tal_;
                loc[1] = -1;
            }
        }
        loc[0] = loc[0] + this.deltaX_;
        loc[1] = loc[1] + this.deltaY_;
        return loc;
    }

    protected void showHover(Control control, String text, int[] offsets, Runnable action, int index) {
        if (text != null) {
            if (this.hover_ == null) {
                this.hover_ = new Hover(control.getShell());
            }
            this.hover_.setText(text);
            this.hover_.setLocation(control, offsets);
            this.hover_.setVisible(true);
            this.hover_.currentIndex_ = index;
            if (action != null) {
                Composite source = control.getParent();
                source.setCursor(this.hand_);
                this.mouseActionAdapter_.setAction(action);
                source.removeMouseListener((MouseListener)this.mouseActionAdapter_);
                source.addMouseListener((MouseListener)this.mouseActionAdapter_);
                this.isActionReady_ = true;
            }
        } else {
            if (this.hover_ != null) {
                this.hover_.setVisible(false);
                this.hover_.currentIndex_ = -1;
            }
            if (this.isActionReady_ && control != null) {
                Composite source = control.getParent();
                source.setCursor(null);
                source.removeMouseListener((MouseListener)this.mouseActionAdapter_);
            }
        }
    }

    protected boolean isHoverVisible() {
        return this.hover_ != null && this.hover_.isVisible();
    }

    protected void cleanHover() {
        if (this.hover_ != null) {
            this.hover_.dispose();
            this.hover_ = null;
        }
    }

    public void dispose() {
        if (this.control_ != null && !this.control_.isDisposed()) {
            Composite container = this.control_.getParent();
            container.removePaintListener((PaintListener)this);
            container.removeMouseTrackListener((MouseTrackListener)this.mouseTrackAdapter_);
            container.removeMouseListener((MouseListener)this.mouseActionAdapter_);
            Shell shell = this.control_.getShell();
            this.control_.removeListener(12, this.shellListener_);
            shell.removeListener(11, this.shellListener_);
            shell.removeListener(10, this.shellListener_);
            shell.removeListener(21, this.shellListener_);
            shell.removeListener(27, this.shellListener_);
            shell.removeListener(19, this.shellListener_);
            this.control_.removeKeyListener((KeyListener)this.accessListener_);
            this.control_ = null;
        }
        this.cleanHover();
        if (!this.hand_.isDisposed()) {
            this.hand_.dispose();
        }
    }

    protected int indexForPosition(int position) {
        switch (position) {
            case 17408: {
                return 1;
            }
            case 131200: {
                return 2;
            }
            case 132096: {
                return 3;
            }
        }
        return 0;
    }

    protected class Hover {
        private int HD = 10;
        private int HW = 8;
        private int HH = 10;
        private int LABEL_MARGIN = 2;
        private Shell fHoverShell;
        private Region fHoverRegion;
        private String fText = "";
        private int currentIndex_;

        Hover(Shell parent) {
            Display display = parent.getDisplay();
            this.fHoverShell = new Shell(parent, 540680);
            this.fHoverShell.setBackground(display.getSystemColor(29));
            this.fHoverShell.setForeground(display.getSystemColor(28));
            this.fHoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawString(Hover.this.fText, Hover.this.LABEL_MARGIN, Hover.this.LABEL_MARGIN);
                    pe.gc.drawPolygon(Hover.this.getPolygon(true));
                }
            });
            this.fHoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    PropertyUIWidgetDecorator.this.showHover(null, null, null, null, -1);
                }
            });
        }

        int[] getPolygon(boolean border) {
            Point e = this.getExtent();
            if (border) {
                int[] nArray = new int[16];
                nArray[2] = e.x - 1;
                nArray[4] = e.x - 1;
                nArray[5] = e.y - 1;
                nArray[6] = this.HD + this.HW;
                nArray[7] = e.y - 1;
                nArray[8] = this.HD + this.HW / 2;
                nArray[9] = e.y + this.HH - 1;
                nArray[10] = this.HD;
                nArray[11] = e.y - 1;
                nArray[13] = e.y - 1;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = e.x;
            nArray[4] = e.x;
            nArray[5] = e.y;
            nArray[6] = this.HD + this.HW;
            nArray[7] = e.y;
            nArray[8] = this.HD + this.HW / 2;
            nArray[9] = e.y + this.HH;
            nArray[10] = this.HD;
            nArray[11] = e.y;
            nArray[13] = e.y;
            return nArray;
        }

        void dispose() {
            if (!this.fHoverShell.isDisposed()) {
                this.fHoverShell.dispose();
            }
            if (this.fHoverRegion != null) {
                this.fHoverRegion.dispose();
            }
        }

        void setVisible(boolean visible) {
            if (visible) {
                if (!this.fHoverShell.isVisible()) {
                    this.fHoverShell.setVisible(true);
                }
            } else if (this.fHoverShell.isVisible()) {
                this.fHoverShell.setVisible(false);
            }
            this.fHoverShell.setCursor(null);
        }

        void setText(String t) {
            if (t == null) {
                t = "";
            }
            if (!t.equals(this.fText)) {
                Point oldSize = this.getExtent();
                this.fText = t;
                this.fHoverShell.redraw();
                Point newSize = this.getExtent();
                if (!oldSize.equals((Object)newSize)) {
                    Region oldRegion = this.fHoverRegion;
                    this.fHoverRegion = new Region();
                    this.fHoverRegion.add(this.getPolygon(false));
                    this.fHoverShell.setRegion(this.fHoverRegion);
                    if (oldRegion != null) {
                        oldRegion.dispose();
                    }
                }
            }
        }

        boolean isVisible() {
            return this.fHoverShell.isVisible();
        }

        void setLocation(Control control, int[] offsets) {
            if (control != null) {
                int h = this.getExtent().y;
                int x = -this.HD - this.HW / 2;
                int y = -h - this.HH + 1;
                if (offsets != null) {
                    x += offsets[0];
                    y += offsets[1];
                }
                this.fHoverShell.setLocation(control.toDisplay(x, y));
            }
        }

        Point getExtent() {
            GC gc = new GC((Drawable)this.fHoverShell);
            Point e = gc.textExtent(this.fText);
            gc.dispose();
            e.x += this.LABEL_MARGIN * 2;
            e.y += this.LABEL_MARGIN * 2;
            return e;
        }
    }

    protected class MouseActionAdapter
    extends MouseAdapter {
        protected Runnable action_;

        protected MouseActionAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if (this.action_ != null) {
                this.action_.run();
            }
        }

        public void setAction(Runnable newAction) {
            this.action_ = newAction;
        }
    }
}

