/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import com.ibm.propertygroup.ui.internal.controls.ToolBarComposite;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTextContentAssist;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import com.ibm.propertygroup.ui.widgets.ToolBarViewer;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PropertyUINormalWidgetFactory
implements IPropertyUIWidgetFactory {
    private IPropertyUIWidgetFactory.FocusHandler focusHandler_ = null;

    @Override
    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        if (text != null) {
            button.setText(text);
        }
        button.setFont(parent.getFont());
        this.addFocusHandler((Control)button);
        return button;
    }

    @Override
    public Button createButton(Composite parent, int style) {
        return this.createButton(parent, null, style);
    }

    @Override
    public Button createToggleButton(Composite parent, String text, int style) {
        final Button button = this.createButton(parent, text, style | 2);
        final Cursor hand = new Cursor((Device)button.getDisplay(), 21);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hand.dispose();
            }
        });
        button.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    button.setCursor(hand);
                }
            }
        });
        this.addFocusHandler((Control)button);
        return button;
    }

    @Override
    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        return composite;
    }

    @Override
    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setFont(parent.getFont());
        return label;
    }

    @Override
    public Label createLabel(Composite parent, int style) {
        return this.createLabel(parent, null, style);
    }

    @Override
    public Label createSeparator(Composite parent, int style) {
        return this.createLabel(parent, 2 | style);
    }

    @Override
    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        if (value != null) {
            text.setText(value);
        }
        text.setFont(parent.getFont());
        this.addFocusHandler((Control)text);
        return text;
    }

    @Override
    public PropertyUIWidgetTextContentAssist createTextWithContentAssist(Composite parent, String value, int style, List<String> suggestions) {
        Text text = this.createText(parent, value, style);
        return new PropertyUIWidgetTextContentAssist(text, suggestions);
    }

    @Override
    public PropertyUIWidgetTextContentAssist createTextWithContentAssist(Composite parent, int style, List<String> suggestions) {
        return this.createTextWithContentAssist(parent, "", style, suggestions);
    }

    @Override
    public Text createText(Composite parent, int style) {
        return this.createText(parent, null, style);
    }

    @Override
    public ScrolledComposite createScrolledComposite(Composite parent, int style) {
        ScrollBar vbar;
        ScrolledComposite composite = new ScrolledComposite(parent, style);
        composite.setFont(parent.getFont());
        ScrollBar hbar = composite.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(10);
            hbar.setPageIncrement(40);
        }
        if ((vbar = composite.getVerticalBar()) != null) {
            vbar.setIncrement(10);
            vbar.setPageIncrement(40);
        }
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        return composite;
    }

    @Override
    public Group createGroup(Composite parent, String text, int style) {
        Group groupWidget = new Group(parent, style);
        if (text != null) {
            groupWidget.setText(text);
        }
        groupWidget.setFont(parent.getFont());
        return groupWidget;
    }

    @Override
    public Group createGroup(Composite parent, int style) {
        return this.createGroup(parent, null, style);
    }

    @Override
    public Composite createCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        combo.setFont(parent.getFont());
        this.addFocusHandler((Control)combo);
        return combo;
    }

    @Override
    public Combo createNormalCombo(Composite parent, int style) {
        return (Combo)this.createCombo(parent, style);
    }

    @Override
    public CCombo createCCombo(Composite parent, int style) {
        CCombo cc = new CCombo(parent, 0x800000 | style);
        cc.setFont(parent.getFont());
        this.addFocusHandler((Control)cc);
        return cc;
    }

    @Override
    public org.eclipse.swt.widgets.List createList(Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, style | 0x800000);
        list.setFont(parent.getFont());
        this.addFocusHandler((Control)list);
        return list;
    }

    @Override
    public FilteredList createFilteredList(Composite parent, int style, LabelProvider labelProvider, boolean ignoreCase, boolean allowDuplicates, boolean matchEmptyString) {
        FilteredList list = new FilteredList(parent, style | 0x800000, (ILabelProvider)labelProvider, ignoreCase, allowDuplicates, matchEmptyString);
        list.setFont(parent.getFont());
        this.addFocusHandler((Control)list);
        return list;
    }

    @Override
    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setFont(parent.getFont());
        return tree;
    }

    @Override
    public TreeViewer createTreeViewer(Composite parent, int style) {
        TreeViewer treeViewer = new TreeViewer(parent, style);
        return treeViewer;
    }

    @Override
    public TreeViewer createTreeViewer(Tree tree) {
        return new TreeViewer(tree);
    }

    @Override
    public TableViewer createTableViewer(Composite parent, int style) {
        return new TableViewer(parent, style);
    }

    @Override
    public TableViewer createTableViewer(Table table) {
        return new TableViewer(table);
    }

    @Override
    public Table createTable(Composite parent, int style) {
        return new Table(parent, style);
    }

    @Override
    public int getBorderStyle() {
        return 2048;
    }

    @Override
    public void addFocusHandler(Control control) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = new IPropertyUIWidgetFactory.FocusHandler();
        }
        control.removeFocusListener((FocusListener)this.focusHandler_);
        control.addFocusListener((FocusListener)this.focusHandler_);
    }

    @Override
    public CheckboxTreeViewer createCheckboxTreeViewer(Composite parent, int style) {
        return new CheckboxTreeViewer(parent, style);
    }

    @Override
    public CheckboxTreeViewer createCheckboxTreeViewer(Tree tree) {
        return new CheckboxTreeViewer(tree);
    }

    @Override
    public SashForm createSashForm(Composite parent, int style) {
        SashForm form = new SashForm(parent, style);
        form.setFont(parent.getFont());
        return form;
    }

    @Override
    public ExpandableComposite createExpandableComposite(Composite parent, int expansionStyle) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, expansionStyle);
        excomposite.setMenu(parent.getMenu());
        excomposite.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return excomposite;
    }

    @Override
    public PropertyUIScrollableComposite createPropertyUIScrollableComposite(Composite parent, int style) {
        PropertyUIScrollableComposite composite = new PropertyUIScrollableComposite(parent, style);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        return composite;
    }

    @Override
    public ToolBarViewer createToolBarViewer(Composite parent, int style) {
        ToolBarViewer composite = new ToolBarViewer(parent, style);
        composite.setLayoutData(new GridData(768));
        return composite;
    }

    @Override
    public ToolBarComposite createToolBarComposite(Composite parent, int style) {
        ToolBarComposite composite = new ToolBarComposite(parent, style);
        composite.setLayoutData(new GridData(768));
        return composite;
    }

    @Override
    public TabFolder createTabFolder(Composite parent, int style) {
        TabFolder tabFolder = new TabFolder(parent, style);
        tabFolder.setFont(parent.getFont());
        return tabFolder;
    }

    @Override
    public TabItem createTabItem(TabFolder parent, int style) {
        return new TabItem(parent, style);
    }

    @Override
    public TabItem createTabItem(TabFolder parent, int style, int index) {
        return new TabItem(parent, style, index);
    }

    @Override
    public Section createSection(Composite parent, int style) {
        Section section = new Section(parent, style);
        section.setFont(parent.getFont());
        Control[] children = section.getChildren();
        if (children != null && children.length > 0) {
            this.addFocusHandler(children[0]);
        }
        return section;
    }

    @Override
    public Hyperlink createHyperlink(Composite parent, int style) {
        return this.createHyperlink(parent, null, style);
    }

    @Override
    public Hyperlink createHyperlink(Composite parent, String text, int style) {
        Hyperlink link = new Hyperlink(parent, 0);
        if (text != null) {
            link.setText(text);
        }
        link.setFont(parent.getFont());
        return link;
    }

    @Override
    public Hyperlink createUnderlinedHyperlink(Composite parent, int style) {
        return this.createUnderlinedHyperlink(parent, null, style);
    }

    @Override
    public Hyperlink createUnderlinedHyperlink(Composite parent, String text, int style) {
        Hyperlink link = this.createHyperlink(parent, text, style);
        link.setUnderlined(true);
        return link;
    }
}

