/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class PropertyUIJavaDataTypeHierarchyScope
implements IJavaSearchScope {
    private IType[] searchTypes_;
    private WorkingCopyOwner owner_;
    private boolean needsRefresh_;
    private IPath[] enclosingProjectsAndJars_;
    private IResource[] enclosingProjects_;
    private HashSet<String> resourcePaths_;
    protected HashSet<String> elements_;

    public PropertyUIJavaDataTypeHierarchyScope(IType[] types, WorkingCopyOwner owner, IResource[] resources) throws JavaModelException {
        this.searchTypes_ = types;
        this.needsRefresh_ = true;
        this.owner_ = owner;
        this.enclosingProjects_ = resources;
        this.enclosingProjectsAndJars_ = this.computeProjectsAndJars(types);
    }

    protected IPath[] computeProjectsAndJars(IType[] types) throws JavaModelException {
        ArrayList<IPath> returnPaths = new ArrayList<IPath>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IPath[] paths;
            IType type = iTypeArray[n2];
            IPath[] iPathArray = paths = this.computeProjectsAndJars(type);
            int n3 = paths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                if (returnPaths.indexOf(path) == -1) {
                    returnPaths.add(path);
                }
                ++n4;
            }
            ++n2;
        }
        IPath[] result = new IPath[returnPaths.size()];
        returnPaths.toArray(result);
        return result;
    }

    protected IPath[] computeProjectsAndJars(IType type) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            IPath rootPath = root.getPath();
            set.add(rootPath);
            HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
            IResource[] iResourceArray = this.enclosingProjects_;
            int n = this.enclosingProjects_.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry[] classpath;
                IResource resource = iResourceArray[n2];
                IJavaProject project = (IJavaProject)JavaCore.create((IResource)resource);
                IClasspathEntry[] iClasspathEntryArray = classpath = project.getResolvedClasspath(true);
                int n3 = classpath.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry entry = iClasspathEntryArray[n4];
                    if (rootPath.equals((Object)entry.getPath())) {
                        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                        set.add(project.getPath());
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        int n5 = roots.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n6];
                            if (pkgFragmentRoot.getKind() == 2) {
                                set.add(pkgFragmentRoot.getPath());
                            }
                            ++n6;
                        }
                        if (visited.contains(project)) break;
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            IPackageFragmentRoot[] roots;
            IJavaProject project = (IJavaProject)root.getParent();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getAllPackageFragmentRoots();
            int n = roots.length;
            int n7 = 0;
            while (n7 < n) {
                IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n7];
                if (pkgFragmentRoot.getKind() == 2) {
                    set.add(pkgFragmentRoot.getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++n7;
            }
            this.computeDependents(project, set, new HashSet<IJavaProject>());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    protected void computeDependents(IJavaProject project, HashSet<IPath> set, HashSet<IJavaProject> visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject currentProject = project.getProject();
        IProject[] dependents = currentProject.getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            if (!currentProject.equals((Object)dependents[i])) {
                try {
                    IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                    IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                    set.add(dependent.getPath());
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n2];
                        if (pkgFragmentRoot.isArchive()) {
                            set.add(pkgFragmentRoot.getPath());
                        }
                        ++n2;
                    }
                    this.computeDependents(dependent, set, visited);
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i;
        }
    }

    protected void initialize() {
        if (this.searchTypes_ == null || !this.needsRefresh_) {
            return;
        }
        this.resourcePaths_ = new HashSet();
        this.needsRefresh_ = false;
        this.elements_ = new HashSet();
        this.reComputeTypesProjectsAndJars();
    }

    protected void reComputeTypesProjectsAndJars() {
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IType[] iTypeArray = this.searchTypes_;
            int n = this.searchTypes_.length;
            int n2 = 0;
            while (n2 < n) {
                IType[] subTypes;
                IType type = iTypeArray[n2];
                IType[] iTypeArray2 = subTypes = type.newTypeHierarchy(this.owner_, null).getAllSubtypes(type);
                int n3 = subTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    block9: {
                        IType subType;
                        block10: {
                            String fileName;
                            IPath path;
                            block12: {
                                block11: {
                                    IPackageFragmentRoot root;
                                    String path2;
                                    subType = iTypeArray2[n4];
                                    IResource resource = subType.getResource();
                                    if (resource != null && !this.checkProject(resource.getProject()) || "java.lang.Object".equals(subType.getFullyQualifiedName())) break block9;
                                    if (resource != null && !subType.isBinary() && !this.elements_.contains(path2 = resource.getFullPath().toString())) {
                                        this.elements_.add(path2);
                                    }
                                    if (!(root = (IPackageFragmentRoot)subType.getPackageFragment().getParent()).isArchive()) break block10;
                                    path = root.getPath();
                                    IResource rootResource = resource;
                                    if (rootResource == null) {
                                        rootResource = workspaceRoot.findMember(path);
                                    }
                                    fileName = null;
                                    if (rootResource == null) break block11;
                                    fileName = path.toString();
                                    break block12;
                                }
                                if (!path.isAbsolute()) break block9;
                                fileName = path.toFile().getPath();
                            }
                            StringBuffer resourcePath = new StringBuffer(fileName);
                            resourcePath.append("|").append(subType.getFullyQualifiedName().replace('.', '/')).append(".class");
                            this.resourcePaths_.add(resourcePath.toString());
                            paths.put(path, subType);
                            break block9;
                        }
                        paths.put(subType.getJavaProject().getProject().getFullPath(), subType);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.enclosingProjectsAndJars_ = new IPath[paths.size()];
            int i = 0;
            Iterator iter = paths.keySet().iterator();
            while (iter.hasNext()) {
                this.enclosingProjectsAndJars_[i++] = (IPath)iter.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.needsRefresh_) {
            this.initialize();
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths_.contains(resourcePath);
        }
        return this.elements_.contains(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        if (element.getResource() == null) {
            if (element.getElementType() == 7) {
                return this.encloses(new StringBuffer(element.getPath().toOSString()).append("|").append(((IType)element).getFullyQualifiedName().replace('.', '/')).append(".class").toString());
            }
            IType type = (IType)element.getAncestor(7);
            if (type != null) {
                return this.encloses(new StringBuffer(type.getPath().toOSString()).append("|").append(type.getFullyQualifiedName().replace('.', '/')).append(".class").toString());
            }
            return this.encloses(element.getPath().toString());
        }
        if (element.getElementType() == 7 && ((IType)element).isBinary()) {
            return this.encloses(new StringBuffer(element.getPath().toString()).append("|").append(((IType)element).getFullyQualifiedName().replace('.', '/')).append(".class").toString());
        }
        return this.encloses(element.getPath().toString());
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh_) {
            this.initialize();
        }
        return this.enclosingProjectsAndJars_;
    }

    protected void refresh() {
        this.initialize();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    protected boolean checkProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (this.enclosingProjects_ == null) {
            return true;
        }
        int i = 0;
        while (i < this.enclosingProjects_.length) {
            if (project.equals((Object)this.enclosingProjects_[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

