/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import com.ibm.propertygroup.ui.internal.controls.ToolBarComposite;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTextContentAssist;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import com.ibm.propertygroup.ui.widgets.ToolBarViewer;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PropertyUIFlatWidgetFactory
extends FormToolkit
implements IPropertyUIWidgetFactory {
    private IPropertyUIWidgetFactory.FocusHandler focusHandler_ = null;

    public PropertyUIFlatWidgetFactory() {
        super(Display.getCurrent());
    }

    @Override
    public Button createButton(Composite parent, String text, int style) {
        Button button = super.createButton(parent, text, style);
        this.addFocusHandler((Control)button);
        return button;
    }

    @Override
    public Button createButton(Composite parent, int style) {
        return this.createButton(parent, null, style);
    }

    @Override
    public Button createToggleButton(Composite parent, String text, int style) {
        final Button button = this.createButton(parent, text, style | 2);
        final Cursor hand = new Cursor((Device)button.getDisplay(), 21);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hand.dispose();
            }
        });
        button.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    button.setCursor(hand);
                }
            }
        });
        this.addFocusHandler((Control)button);
        return button;
    }

    @Override
    public Composite createComposite(Composite parent, int style) {
        Composite composite = super.createComposite(parent, style);
        this.paintBordersFor(composite);
        return composite;
    }

    @Override
    public Label createLabel(Composite parent, String text, int style) {
        return super.createLabel(parent, text, style);
    }

    @Override
    public Label createLabel(Composite parent, int style) {
        return this.createLabel(parent, null, style);
    }

    @Override
    public Label createSeparator(Composite parent, int style) {
        return super.createSeparator(parent, style);
    }

    @Override
    public Text createText(Composite parent, String value, int style) {
        Text text = super.createText(parent, value, style);
        this.addFocusHandler((Control)text);
        return text;
    }

    @Override
    public PropertyUIWidgetTextContentAssist createTextWithContentAssist(Composite parent, String value, int style, List<String> suggestions) {
        Text text = this.createText(parent, value, style);
        return new PropertyUIWidgetTextContentAssist(text, suggestions);
    }

    @Override
    public PropertyUIWidgetTextContentAssist createTextWithContentAssist(Composite parent, int style, List<String> suggestions) {
        return this.createTextWithContentAssist(parent, "", style, suggestions);
    }

    @Override
    public Text createText(Composite parent, int style) {
        return this.createText(parent, null, style);
    }

    @Override
    public ScrolledComposite createScrolledComposite(Composite parent, int style) {
        ScrollBar vbar;
        ScrolledComposite composite = new ScrolledComposite(parent, style);
        this.adapt((Composite)composite);
        ScrollBar hbar = composite.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(10);
            hbar.setPageIncrement(40);
        }
        if ((vbar = composite.getVerticalBar()) != null) {
            vbar.setIncrement(10);
            vbar.setPageIncrement(40);
        }
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        this.paintBordersFor((Composite)composite);
        return composite;
    }

    @Override
    public Group createGroup(Composite parent, String text, int style) {
        Group group = new Group(parent, 0x20 | style);
        if (text != null) {
            group.setText(text);
        }
        group.setBackground(this.getColors().getBackground());
        group.setForeground(this.getColors().getForeground());
        this.paintBordersFor((Composite)group);
        return group;
    }

    @Override
    public Group createGroup(Composite parent, int style) {
        return this.createGroup(parent, null, style);
    }

    @Override
    public Composite createCombo(Composite parent, int style) {
        CCombo combo = new CCombo(parent, 0x800000 | style);
        this.addFocusHandler((Control)combo);
        combo.setBackground(parent.getBackground());
        return combo;
    }

    @Override
    public Combo createNormalCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        this.addFocusHandler((Control)combo);
        return combo;
    }

    @Override
    public CCombo createCCombo(Composite parent, int style) {
        return (CCombo)this.createCombo(parent, style);
    }

    @Override
    public org.eclipse.swt.widgets.List createList(Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, this.getBorderStyle() | style);
        this.addFocusHandler((Control)list);
        return list;
    }

    @Override
    public FilteredList createFilteredList(Composite parent, int style, LabelProvider labelProvider, boolean ignoreCase, boolean allowDuplicates, boolean matchEmptyString) {
        FilteredList list = new FilteredList(parent, style, (ILabelProvider)labelProvider, ignoreCase, allowDuplicates, matchEmptyString);
        this.addFocusHandler((Control)list);
        return list;
    }

    @Override
    public Tree createTree(Composite parent, int style) {
        return super.createTree(parent, style);
    }

    @Override
    public TreeViewer createTreeViewer(Composite parent, int style) {
        return new TreeViewer(parent, this.getBorderStyle() | style);
    }

    @Override
    public TreeViewer createTreeViewer(Tree tree) {
        return new TreeViewer(tree);
    }

    @Override
    public TableViewer createTableViewer(Composite parent, int style) {
        return new TableViewer(parent, this.getBorderStyle() | style);
    }

    @Override
    public TableViewer createTableViewer(Table table) {
        return new TableViewer(table);
    }

    @Override
    public void addFocusHandler(Control control) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = new IPropertyUIWidgetFactory.FocusHandler();
        }
        control.removeFocusListener((FocusListener)this.focusHandler_);
        control.addFocusListener((FocusListener)this.focusHandler_);
    }

    @Override
    public CheckboxTreeViewer createCheckboxTreeViewer(Composite parent, int style) {
        return new CheckboxTreeViewer(parent, this.getBorderStyle() | style);
    }

    @Override
    public CheckboxTreeViewer createCheckboxTreeViewer(Tree tree) {
        return new CheckboxTreeViewer(tree);
    }

    @Override
    public SashForm createSashForm(Composite parent, int style) {
        SashForm form = new SashForm(parent, style);
        form.setFont(parent.getFont());
        form.setBackground(this.getColors().getBackground());
        form.setForeground(this.getColors().getForeground());
        this.paintBordersFor((Composite)form);
        return form;
    }

    @Override
    public ExpandableComposite createExpandableComposite(Composite parent, int expansionStyle) {
        ExpandableComposite excomposite = super.createExpandableComposite(parent, expansionStyle);
        this.paintBordersFor((Composite)excomposite);
        return excomposite;
    }

    @Override
    public PropertyUIScrollableComposite createPropertyUIScrollableComposite(Composite parent, int style) {
        PropertyUIScrollableComposite composite = new PropertyUIScrollableComposite(parent, style);
        this.adapt((Composite)composite);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        this.paintBordersFor((Composite)composite);
        return composite;
    }

    @Override
    public ToolBarViewer createToolBarViewer(Composite parent, int style) {
        ToolBarViewer composite = new ToolBarViewer(parent, style);
        this.adapt(composite);
        composite.setLayoutData(new GridData(768));
        this.paintBordersFor(composite);
        return composite;
    }

    @Override
    public ToolBarComposite createToolBarComposite(Composite parent, int style) {
        ToolBarComposite composite = new ToolBarComposite(parent, style);
        this.adapt(composite);
        composite.setLayoutData(new GridData(768));
        this.paintBordersFor(composite);
        return composite;
    }

    @Override
    public TabFolder createTabFolder(Composite parent, int style) {
        TabFolder tabFolder = new TabFolder(parent, style);
        this.adapt((Composite)tabFolder);
        this.paintBordersFor((Composite)tabFolder);
        return tabFolder;
    }

    @Override
    public TabItem createTabItem(TabFolder parent, int style) {
        return new TabItem(parent, style);
    }

    @Override
    public TabItem createTabItem(TabFolder parent, int style, int index) {
        return new TabItem(parent, style, index);
    }

    @Override
    public Section createSection(Composite parent, int style) {
        Section section = super.createSection(parent, style);
        section.setFont(parent.getFont());
        Control[] children = section.getChildren();
        if (children != null && children.length > 0) {
            this.addFocusHandler(children[0]);
        }
        return section;
    }

    @Override
    public Hyperlink createHyperlink(Composite parent, int style) {
        return this.createHyperlink(parent, null, style);
    }

    @Override
    public Hyperlink createHyperlink(Composite parent, String text, int style) {
        return super.createHyperlink(parent, text, style);
    }

    @Override
    public Hyperlink createUnderlinedHyperlink(Composite parent, int style) {
        return this.createUnderlinedHyperlink(parent, null, style);
    }

    @Override
    public Hyperlink createUnderlinedHyperlink(Composite parent, String text, int style) {
        Hyperlink link = this.createHyperlink(parent, text, style);
        link.setUnderlined(true);
        return link;
    }
}

