/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.api.IProjectWizardAccessor;
import com.ibm.propertygroup.ui.api.IPropertyGroupUIExtension;
import com.ibm.propertygroup.ui.api.IPropertyUIExtension;
import com.ibm.propertygroup.ui.internal.utilities.NewProjectExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.ProjectWizardInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;

public class PropertyUIExtensionRegistry {
    private static PropertyUIExtensionRegistry registry_;
    private Hashtable<String, IPropertyGroupUIExtension> propertyGroupExtensions_;
    private Map<String, List<IPropertyGroupUIExtension>> classLoaderSensitivePropertyGroupExtensions_ = Collections.synchronizedMap(new Hashtable());
    private Map<String, List<IPropertyUIExtension>> classLoaderSensitivePropertyExtensions_ = Collections.synchronizedMap(new Hashtable());
    private Hashtable<String, IPropertyUIExtension> propertyExtensions_;
    private Hashtable<String, PropertyInputExtensionPointInfo> propertyInputExtensions_;
    private Hashtable<String, NewProjectExtensionPointInfo> newProjectExtensions_ = null;

    public static PropertyUIExtensionRegistry instance() {
        if (registry_ == null) {
            registry_ = new PropertyUIExtensionRegistry();
        }
        return registry_;
    }

    public IPropertyGroupUIExtension getPropertyGroupUIExtension(String id) {
        return this.getPropertyGroupUIExtension(id, null);
    }

    public IPropertyGroupUIExtension getPropertyGroupUIExtension(String id, IPropertyGroup group) {
        IPropertyGroupUIExtension ext;
        block12: {
            List<IPropertyGroupUIExtension> list;
            ext = null;
            if (PropertyUIExtensionRegistry.registry_.propertyGroupExtensions_ == null || PropertyUIExtensionRegistry.registry_.propertyGroupExtensions_.isEmpty()) {
                Hashtable<String, IPropertyGroupUIExtension> local = new Hashtable<String, IPropertyGroupUIExtension>();
                IConfigurationElement[] pgExts = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.propertygroup.ui.PropertyGroupUIContributor");
                if (pgExts != null) {
                    int i = 0;
                    while (i < pgExts.length) {
                        IConfigurationElement ce = pgExts[i];
                        String attribute = ce.getAttribute("propertygroupID").trim();
                        Object classObj = null;
                        try {
                            classObj = ce.createExecutableExtension("className");
                            if (attribute != null && attribute.length() > 0 && classObj instanceof IPropertyGroupUIExtension) {
                                local.put(attribute, (IPropertyGroupUIExtension)classObj);
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                    if (!local.isEmpty()) {
                        ext = (IPropertyGroupUIExtension)local.get(id);
                        PropertyUIExtensionRegistry.registry_.propertyGroupExtensions_ = local;
                    }
                }
            } else {
                ext = PropertyUIExtensionRegistry.registry_.propertyGroupExtensions_.get(id);
            }
            if (ext == null && group != null && (list = this.classLoaderSensitivePropertyGroupExtensions_.get(id)) != null) {
                try {
                    Method method = group.getClass().getMethod("getWrappedPropertyGroup", null);
                    if (method == null) break block12;
                    Object wrappedPG = method.invoke((Object)group, null);
                    ClassLoader groupLoader = wrappedPG.getClass().getClassLoader();
                    for (IPropertyGroupUIExtension extension : list) {
                        if (extension.getClass().getClassLoader() != groupLoader) continue;
                        ext = extension;
                        break;
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return ext;
    }

    public IPropertyUIExtension getPropertyUIExtension(String id) {
        return this.getPropertyUIExtension(id, null);
    }

    public IPropertyUIExtension getPropertyUIExtension(String id, IPropertyDescriptor property) {
        IPropertyUIExtension ext;
        block12: {
            List<IPropertyUIExtension> list;
            ext = null;
            if (PropertyUIExtensionRegistry.registry_.propertyExtensions_ == null || PropertyUIExtensionRegistry.registry_.propertyExtensions_.isEmpty()) {
                Hashtable<String, IPropertyUIExtension> local = new Hashtable<String, IPropertyUIExtension>();
                IConfigurationElement[] pExts = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.propertygroup.ui.PropertyUIContributor");
                if (pExts != null) {
                    int i = 0;
                    while (i < pExts.length) {
                        IConfigurationElement ce = pExts[i];
                        String attribute = ce.getAttribute("propertyID").trim();
                        Object classObj = null;
                        try {
                            classObj = ce.createExecutableExtension("className");
                            if (attribute != null && attribute.length() > 0 && classObj instanceof IPropertyUIExtension) {
                                local.put(attribute, (IPropertyUIExtension)classObj);
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                    if (!local.isEmpty()) {
                        ext = (IPropertyUIExtension)local.get(id);
                        PropertyUIExtensionRegistry.registry_.propertyExtensions_ = local;
                    }
                }
            } else {
                ext = PropertyUIExtensionRegistry.registry_.propertyExtensions_.get(id);
            }
            if (ext == null && property != null && (list = this.classLoaderSensitivePropertyExtensions_.get(id)) != null) {
                try {
                    Method method = property.getClass().getMethod("getWrappedProperty", null);
                    if (method == null) break block12;
                    Object wrappedProperty = method.invoke((Object)property, null);
                    ClassLoader propLoader = wrappedProperty.getClass().getClassLoader();
                    for (IPropertyUIExtension extension : list) {
                        if (extension.getClass().getClassLoader() != propLoader) continue;
                        ext = extension;
                        break;
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return ext;
    }

    public PropertyInputExtensionPointInfo getPropertyInputExtension(String id) {
        PropertyInputExtensionPointInfo ext = null;
        if (PropertyUIExtensionRegistry.registry_.propertyInputExtensions_ == null || PropertyUIExtensionRegistry.registry_.propertyInputExtensions_.isEmpty()) {
            Hashtable<String, PropertyInputExtensionPointInfo> local = new Hashtable<String, PropertyInputExtensionPointInfo>();
            IConfigurationElement[] piExts = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.propertygroup.ui.PropertyInputContributor");
            if (piExts != null) {
                int i = 0;
                while (i < piExts.length) {
                    IConfigurationElement ce = piExts[i];
                    String attribute = ce.getAttribute("propertyID").trim();
                    String label = ce.getAttribute("buttonLabel");
                    String tooltip = ce.getAttribute("buttonToolTip");
                    String className = ce.getAttribute("className").trim();
                    if (attribute != null && attribute.length() > 0 && className != null && className.length() > 0) {
                        PropertyInputExtensionPointInfo info = new PropertyInputExtensionPointInfo();
                        if (label != null) {
                            label = label.trim();
                        }
                        info.setButtonLabel(label);
                        if (tooltip != null) {
                            tooltip = tooltip.trim();
                        }
                        info.setButtonToolTip(tooltip);
                        info.setInputClass(className);
                        info.setConfigurationElement(ce);
                        local.put(attribute, info);
                    }
                    ++i;
                }
                if (!local.isEmpty()) {
                    ext = (PropertyInputExtensionPointInfo)local.get(id);
                    PropertyUIExtensionRegistry.registry_.propertyInputExtensions_ = local;
                }
            }
        } else {
            ext = PropertyUIExtensionRegistry.registry_.propertyInputExtensions_.get(id);
        }
        return ext;
    }

    public void setPropertyInputExtension(String id, PropertyInputExtensionPointInfo extInfo) {
        if (this.getPropertyInputExtension(id) == null) {
            PropertyUIExtensionRegistry.registry_.propertyInputExtensions_.put(id, extInfo);
        }
    }

    public NewProjectExtensionPointInfo getNewProjectExtension(String id) {
        NewProjectExtensionPointInfo ext = null;
        if (PropertyUIExtensionRegistry.registry_.newProjectExtensions_ == null || PropertyUIExtensionRegistry.registry_.newProjectExtensions_.isEmpty()) {
            Hashtable<String, NewProjectExtensionPointInfo> local = new Hashtable<String, NewProjectExtensionPointInfo>();
            IConfigurationElement[] projectExts = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.propertygroup.ui.NewProjectContributor");
            if (projectExts != null) {
                int i = 0;
                while (i < projectExts.length) {
                    IConfigurationElement[] children;
                    IConfigurationElement ce = projectExts[i];
                    String attribute = ce.getAttribute("propertyID").trim();
                    String helpID = ce.getAttribute("InfoPopContextHelpID");
                    ArrayList<ProjectWizardInfo> projects = null;
                    NewProjectExtensionPointInfo extInfo = null;
                    if (attribute != null && attribute.length() > 0 && (extInfo = (NewProjectExtensionPointInfo)local.get(attribute)) != null) {
                        projects = extInfo.getProjectsInfo();
                    }
                    if ((children = ce.getChildren("ProjectWizardConfiguration")).length > 0 && projects == null) {
                        projects = new ArrayList(6);
                    }
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        ProjectWizardInfo info = null;
                        String displayName = child.getAttribute("displayName").trim();
                        String className = child.getAttribute("className").trim();
                        try {
                            Object wizard = child.createExecutableExtension("className");
                            Object accessor = child.createExecutableExtension("accessorClass");
                            if (displayName != null && displayName.length() > 0 && wizard != null && wizard instanceof IWizard && accessor != null && accessor instanceof IProjectWizardAccessor) {
                                info = new ProjectWizardInfo();
                                info.setDisplayName(displayName);
                                info.setWizardClass(className);
                                info.setAccessor((IProjectWizardAccessor)accessor);
                                info.setConfigurationElement(child);
                            }
                        }
                        catch (CoreException coreException) {}
                        if (info != null) {
                            projects.add(info);
                        }
                        ++j;
                    }
                    if (projects != null && projects.size() > 0 && attribute != null && attribute.length() > 0 && extInfo == null) {
                        extInfo = new NewProjectExtensionPointInfo();
                        if (extInfo.getHelpContextID() == null && helpID != null) {
                            extInfo.setHelpContextID(helpID.trim());
                        }
                        extInfo.setProjectsInfo(projects);
                        local.put(attribute, extInfo);
                    }
                    ++i;
                }
                if (!local.isEmpty()) {
                    ext = (NewProjectExtensionPointInfo)local.get(id);
                    PropertyUIExtensionRegistry.registry_.newProjectExtensions_ = local;
                }
            }
        } else {
            ext = PropertyUIExtensionRegistry.registry_.newProjectExtensions_.get(id);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyUIExtension(String id, IPropertyUIExtension instanceClass) {
        Map<String, List<IPropertyUIExtension>> map = this.classLoaderSensitivePropertyExtensions_;
        synchronized (map) {
            List<IPropertyUIExtension> list = this.classLoaderSensitivePropertyExtensions_.get(id);
            if (list == null) {
                list = new ArrayList<IPropertyUIExtension>();
                this.classLoaderSensitivePropertyExtensions_.put(id, list);
            }
            list.add(instanceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyUIExtension(String id, IPropertyUIExtension instanceClass) {
        Map<String, List<IPropertyUIExtension>> map = this.classLoaderSensitivePropertyExtensions_;
        synchronized (map) {
            List<IPropertyUIExtension> list = this.classLoaderSensitivePropertyExtensions_.get(id);
            if (list != null) {
                ClassLoader loader = instanceClass.getClass().getClassLoader();
                IPropertyUIExtension extToRemove = null;
                for (IPropertyUIExtension ext : list) {
                    if (ext.getClass().getClassLoader() != loader) continue;
                    extToRemove = ext;
                    break;
                }
                if (extToRemove != null) {
                    list.remove(extToRemove);
                    if (list.isEmpty()) {
                        this.classLoaderSensitivePropertyExtensions_.remove(id);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyGroupUIExtension(String id, IPropertyGroupUIExtension instanceClass) {
        Map<String, List<IPropertyGroupUIExtension>> map = this.classLoaderSensitivePropertyGroupExtensions_;
        synchronized (map) {
            List<IPropertyGroupUIExtension> list = this.classLoaderSensitivePropertyGroupExtensions_.get(id);
            if (list == null) {
                list = new ArrayList<IPropertyGroupUIExtension>();
                this.classLoaderSensitivePropertyGroupExtensions_.put(id, list);
            }
            list.add(instanceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyGroupUIExtension(String id, IPropertyGroupUIExtension instanceClass) {
        Map<String, List<IPropertyGroupUIExtension>> map = this.classLoaderSensitivePropertyGroupExtensions_;
        synchronized (map) {
            List<IPropertyGroupUIExtension> list = this.classLoaderSensitivePropertyGroupExtensions_.get(id);
            if (list != null) {
                ClassLoader loader = instanceClass.getClass().getClassLoader();
                IPropertyGroupUIExtension extToRemove = null;
                for (IPropertyGroupUIExtension ext : list) {
                    if (ext.getClass().getClassLoader() != loader) continue;
                    extToRemove = ext;
                    break;
                }
                if (extToRemove != null) {
                    list.remove(extToRemove);
                    if (list.isEmpty()) {
                        this.classLoaderSensitivePropertyGroupExtensions_.remove(id);
                    }
                }
            }
        }
    }
}

