/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.dialogs;

import com.ibm.propertygroup.ui.internal.jobs.FetchTypesFromXSDRunnable;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.providers.XSDTypeSearchLabelProvider;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDTypeSearchDialog
extends TwoPaneElementSelector {
    private Text xsdFileLocation;
    private boolean enableOk = false;

    public XSDTypeSearchDialog(Shell parent, boolean supportMultiSelect) {
        super(parent, (ILabelProvider)new XSDTypeSearchLabelProvider(false), (ILabelProvider)new XSDTypeSearchLabelProvider(true));
        this.setMultipleSelection(supportMultiSelect);
    }

    protected Label createMessageArea(Composite composite) {
        GridData data = new GridData();
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        Composite comp = new Composite(composite, 0);
        GridLayout lay = new GridLayout();
        lay.numColumns = 3;
        comp.setLayout((Layout)lay);
        comp.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        Label la = new Label(comp, 0);
        la.setLayoutData((Object)data);
        la.setText(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_XSD_FILE_LABEL);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.xsdFileLocation = new Text(comp, 2048);
        this.xsdFileLocation.setLayoutData((Object)data);
        this.xsdFileLocation.setEditable(false);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        Button browseForXSDFile = new Button(comp, 0);
        browseForXSDFile.setLayoutData((Object)data);
        browseForXSDFile.setText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_BROWSE);
        browseForXSDFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String[] exts = new String[]{"xsd"};
                IFile fil = PropertyUIHelper.instance().browsePlatformFile(XSDTypeSearchDialog.this.getShell(), "", exts);
                if (fil != null) {
                    XSDTypeSearchDialog.this.enableOk = true;
                    String res = fil.getRawLocation().toString();
                    FetchTypesFromXSDRunnable rr = new FetchTypesFromXSDRunnable(res);
                    Object[] test = new Object[]{};
                    if (res != null && res.length() > 0) {
                        ProgressMonitorDialog dia = new ProgressMonitorDialog(XSDTypeSearchDialog.this.getShell());
                        try {
                            dia.run(true, true, (IRunnableWithProgress)rr);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        catch (InvocationTargetException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (rr.getXSDTypes() != null) {
                        test = rr.getXSDTypes();
                        XSDTypeSearchDialog.this.setListElements(test);
                    }
                    IPath pa = fil.getProjectRelativePath();
                    pa = new Path(fil.getProject().getName()).append(pa);
                    XSDTypeSearchDialog.this.xsdFileLocation.setText(pa.toString());
                }
            }
        });
        Label label = super.createMessageArea(composite);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.enableOk) {
            super.updateButtonsEnableState(status);
        } else {
            Button okButton = this.getOkButton();
            if (okButton != null && !okButton.isDisposed()) {
                okButton.setEnabled(false);
            }
        }
    }

    public QName[] getXSDTypeQNames() {
        Object[] ress = this.getResult();
        if (ress != null && ress.length > 0) {
            ArrayList<QName> lst = new ArrayList<QName>();
            int i = 0;
            while (i < ress.length) {
                XSDTypeDefinition def;
                Object o = ress[i];
                if (o instanceof XSDTypeDefinition && (def = (XSDTypeDefinition)o) != null) {
                    QName qn = new QName(def.getTargetNamespace(), def.getName());
                    lst.add(qn);
                }
                ++i;
            }
            QName[] qns = new QName[lst.size()];
            qns = lst.toArray(qns);
            return qns;
        }
        return null;
    }

    public String[] getXSDTypeQNamesAsStrings() {
        QName[] qns = this.getXSDTypeQNames();
        if (qns != null) {
            String[] names = new String[qns.length];
            int i = 0;
            while (i < qns.length) {
                QName qn = qns[i];
                names[i] = qn.toString();
                ++i;
            }
            return names;
        }
        return null;
    }

    public int open() {
        Object[] sT = new String[]{PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_SELECT_FILE};
        this.setElements(sT);
        this.setTitle(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_TITLE);
        this.setLowerListLabel(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_NAMESPACE_TABLE);
        this.setUpperListLabel(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_TYPES_TABLE);
        this.setMessage(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_FILTER);
        return super.open();
    }
}

