/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.dialogs;

import com.ibm.j2c.ui.base.Activator;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.datastores.DynamicPropStore;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTree;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIStatusChangedEvent;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIHelpRegistry;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PropertyGroupDialog
extends TitleAreaDialog
implements IPropertyUIChangeListener,
IPropertyUIStatusChangedListener {
    protected IPropertyGroup propertyGroup_ = null;
    protected DynamicPropStore iStore_;
    protected String dialogName_ = null;
    protected Image titleImage_ = null;
    protected String windowTitle_;
    protected String pageTitle_;
    protected String pageDescription_;
    protected PropertyUIComposite uiComposite_;
    protected Point defaultContentSize_;
    protected Point defaultShellSize_;
    protected PropertyUIScrollableComposite scroller_;
    protected int maxHeight_ = 680;
    protected Composite composite = null;
    protected String helpContextID_ = null;

    public PropertyGroupDialog(AbstractUIPlugin plugin, Shell parentShell, String dialogName, String windowTitle, String pageTitle, String pageDescription, ImageDescriptor imageDescriptor, IPropertyGroup pg) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(67696);
        this.dialogName_ = dialogName;
        this.windowTitle_ = windowTitle;
        this.pageTitle_ = pageTitle;
        this.pageDescription_ = pageDescription;
        this.propertyGroup_ = pg;
        ImageDescriptor iDescriptor = imageDescriptor == null ? Activator.getImageDescriptor("icons/wizban/default_wiz.gif") : imageDescriptor;
        this.titleImage_ = iDescriptor.createImage();
        this.iStore_ = new DynamicPropStore(plugin);
    }

    public PropertyGroupDialog(AbstractUIPlugin plugin, Shell parentShell, String dialogName, String windowTitle, String pageTitle, String pageDescription, ImageDescriptor imageDescriptor, IPropertyGroup pg, String helpContextID) {
        this(plugin, parentShell, dialogName, windowTitle, pageTitle, pageDescription, imageDescriptor, pg);
        this.helpContextID_ = helpContextID;
    }

    protected void initStore() {
    }

    @Override
    public void propertyUIChange(PropertyUIChangeEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            PropertyUIWidget widget = (PropertyUIWidget)evt.getSource();
            int status = widget.getStatus();
            if (status != 4) {
                this.setErrorMessage(null);
                this.setMessage(this.pageDescription_);
                if (this.validateWidgets(this.uiComposite_.getUIWidgets(), true)) {
                    this.getButton(0).setEnabled(true);
                } else {
                    this.getButton(0).setEnabled(false);
                }
            } else {
                this.setErrorMessage(widget.getErrorMessage());
                this.getButton(0).setEnabled(false);
            }
        }
    }

    @Override
    public void propertyUIStatusChanged(PropertyUIStatusChangedEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidgetTree) {
            this.updateSize();
        }
    }

    public boolean validateWidgets(boolean setMessage) {
        return this.validateWidgets(this.uiComposite_.getUIWidgets(), setMessage);
    }

    public boolean validateWidgets(ArrayList widgets, boolean setMessage) {
        boolean hasWarning = false;
        if (widgets == null) {
            return true;
        }
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
            int status = widget.getStatus();
            switch (status) {
                case 4: {
                    if (setMessage) {
                        this.setErrorMessage(widget.getErrorMessage());
                    }
                    return false;
                }
                case 2: {
                    if (hasWarning) break;
                    if (setMessage) {
                        this.setMessage(widget.getErrorMessage(), 2);
                    }
                    hasWarning = true;
                    break;
                }
                case 1: {
                    if (hasWarning) break;
                    if (setMessage) {
                        this.setMessage(widget.getErrorMessage(), 1);
                    }
                    hasWarning = true;
                    break;
                }
            }
            ++i;
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        PropertyUIFactory uiEngine = PropertyUIFactory.newInstance(true);
        IPropertyUIWidgetFactory factory = uiEngine.getUIFactory();
        this.composite = factory.createComposite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        if (this.helpContextID_ != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, this.helpContextID_);
            PropertyUIHelpRegistry.instance().setGenerateDynamicF1IDs(false);
        }
        this.scroller_ = factory.createPropertyUIScrollableComposite(this.composite, 768);
        this.scroller_.setLayout((Layout)new GridLayout());
        this.scroller_.setLayoutData(new GridData(1808));
        uiEngine.setRootGroupingStyle(1);
        this.uiComposite_ = uiEngine.generatePropertyUI((Composite)this.scroller_, this.propertyGroup_);
        this.uiComposite_.addPropertyUIChangeListener(this);
        this.uiComposite_.addPropertyUIStatusChangedListener(this);
        this.scroller_.setContent((Control)this.uiComposite_.getComposite());
        this.scroller_.reflow(true);
        this.defaultContentSize_ = this.scroller_.getContent().computeSize(-1, -1);
        Button advancedButton = this.uiComposite_.getAdvancedButton();
        if (advancedButton != null) {
            advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyGroupDialog.this.showAdvancedSection(PropertyGroupDialog.this.propertyGroup_);
                }
            });
        }
        this.getShell().setText(this.windowTitle_);
        this.setTitle(this.pageTitle_);
        if (this.titleImage_ != null) {
            this.setTitleImage(this.titleImage_);
        }
        this.setMessage(this.pageDescription_);
        this.loadDefaultValues();
        return this.composite;
    }

    public void showAdvancedSection(IPropertyGroup properties) {
        if (this.uiComposite_.isShowingAll()) {
            this.restoreFromStore(this.uiComposite_.getUIWidgets(), properties);
            if (this.defaultShellSize_ == null) {
                Shell shell = this.getShell();
                this.defaultShellSize_ = shell.getSize();
                Point shellLocation = shell.getLocation();
                if (this.defaultShellSize_.y < this.maxHeight_) {
                    Point newSize = ((Composite)this.scroller_.getContent()).computeSize(-1, -1);
                    int newX = newSize.x - this.defaultContentSize_.x + this.defaultShellSize_.x;
                    int newY = Math.min(newSize.y - this.defaultContentSize_.y + this.defaultShellSize_.y, this.maxHeight_);
                    if (newX > 0 && newY > 0) {
                        shell.setBounds(this.getConstrainedShellBounds(new Rectangle(shellLocation.x, shellLocation.y, newX, newY)));
                    }
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control aControl = super.createContents(parent);
        if (this.validateWidgets(this.uiComposite_.getUIWidgets(), false)) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
        this.setFocusToWidget();
        return aControl;
    }

    public void setFocusToWidget() {
        ArrayList<PropertyUIWidget> widgets = this.uiComposite_.getUIWidgets();
        if (widgets != null) {
            for (PropertyUIWidget widget : widgets) {
                if (widget.setFocus()) break;
            }
        }
    }

    public int open() {
        int rc = super.open();
        this.saveToStore();
        return rc;
    }

    protected void initializesBounds() {
        Rectangle r1 = this.getShell().getBounds();
        Rectangle r2 = this.getParentShell().getBounds();
        if (r1.width > r2.width) {
            int diff = r1.width - r2.width;
            r1.width = r2.width;
            r1.x += diff / 2;
        }
        if (r1.height > r2.height) {
            r1.height = r2.height;
        }
        this.getShell().setBounds(r1);
    }

    public void saveToStore() {
        this.iStore_.storePropertyValues(this.dialogName_, this.propertyGroup_);
    }

    public void loadDefaultValues() {
        this.restoreFromStore(this.uiComposite_.getUIWidgets(), this.propertyGroup_);
    }

    public void restoreFromStore(ArrayList widgets, IPropertyGroup properties) {
        if (widgets != null && !widgets.isEmpty()) {
            this.iStore_.restoreSuggestionsOnWidgets(this.dialogName_, widgets);
        }
    }

    public void dispose() {
    }

    public boolean close() {
        this.saveToStore();
        if (this.helpContextID_ != null) {
            PropertyUIHelpRegistry.instance().setGenerateDynamicF1IDs(true);
        }
        boolean ret = super.close();
        if (this.titleImage_ != null && !this.titleImage_.isDisposed()) {
            this.titleImage_.dispose();
        }
        if (this.uiComposite_ != null) {
            this.uiComposite_.dispose();
        }
        return ret;
    }

    public void updateSize() {
        this.updateSizeForPage();
        this.composite.layout(true);
        this.scroller_.reflow(true);
    }

    private void updateSizeForPage() {
        Point delta = this.calculatePageSizeDelta();
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
            this.constrainShellSize();
        }
    }

    private Point calculatePageSizeDelta() {
        if (this.composite == null) {
            return new Point(0, 0);
        }
        Point contentSize = this.composite.computeSize(-1, -1, true);
        Rectangle rect = this.getClientArea(this.composite);
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    public Rectangle getClientArea(Composite c) {
        GridLayout gl = (GridLayout)c.getLayout();
        Rectangle rect = c.getClientArea();
        rect.x += gl.marginWidth;
        rect.y += gl.marginHeight;
        rect.width -= 2 * gl.marginWidth;
        rect.height -= 2 * gl.marginHeight;
        return rect;
    }

    private void setShellSize(int width, int height) {
        Rectangle size = this.getShell().getBounds();
        size.height = height;
        size.width = width;
        this.getShell().setBounds(this.getConstrainedShellBounds(size));
    }

    public PropertyUIComposite getUIComposite() {
        return this.uiComposite_;
    }
}

