/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.codegen.writer.properties;

import com.ibm.adapter.j2c.codegen.writer.properties.MethodNameProperty;
import com.ibm.adapter.j2c.codegen.writer.properties.OperationsTableProperty;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.j2c.ui.base.Activator;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import commonj.connector.metadata.description.FunctionDescription;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class OperationNamePropertyGroup
extends BasePropertyGroup {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005, 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    public static final String OPERATION_NAME_PG_NAME = "OPERATION_NAME_PG";
    public static final String OPERATION_NAME_PG_ID = "com.ibm.adapter.j2c.codegen.writer.properties.OperationNamePropertyGroup";
    private OperationsTableProperty tp_;
    private HashMap<String, String> functionsMap = new HashMap();
    public String editOperationText;

    public OperationNamePropertyGroup(FunctionDescription[] functions) throws CoreException {
        super(OPERATION_NAME_PG_NAME, MessageResource.METHOD_TREE_PG_DISPLAY_NAME, MessageResource.METHOD_TREE_PG_DESCRIPTION);
        this.assignID(OPERATION_NAME_PG_ID);
        this.tp_ = new OperationsTableProperty(this);
        int i = 0;
        while (i < functions.length) {
            FunctionDescription functionDescription = functions[i];
            ITableCellProperty[] tableCellProperty = this.getTableProperty().createNewRow();
            String functionName = functionDescription.getName();
            tableCellProperty[0].setValueAsString(functionDescription.getName());
            tableCellProperty[1].setValueAsString(functionDescription.getComment());
            this.functionsMap.put(functionName, functionName);
            ++i;
        }
        this.tp_.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public OperationNamePropertyGroup(String operationText, FunctionDescription[] functions) throws CoreException {
        super(OPERATION_NAME_PG_NAME, MessageResource.METHOD_TREE_PG_DISPLAY_NAME, MessageResource.METHOD_TREE_PG_DESCRIPTION);
        this.assignID(OPERATION_NAME_PG_ID);
        this.editOperationText = operationText;
        this.tp_ = new OperationsTableProperty(this);
        int i = 0;
        while (i < functions.length) {
            FunctionDescription functionDescription = functions[i];
            ITableCellProperty[] tableCellProperty = this.getTableProperty().createNewRow();
            String functionName = functionDescription.getName();
            tableCellProperty[0].setValueAsString(functionDescription.getName());
            tableCellProperty[1].setValueAsString(functionDescription.getComment());
            this.functionsMap.put(functionName, functionName);
            ++i;
        }
        this.tp_.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0 && evt.getSource() instanceof ITableCellProperty) {
            ITableCellProperty property = (ITableCellProperty)evt.getSource();
            if (!property.getName().equals(MethodNameProperty.METHOD_NAME_PROPERTY_NAME)) {
                return;
            }
            String oldName = (String)evt.getOldValue();
            String newName = (String)evt.getNewValue();
            this.functionsMap.put(oldName, newName);
            this.propertyChanges.firePropertyValueChange((Object)oldName, (Object)newName);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OperationsTableProperty tableProp;
        OperationNamePropertyGroup group = (OperationNamePropertyGroup)((Object)super.clone());
        group.tp_ = tableProp = (OperationsTableProperty)group.getProperty(OperationsTableProperty.OPERATIONS_TABLE_PROPERTY_NAME);
        group.functionsMap = (HashMap)group.functionsMap.clone();
        group.tp_.addPropertyChangeListener((IPropertyChangeListener)group);
        return group;
    }

    public OperationsTableProperty getTableProperty() {
        return this.tp_;
    }

    public Map<String, String> getFunctionsMap() {
        return this.functionsMap;
    }

    public String convertToString() {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(this.getPGOpeningTag(this.getName(), null));
        Iterator<String> keyIter = this.functionsMap.keySet().iterator();
        while (keyIter.hasNext()) {
            String nextKey = keyIter.next();
            pgstring.append(nextKey);
            pgstring.append("\u21c2");
            pgstring.append(this.functionsMap.get(nextKey));
            pgstring.append("\u21c2");
            pgstring.append(this.getOperationDescription(this.functionsMap.get(nextKey)));
            if (!keyIter.hasNext()) continue;
            pgstring.append("\u21c3");
        }
        pgstring.append(this.getPGClosingTag(this.getName()));
        return pgstring.toString();
    }

    private String getOperationDescription(Object newOpName) {
        try {
            int rows = this.tp_.rowCount();
            int i = 0;
            while (i < rows) {
                ITableCellProperty[] cells = this.tp_.getRowProperties(i);
                if (cells[0] != null && cells[0].getValue().equals(newOpName) && cells[1] != null) {
                    return cells[1].getValueAsString();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    public void populateFromString(String value) throws CoreException {
        String pgContents = this.extractGroupString(this.getName(), value);
        String[] props = pgContents.split("\u21c3");
        int i = 0;
        while (i < props.length) {
            String[] nameValue = props[i].split("\u21c2");
            if (this.functionsMap.get(nameValue[0]) == null || this.functionsMap.get(nameValue[0]) != null && !this.functionsMap.get(nameValue[0]).equals(nameValue[1])) {
                this.functionsMap.put(nameValue[0], nameValue[1]);
            }
            this.updateTableProperty(nameValue);
            ++i;
        }
    }

    private void updateTableProperty(String[] nameValue) {
        try {
            int rows = this.tp_.rowCount();
            int i = 0;
            while (i < rows) {
                ITableCellProperty[] cells = this.tp_.getRowProperties(i);
                if (cells[0] != null && cells[0].getValueAsString().equals(nameValue[0])) {
                    cells[0].setValueAsString(nameValue[1]);
                    if (nameValue[2] != null && !nameValue[2].equalsIgnoreCase("null")) {
                        cells[1].setValueAsString(nameValue[2]);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void resetID() {
        this.propertyID = "DEFAULT_PROPERTY_IDENTIFIER";
    }
}

