/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.ddlgen.internal.ui.wizards;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.ProfileManager;
import com.ibm.ims.datatools.connectivity.drivers.DriverInstance;
import com.ibm.ims.datatools.connectivity.drivers.DriverManager;
import com.ibm.ims.datatools.sqltools.ddlgen.internal.ui.util.ResourceLoader;
import com.ibm.ims.datatools.sqltools.ddlgen.internal.ui.wizards.ConnectionDisplayProperty;
import com.ibm.ims.datatools.sqltools.ddlgen.internal.ui.wizards.ExistingConnectionProfilesDialogPage;
import com.ibm.ims.datatools.sqltools.ddlgen.internal.ui.wizards.FESpecifyExistingConnectionsWizardPage;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.widgets.Event;

public class FESpecifyExistingConnectionsDialogPage
extends ExistingConnectionProfilesDialogPage {
    private String allowedVendor = null;
    private String allowedVersion = null;
    private FESpecifyExistingConnectionsWizardPage page;

    public FESpecifyExistingConnectionsDialogPage(FESpecifyExistingConnectionsWizardPage page, boolean isShowProperties, boolean isPropertiesSectionExpanded) {
        super(isShowProperties, isPropertiesSectionExpanded);
        this.page = page;
    }

    public void setAllowedVendor(String allowedVendor) {
        this.allowedVendor = allowedVendor;
    }

    public void setAllowedVersion(String allowedVersion) {
        this.allowedVersion = allowedVersion;
    }

    @Override
    protected ConnectionDisplayProperty[] updateConnectionDisplayProperties(IConnectionProfile connectionProfile, ConnectionDisplayProperty[] defaultDisplayProperties) {
        ConnectionDisplayProperty[] properties = null;
        Vector<ConnectionDisplayProperty> propertiesCollection = new Vector<ConnectionDisplayProperty>();
        propertiesCollection.addAll(Arrays.asList(defaultDisplayProperties));
        Properties baseProperties = connectionProfile.getBaseProperties();
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.databasePropertyName"), (String)baseProperties.get("com.ibm.ims.datatools.connectivity.db.databaseName")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.jdbcDriverClassPropertyName"), (String)baseProperties.get("com.ibm.ims.datatools.connectivity.db.driverClass")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.classLocationPropertyName"), this.getJarList(connectionProfile)));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.connectionURLPropertyName"), (String)baseProperties.get("com.ibm.ims.datatools.connectivity.db.URL")));
        propertiesCollection.add(new ConnectionDisplayProperty(ResourceLoader.INSTANCE.queryString("FEWizard.SpecifyExistingConnectionPage.userIDPropertyName"), (String)baseProperties.get("com.ibm.ims.datatools.connectivity.db.username")));
        properties = new ConnectionDisplayProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        return properties;
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        this.page.handleEvent(event);
    }

    private String getJarList(IConnectionProfile connectionProfile) {
        String jarList = "";
        DriverInstance driverInstance = null;
        String driverID = connectionProfile.getBaseProperties().getProperty("com.ibm.ims.datatools.connectivity.driverDefinitionID");
        if (driverID != null && (driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverID)) != null) {
            jarList = driverInstance.getJarList();
        }
        return jarList;
    }

    @Override
    protected IConnectionProfile[] getConnectionsToDisplay() {
        Vector<IConnectionProfile> filteredProfilesCollection = new Vector<IConnectionProfile>();
        Object[] filteredProfiles = new IConnectionProfile[]{};
        IConnectionProfile[] allProfiles = ProfileManager.getInstance().getProfiles(false);
        int infoLength = allProfiles.length;
        if (infoLength > 0) {
            int index = 0;
            while (index < infoLength) {
                Map factories = allProfiles[index].getProvider().getConnectionFactories();
                if (factories != null && factories.containsKey("java.sql.Connection")) {
                    Properties properties = allProfiles[index].getBaseProperties();
                    String vendor = properties.getProperty("com.ibm.ims.datatools.connectivity.db.vendor");
                    String version = properties.getProperty("com.ibm.ims.datatools.connectivity.db.version");
                    if (vendor != null && version != null && vendor.equals(this.allowedVendor)) {
                        filteredProfilesCollection.add(allProfiles[index]);
                    }
                }
                filteredProfiles = new IConnectionProfile[filteredProfilesCollection.size()];
                filteredProfilesCollection.copyInto(filteredProfiles);
                ++index;
            }
        }
        return filteredProfiles;
    }
}

