/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.parsers.sql.query.postparse;

import com.ibm.ims.datatools.modelbase.sql.query.CallStatement;
import com.ibm.ims.datatools.modelbase.sql.query.ProcedureReference;
import com.ibm.ims.datatools.modelbase.sql.query.SQLQueryObject;
import com.ibm.ims.datatools.modelbase.sql.query.helper.DatabaseHelper;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParserException;
import com.ibm.ims.datatools.sqltools.parsers.sql.postparse.PostParseProcessor;
import com.ibm.ims.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import com.ibm.ims.datatools.sqltools.parsers.sql.query.SQLQueryParserMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class RoutineReferenceResolver
implements PostParseProcessor {
    protected static Class[] CANDIDATE_TYPES = new Class[]{CallStatement.class};
    protected static final String ERROR_MESSAGE_KEY_UNRESOLVED_PROCEDURE = "RoutineReferenceResolver.UNRESOLVED_PROC";
    protected static final String ERROR_MESSAGE_KEY_INCORRECT_PARM_COUNT = "RoutineReferenceResolver.INCORRECT_PARM_COUNT";
    private Database fDatabase = null;
    private String fDefaultSchemaName = null;

    public RoutineReferenceResolver() {
        this(null, null);
    }

    public RoutineReferenceResolver(Database database) {
        this(database, null);
    }

    public RoutineReferenceResolver(Database database, String defaultSchemaName) {
        this.setDatabase(database);
        this.setDefaultSchemaName(defaultSchemaName);
    }

    public Database getDatabase() {
        return this.fDatabase;
    }

    public void setDatabase(Database database) {
        this.fDatabase = database;
    }

    public String getDefaultSchemaName() {
        return this.fDefaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.fDefaultSchemaName = defaultSchemaName;
    }

    public Class[] getProcessCandidateTypes() {
        return CANDIDATE_TYPES;
    }

    public void config(PostParseProcessorConfiguration config) {
        if (config != null) {
            this.setDatabase(config.getDatabase());
            this.setDefaultSchemaName(config.getDefaultSchemaName());
        }
    }

    public List process(SQLQueryObject queryObj) throws SQLParserException {
        ArrayList<SQLParseErrorInfo> errorList = new ArrayList<SQLParseErrorInfo>();
        Database database = this.getDatabase();
        if (database != null && queryObj instanceof CallStatement) {
            String tempSchemaName;
            CallStatement callStmt = (CallStatement)queryObj;
            String defaultSchemaName = this.getDefaultSchemaName();
            SQLQuerySourceInfo sourceInfo = callStmt.getSourceInfo();
            if (sourceInfo != null && sourceInfo.getSqlFormat() != null && (tempSchemaName = sourceInfo.getSqlFormat().getOmitSchema()) != null && tempSchemaName.trim().length() > 0) {
                defaultSchemaName = tempSchemaName;
            }
            ProcedureReference procRef = callStmt.getProcedureRef();
            Procedure tempProc = null;
            String procName = null;
            Schema tempSchema = null;
            String schemaName = null;
            if (procRef != null && (tempProc = procRef.getProcedure()) != null) {
                procName = tempProc.getName();
                tempSchema = tempProc.getSchema();
                if (tempSchema != null) {
                    schemaName = tempSchema.getName();
                }
            }
            if (schemaName == null) {
                schemaName = defaultSchemaName;
            }
            Schema rdbSchema = DatabaseHelper.findSchema((Database)database, (String)schemaName);
            Procedure rdbProc = null;
            if (rdbSchema != null) {
                rdbProc = DatabaseHelper.findProcedure((Schema)rdbSchema, (String)procName);
            }
            if (rdbProc == null) {
                String errMsg = SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_UNRESOLVED_PROCEDURE, null);
                SQLParseErrorInfo errInfo = new SQLParseErrorInfo(0, 0, 0, 0, null, null, errMsg, ERROR_MESSAGE_KEY_UNRESOLVED_PROCEDURE);
                errorList.add(errInfo);
            } else {
                int argCount = 0;
                EList argList = callStmt.getArgumentList();
                if (argList != null) {
                    argCount = argList.size();
                }
                int parmCount = 0;
                EList parmList = rdbProc.getParameters();
                if (parmList != null) {
                    parmCount = parmList.size();
                }
                if (argCount != parmCount) {
                    String[] errMsgArgs = new String[]{Integer.toString(parmCount), Integer.toString(argCount)};
                    String errMsg = SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_INCORRECT_PARM_COUNT, errMsgArgs);
                    SQLParseErrorInfo errInfo = new SQLParseErrorInfo(0, 0, 0, 0, null, null, errMsg, ERROR_MESSAGE_KEY_INCORRECT_PARM_COUNT);
                    errorList.add(errInfo);
                } else {
                    procRef.setProcedure(rdbProc);
                }
            }
        }
        return errorList;
    }

    public Map getParsedObjectsReplacementMap() {
        return null;
    }

    public void resetState() {
    }
}

