/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.parsers.sql.query;

import com.ibm.ims.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import com.ibm.ims.datatools.sqltools.parsers.sql.query.SQLQueryParserPlugin;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SQLQueryParserManagerProvider {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Map dbProductMap = new HashMap();
    private static SQLQueryParserManagerProvider instance = null;

    private SQLQueryParserManagerProvider() {
    }

    public static SQLQueryParserManagerProvider getInstance() {
        if (instance == null) {
            instance = new SQLQueryParserManagerProvider();
        }
        return instance;
    }

    public SQLQueryParserManager getParserManager(String dbProduct, String dbVersion) {
        SQLQueryParserManager parserManager = null;
        String parserManagerClassName = null;
        if (dbProduct != null && dbProduct.length() > 0 && this.dbProductMap.containsKey(dbProduct)) {
            HashMap dbProductVersionMap = (HashMap)this.dbProductMap.get(dbProduct);
            if (dbProductVersionMap.containsKey(dbVersion)) {
                parserManagerClassName = (String)dbProductVersionMap.get(dbVersion);
            } else if (dbProductVersionMap.size() == 1 && dbProductVersionMap.containsKey(null)) {
                parserManagerClassName = (String)dbProductVersionMap.get(null);
            } else if (dbProductVersionMap.containsKey(null)) {
                parserManagerClassName = (String)dbProductVersionMap.get(null);
            } else if (!dbProductVersionMap.isEmpty()) {
                parserManagerClassName = (String)dbProductVersionMap.values().iterator().next();
            }
        }
        if (parserManagerClassName != null) {
            parserManager = SQLQueryParserPlugin.getDefault().instanciateParserManager(parserManagerClassName);
        }
        if (parserManager == null) {
            parserManager = new SQLQueryParserManager();
        }
        return parserManager;
    }

    public void clearParserManagerRegistry() {
        if (this.dbProductMap != null) {
            this.dbProductMap.clear();
        }
    }

    public void registerParserManager(String parserManagerClassName, String dbProduct, String fromDbVersion, String toDbVersion) {
        if (dbProduct != null && dbProduct.length() > 0) {
            HashMap dbVersionToPMClassNameMap;
            if (toDbVersion != null && toDbVersion.trim().length() == 0) {
                toDbVersion = null;
            }
            if (!this.dbProductMap.containsKey(dbProduct)) {
                this.dbProductMap.put(dbProduct, new HashMap());
            }
            if ((dbVersionToPMClassNameMap = (HashMap)this.dbProductMap.get(dbProduct)).containsKey(toDbVersion)) {
                String registeredPMClassName = (String)dbVersionToPMClassNameMap.get(toDbVersion);
                logger.error("conflicting parser extensions for " + dbProduct + " " + toDbVersion + ": " + registeredPMClassName + " != " + parserManagerClassName, new Object[0]);
            } else {
                dbVersionToPMClassNameMap.put(toDbVersion, parserManagerClassName);
            }
        }
    }

    public void unregisterParserManager(String parserManagerClassName) {
        Iterator it = this.dbProductMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry productToVersionMap = it.next();
            Map dbVersionToPMClassNameMap = (Map)productToVersionMap.getValue();
            if (!dbVersionToPMClassNameMap.containsValue(parserManagerClassName)) continue;
            Iterator vpmIt = dbVersionToPMClassNameMap.entrySet().iterator();
            while (vpmIt.hasNext()) {
                Map.Entry dbVersionToPMClassName = vpmIt.next();
                String registeredPMClassName = (String)dbVersionToPMClassName.getValue();
                if (!parserManagerClassName.equals(registeredPMClassName)) continue;
                vpmIt.remove();
            }
            if (!dbVersionToPMClassNameMap.isEmpty()) continue;
            it.remove();
        }
    }

    private class ParserManagerDBSupportInfo {
        String dbProduct = null;
        String dbLatestVersion = null;
        String dbEarliestVersion = null;
        String parserManagerClassName = null;

        private ParserManagerDBSupportInfo() {
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof ParserManagerDBSupportInfo) {
                ParserManagerDBSupportInfo pmInfo = (ParserManagerDBSupportInfo)obj;
                isEqual = pmInfo.dbProduct.equals(this.dbProduct);
                isEqual &= pmInfo.dbLatestVersion != null && this.dbLatestVersion != null && pmInfo.dbLatestVersion.equals(this.dbLatestVersion) || pmInfo.dbLatestVersion == null && this.dbLatestVersion == null;
                isEqual &= pmInfo.dbEarliestVersion != null && this.dbEarliestVersion != null && pmInfo.dbEarliestVersion.equals(this.dbEarliestVersion) || pmInfo.dbEarliestVersion == null && this.dbEarliestVersion == null;
            }
            return isEqual;
        }
    }
}

