/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.view;

import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.utils.PreferenceUtil;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.SingleWindowModeSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.viewer.TextResultViewer;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.model.ResultItem;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import com.ibm.ims.datatools.sqltools.result.ui.view.ResultsViewControl;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SingleWindowTextSection
extends SingleWindowModeSection {
    public static String _LINESEPARATOR = System.getProperty("line.separator");
    private TextResultViewer _textViewer;
    private boolean _isLastSubResultAppended = true;

    public SingleWindowTextSection(Composite composite, ResultsViewControl resultsViewControl) {
        super(composite, resultsViewControl);
    }

    public SingleWindowTextSection(Composite composite, IResultInstance instance, ResultsViewControl resultsViewControl) {
        super(composite, instance, resultsViewControl);
    }

    @Override
    protected void createViewerForResultInstance(IResultInstance instance) {
        this._textViewer.getViewer().getTextWidget().dispose();
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this._resultInstance != null) {
            SaveAllResultSetsAction saveAll = new SaveAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            saveAll.setText(Messages.SaveAllResultSetAction_Title);
            actions.add((Object)saveAll);
            ExportAllResultSetsAction exportAll = new ExportAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            exportAll.setText(Messages.ExportAllResultSetAction_Title);
            actions.add((Object)exportAll);
            actions.add(new Separator());
            PrintResultSetAction printAll = new PrintResultSetAction(this._resultInstance, this._composite);
            printAll.setText(Messages.PrintAllResultSetAction_Title);
            actions.add((Object)printAll);
        }
        this._textViewer = new TextResultViewer(this._composite, 770, actions);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().getTextWidget().setEditable(true);
        this._textViewer.getViewer().getTextWidget().setEnabled(true);
        this._textViewer.getViewer().setDocument(this.createDocumentForResultInstance(instance));
        this.onInstanceFinished();
        this._composite.layout(true);
    }

    private IDocument createDocumentForResultInstance(IResultInstance instance) {
        int i = 0;
        while (i < instance.getItemCount()) {
            IResultSetObject result;
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
                this._isResultHid = true;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer("");
        if (instance.getSubResults().size() > 0) {
            for (IResultInstance subInstance : instance.getSubResults()) {
                if (subInstance == null) continue;
                sb.append(this.getSubResultInstanceText(subInstance));
            }
        } else {
            int i2 = 0;
            while (i2 < instance.getItemCount()) {
                ResultItem item = instance.getItem(i2);
                sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
                ++i2;
            }
        }
        Document document = new Document();
        document.set(sb.toString());
        return document;
    }

    private String getSubResultInstanceText(IResultInstance instance) {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.addLinePrefix(instance.getOperationCommand().getDisplayString()));
        sb.append(ColumnAlignedResultItem.getResultInstanceDispString(instance, PreferenceUtil.getString(ResultsViewUIPlugin.getDefault().getPreferenceStore(), PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING, this._resultsViewControl.getUsePreferences())));
        return sb.toString();
    }

    private String addLinePrefix(String sql) {
        StringBuffer sb = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(sql, _LINESEPARATOR);
        int lineNumber = 1;
        while (st.hasMoreTokens()) {
            sb.append(lineNumber++ + "> ");
            sb.append(st.nextToken()).append(_LINESEPARATOR);
        }
        sb.append(lineNumber + "> go").append(_LINESEPARATOR);
        return sb.toString();
    }

    @Override
    public void onNewItemAppended(ResultItem item, int index) {
        IResultSetObject result;
        if (this._resultInstance == null || this._displayedItems.contains(item)) {
            return;
        }
        this._displayedItems.add(item);
        if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
            this._isResultHid = true;
        }
        StringBuffer sb = new StringBuffer("");
        if (this._resultInstance.isMayHaveSubResults()) {
            IResultInstance preSubInstance;
            if (index > 0 && (preSubInstance = (IResultInstance)this._resultInstance.getSubResults().get(index - 1)) != null) {
                sb.append(ColumnAlignedResultItem.getResultInstanceDispString(preSubInstance, PreferenceUtil.getString(ResultsViewUIPlugin.getDefault().getPreferenceStore(), PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING, this._resultsViewControl.getUsePreferences())));
            }
            sb.append(this.addLinePrefix(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg)));
            this._isLastSubResultAppended = false;
        } else {
            sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
        }
        this._messageCache.add(sb.toString());
        super.onNewItemAppended(item, index);
    }

    @Override
    protected void outputToViewer(List outputList) {
        StringBuffer sb = new StringBuffer();
        sb.append(this._textViewer.getViewer().getTextWidget().getText());
        for (String message : outputList) {
            sb.append(message);
        }
        this._textViewer.getViewer().getTextWidget().setVisible(false);
        this._textViewer.getViewer().getTextWidget().setText(sb.toString());
        this._textViewer.getViewer().getTextWidget().invokeAction(17039368);
        this._textViewer.getViewer().getTextWidget().setVisible(true);
        this._textViewer.resetUndoMgr();
    }

    @Override
    public void createInitialControl(Composite composite) {
        super.createInitialControl(composite);
        this._textViewer = new TextResultViewer(this._composite, 770, null);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().setDocument((IDocument)new Document(""));
        this._textViewer.getViewer().getTextWidget().setEditable(false);
        this._textViewer.getViewer().getTextWidget().setEnabled(false);
    }

    @Override
    public void onInstanceFinished() {
        super.onInstanceFinished();
        if (this._resultInstance.getSubResults().size() > 0 && !this._isLastSubResultAppended) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this._textViewer.getViewer().getTextWidget().getText());
            int indexOfLastSubResult = this._resultInstance.getSubResults().size() - 1;
            IResultInstance lastSubInstance = (IResultInstance)this._resultInstance.getSubResults().get(indexOfLastSubResult);
            if (lastSubInstance != null) {
                sb.append(ColumnAlignedResultItem.getResultInstanceDispString(lastSubInstance, PreferenceUtil.getString(ResultsViewUIPlugin.getDefault().getPreferenceStore(), PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING, this._resultsViewControl.getUsePreferences())));
            }
            this._textViewer.getViewer().getTextWidget().setVisible(false);
            this._textViewer.getViewer().getTextWidget().setText(sb.toString());
            this._textViewer.getViewer().getTextWidget().invokeAction(17039368);
            this._textViewer.getViewer().getTextWidget().setVisible(true);
            this._textViewer.resetUndoMgr();
            this._isLastSubResultAppended = true;
        }
        if (this._resultInstance.getParameters() == null) {
            return;
        }
    }

    @Override
    public void onInstanceReseted() {
        this._textViewer.getViewer().getTextWidget().setText("");
    }

    public TextResultViewer getTextViewer() {
        return this._textViewer;
    }
}

