/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.view;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.result.internal.filters.ConnectionProfileFilter;
import com.ibm.ims.datatools.sqltools.result.internal.filters.ResultStatusFilter;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.actions.RemoveAllVisibleFinishedResultAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.MultipleTabsTextSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ResultSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.SingleWindowTextSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.viewer.TextResultViewer;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import com.ibm.ims.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ResultsView
extends ViewPart {
    ResultsViewControl _resultsViewControl = new ResultsViewControl(this);
    static final String ORIENTATION_GROUP = "orientation";

    public ResultsView() {
        this._resultsViewControl.setUsePreferences(true);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this._resultsViewControl.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this._resultsViewControl.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HelpUtil.getContextId((String)"view_sql_result", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
        this.setTitleToolTip(Messages.ResultsView_tooltip);
        this._resultsViewControl.createPartControl(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this._resultsViewControl.getResultHistorySection().getResultTable());
        this.initActionBars();
        MenuManager menuBar = (MenuManager)this.getViewSite().getActionBars().getMenuManager();
        menuBar.add((IContributionItem)new Separator());
        menuBar.add(this._resultsViewControl.getOpenFilterDialogAction());
        menuBar.add(this._resultsViewControl.getPreferenceAction());
        menuBar.add((IContributionItem)new Separator(ORIENTATION_GROUP));
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._resultsViewControl.getVLayoutAction());
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._resultsViewControl.getHLayoutAction());
        IKeyBindingService keyBinding = this.getViewSite().getKeyBindingService();
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.result.terminate", this._resultsViewControl.getTerminateAction());
        actionBars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.result.removeInstance", this._resultsViewControl.getRemoveResultAction());
        actionBars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.result.removeAllInstances", (IAction)this._resultsViewControl.getRemoveAllVisibleFinishedResultAction());
        keyBinding.registerAction(this._resultsViewControl.getRemoveResultAction());
        keyBinding.registerAction((IAction)this._resultsViewControl.getRemoveAllVisibleFinishedResultAction());
        keyBinding.registerAction(this._resultsViewControl.getTerminateAction());
        actionBars.updateActionBars();
        this._resultsViewControl.getResultHistorySection().getResultTable().addFilter((ViewerFilter)new ConnectionProfileFilter(ResultsViewUIPlugin.getDefault().getPreferenceStore()));
        this._resultsViewControl.getResultHistorySection().getResultTable().addFilter((ViewerFilter)new ResultStatusFilter(ResultsViewUIPlugin.getDefault().getPreferenceStore()));
    }

    protected void initActionBars() {
        IActionBars actionbars = this.getViewSite().getActionBars();
        actionbars.getToolBarManager().add(this._resultsViewControl.getTerminateAction());
        actionbars.getToolBarManager().add(this._resultsViewControl.getRemoveResultAction());
        actionbars.getToolBarManager().add((IAction)this._resultsViewControl.getRemoveAllVisibleFinishedResultAction());
        actionbars.getToolBarManager().add((IContributionItem)new Separator());
        actionbars.getToolBarManager().add(this._resultsViewControl.getSingleTabDisplayAction());
        actionbars.getToolBarManager().add(this._resultsViewControl.getTextModeDisplayAction());
        if (ResultsViewUIPlugin.getDefault().getPreferenceStore().getBoolean(PreferenceConstants.VERTICAL_LAYOUT_RESULTS_VIEW)) {
            this._resultsViewControl.getVLayoutAction().setChecked(true);
            this._resultsViewControl.getHLayoutAction().setChecked(false);
        } else {
            this._resultsViewControl.getHLayoutAction().setChecked(true);
            this._resultsViewControl.getVLayoutAction().setChecked(false);
        }
        actionbars.getToolBarManager().add((IContributionItem)new Separator());
        actionbars.getToolBarManager().add(this._resultsViewControl.getOpenFilterDialogAction());
    }

    public void setFocus() {
        this._resultsViewControl.setFocus();
    }

    public void dispose() {
        super.dispose();
        this._resultsViewControl.dispose();
    }

    private void reDisplay(IResultInstance instance) {
        this._resultsViewControl.reDisplay(instance);
    }

    public ResultsViewControl getResultsViewControl() {
        return this._resultsViewControl;
    }

    public ResultSection getResultSection() {
        return this._resultsViewControl.getResultSection();
    }

    public void setResultSection(ResultSection section) {
        this._resultsViewControl.setResultSection(section);
    }

    public IResultInstance getCurrentInstance() {
        return this._resultsViewControl.getCurrentInstance();
    }

    public IAction[] getRegisteredActions() {
        return this._resultsViewControl.getRegisteredActions();
    }

    public void clearStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    public void refreshResults() {
        this._resultsViewControl.getResultHistorySection().getResultTable().refresh();
    }

    public void setCurrentInstance(IResultInstance instance) {
        this._resultsViewControl.setCurrentInstance(instance);
    }

    public RemoveAllVisibleFinishedResultAction getRemoveAllVisibleFinishedResultAction() {
        return this._resultsViewControl.getRemoveAllVisibleFinishedResultAction();
    }

    public Object getAdapter(Class adapter) {
        if (IFindReplaceTarget.class.equals((Object)adapter)) {
            IFindReplaceTarget target = null;
            TextResultViewer viewer = null;
            if (this._resultsViewControl != null) {
                if (this._resultsViewControl.getResultSection() instanceof MultipleTabsTextSection) {
                    viewer = ((MultipleTabsTextSection)this._resultsViewControl.getResultSection()).getTextViewer();
                }
                if (this._resultsViewControl.getResultSection() instanceof SingleWindowTextSection) {
                    viewer = ((SingleWindowTextSection)this._resultsViewControl.getResultSection()).getTextViewer();
                }
                if (viewer != null) {
                    target = viewer.getViewer().getFindReplaceTarget();
                }
            }
            return target;
        }
        return super.getAdapter(adapter);
    }
}

