/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.view;

import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.utils.PreferenceUtil;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.model.ResultItem;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import com.ibm.ims.datatools.sqltools.result.ui.view.ResultsViewControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class ResultSection {
    protected IResultInstance _resultInstance;
    protected IPreferenceStore _store;
    protected boolean _displayRowNumber;
    protected boolean _showRowCountMsg;
    protected boolean _showHeadings;
    protected String _nullValue;
    protected Composite _parent;
    protected ResultsViewControl _resultsViewControl;
    protected Vector _messageCache;
    protected OutputThread _outputThread;
    private static int OUTPUT_INTERVAL = 500;
    private static int END_OUTPUT_THEAD_TIMES = 20;
    protected List _displayedItems;

    public ResultSection(IResultInstance instance, ResultsViewControl resultsViewControl) {
        this._resultsViewControl = resultsViewControl;
        this._resultInstance = instance;
        this._store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        this._displayRowNumber = PreferenceUtil.getBoolean(this._store, PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_NUMBER, this._resultsViewControl.getUsePreferences());
        this._nullValue = PreferenceUtil.getString(this._store, PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING, this._resultsViewControl.getUsePreferences());
        this._showRowCountMsg = PreferenceUtil.getBoolean(this._store, PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG, this._resultsViewControl.getUsePreferences());
        this._showHeadings = PreferenceUtil.getBoolean(this._store, PreferenceConstants.SQL_RESULTS_VIEW_SHOW_HEADING, this._resultsViewControl.getUsePreferences());
        this._displayedItems = new ArrayList();
        this._messageCache = new Vector();
    }

    public abstract Composite getControl();

    public void showDetail(IResultInstance instance) {
        if (instance == this._resultInstance) {
            return;
        }
        int count = instance.getItemCount();
        int i = 0;
        while (i < count) {
            this._displayedItems.add(instance.getItem(i));
            ++i;
        }
    }

    public void onNewItemAppended(ResultItem item, int index) {
        if (this._outputThread == null || !this._outputThread.isAlive()) {
            this._outputThread = this.getOutputThread();
            this._outputThread.start();
        }
    }

    public abstract void onParametersShown(List var1);

    public abstract void onInstanceFinished();

    public abstract void onInstanceReseted();

    public void showTab(int tabType) {
    }

    public void showResultSet(IResultSetObject result) {
    }

    public void showTab(int tabType, int tabNumber) {
    }

    public int getRowCount() {
        return -1;
    }

    protected abstract void outputToViewer(List var1);

    protected List getMergedOutputList(List outputList) {
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        ResultItem preItem = null;
        Iterator iterator = outputList.iterator();
        while (iterator.hasNext()) {
            ResultItem item;
            if (result.size() > 0) {
                preItem = (ResultItem)result.get(result.size() - 1);
            }
            if (this.isTextResultItem(item = (ResultItem)iterator.next()) && this.isTextResultItem(preItem)) {
                preItem = this.mergeTextItems(preItem, item);
                result.set(result.size() - 1, preItem);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private ResultItem mergeTextItems(ResultItem preItem, ResultItem item) {
        Object message = (String)preItem.getResultObject();
        message = (String)message + String.valueOf(item.getResultObject());
        ResultItem result = new ResultItem((String)message, true);
        return result;
    }

    protected boolean isTextResultItem(ResultItem item) {
        if (item == null) {
            return false;
        }
        int type = item.getResultType();
        return type == 2;
    }

    private OutputThread getOutputThread() {
        return new OutputThread(this._resultsViewControl.getControl().getDisplay());
    }

    public class OutputThread
    extends Thread {
        private Display display;
        private int counter;

        public OutputThread(Display display) {
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                ArrayList outputList;
                try {
                    OutputThread.sleep(OUTPUT_INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                Vector vector = ResultSection.this._messageCache;
                synchronized (vector) {
                    outputList = new ArrayList(ResultSection.this._messageCache);
                    ResultSection.this._messageCache.clear();
                }
                if (outputList.size() != 0) {
                    this.counter = 0;
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResultSection.this.outputToViewer(outputList);
                        }
                    });
                    continue;
                }
                ++this.counter;
            } while (this.counter < END_OUTPUT_THEAD_TIMES);
        }
    }
}

