/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.view;

import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.IResultSetRow;
import com.ibm.ims.datatools.sqltools.result.Parameter;
import com.ibm.ims.datatools.sqltools.result.ResultSetObject;
import com.ibm.ims.datatools.sqltools.result.XMLResultSetObject;
import com.ibm.ims.datatools.sqltools.result.internal.preference.ResultSetViewerPreferencePage;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.ExportResultSetAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions.SaveResultSetAction;
import com.ibm.ims.datatools.sqltools.result.internal.ui.utils.UIUtil;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.MultipleTabsModeSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ParameterViewerRegistryReader;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ResultSetViewerRegistryReader;
import com.ibm.ims.datatools.sqltools.result.internal.ui.viewer.ResultSetViewer;
import com.ibm.ims.datatools.sqltools.result.internal.utils.StatusTextProvider;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.model.ResultItem;
import com.ibm.ims.datatools.sqltools.result.ui.ExternalResultSetViewerProvider;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import com.ibm.ims.datatools.sqltools.result.ui.view.ParameterViewerProvider;
import com.ibm.ims.datatools.sqltools.result.ui.view.ResultsViewControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class MultipleTabsGridSection
extends MultipleTabsModeSection {
    private Text _statusView;
    private Text _messageView;
    private ParameterViewerProvider provider;

    public MultipleTabsGridSection(Composite composite, ResultsViewControl resultsViewControl) {
        super(composite, resultsViewControl);
    }

    public MultipleTabsGridSection(Composite composite, IResultInstance instance, ResultsViewControl resultsViewControl) {
        super(composite, instance, resultsViewControl);
    }

    @Override
    protected Control createStatusItem(CTabFolder ctf) {
        this._statusView = new Text((Composite)ctf, 770);
        this._statusView.setEditable(false);
        return this._statusView;
    }

    @Override
    protected Control createMessageItem(CTabFolder ctf) {
        this._messageView = new Text((Composite)ctf, 770);
        this._messageView.setEditable(false);
        return this._messageView;
    }

    @Override
    public void showStatusDetail(IResultInstance instance) {
        if (instance == null) {
            this._statusView.setText("");
        } else {
            String text = StatusTextProvider.getStatusText((IResultInstance)instance);
            this._statusView.setText(text);
        }
    }

    @Override
    protected void showMessageDetail(IResultInstance instance) {
        if (this._splitMessages) {
            return;
        }
        if (instance == null) {
            this._messageView.setText("");
        } else {
            int count = instance.getItemCount();
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < count) {
                ResultItem item = instance.getItem(i);
                if (item.getResultType() == 2) {
                    sb.append(item.getResultObject());
                }
                ++i;
            }
            this._messageView.setText(sb.toString());
        }
    }

    @Override
    protected void showParameterDetail(IResultInstance instance) {
        List paramList = instance.getParameters();
        if (paramList == null || paramList.size() == 0) {
            return;
        }
        Iterator iter = paramList.iterator();
        ArrayList newList = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || !(obj instanceof Parameter)) continue;
            newList.add(obj);
        }
        this.appendAndShowParameters(newList);
    }

    @Override
    protected void createViewerForItem(Composite composite, ResultItem item) {
        int resultType = item.getResultType();
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        switch (resultType) {
            case 2: {
                Text message = new Text(composite, 770);
                message.setLayoutData((Object)new GridData(1808));
                message.setEditable(false);
                message.setText((String)item.getResultObject());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                if (result instanceof XMLResultSetObject) {
                    this.createTextforResultSet(composite, result);
                }
                if (!(result instanceof ResultSetObject)) break;
                String viewerName = store.getString(PreferenceConstants.RESULT_SET_VIEWER_VIEWERNAME);
                if (ResultSetViewerPreferencePage.DEFAULT_VIEWER.equalsIgnoreCase(viewerName)) {
                    this.createTableViewerForResultSet(composite, result);
                    break;
                }
                this.createExternalTableViewerForResultSet(composite, result, viewerName);
                break;
            }
        }
    }

    @Override
    protected void appendStatusView(String text) {
        this._statusView.append(text);
    }

    @Override
    protected void appendMessageView(String text) {
        this._messageView.append(text);
    }

    protected void createTableViewerForResultSet(Composite composite, IResultSetObject result) {
        new ResultSetViewer(composite, 66306, this._resultInstance, result, this._displayRowNumber, this._resultsViewControl);
        Label label = new Label(composite, 0);
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.grabExcessVerticalSpace = false;
        labelGridData.heightHint = UIUtil.convertHeightInCharsToPixels(1, (Control)this._parent);
        label.setLayoutData((Object)labelGridData);
        int totalRowCount = result.getTotalRowCount();
        int rowCount = result.getRowCount();
        if (totalRowCount == rowCount) {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip1, (Object[])new Object[]{String.valueOf(rowCount)}));
        } else {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip, (Object[])new Object[]{String.valueOf(totalRowCount), String.valueOf(rowCount)}));
        }
    }

    protected void createExternalTableViewerForResultSet(Composite composite, IResultSetObject result, String viewerName) {
        ResultSetViewerRegistryReader reader = ResultSetViewerRegistryReader.getInstance();
        ExternalResultSetViewerProvider provider = reader.getResultSetViewerExecutable(viewerName);
        provider.configureViewer(composite, this._resultInstance, result, this._displayRowNumber, this._resultsViewControl);
        Label label = new Label(composite, 0);
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.grabExcessVerticalSpace = false;
        labelGridData.heightHint = UIUtil.convertHeightInCharsToPixels(1, (Control)this._parent);
        label.setLayoutData((Object)labelGridData);
        int totalRowCount = result.getTotalRowCount();
        int rowCount = result.getRowCount();
        if (totalRowCount == rowCount) {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip1, (Object[])new Object[]{String.valueOf(rowCount)}));
        } else {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip, (Object[])new Object[]{String.valueOf(totalRowCount), String.valueOf(rowCount)}));
        }
    }

    protected void createTextforResultSet(Composite composite, IResultSetObject result) {
        Text txt = new Text(composite, 778);
        txt.setLayoutData((Object)new GridData(1808));
        StringBuffer buf = new StringBuffer();
        Iterator iter = result.getDisplayRecords();
        while (iter != null && iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            int i = 0;
            while (i < row.getData().length) {
                buf.append(row.getData(i));
                ++i;
            }
        }
        String s = buf.toString();
        txt.setText(s);
        MenuManager mgr = new MenuManager();
        MenuManager saveMgr = new MenuManager(Messages.Save_name);
        saveMgr.add((IAction)new SaveResultSetAction(txt.getShell(), result));
        saveMgr.add((IAction)new SaveAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager exportMgr = new MenuManager(Messages.Export_name);
        exportMgr.add((IAction)new ExportResultSetAction(txt.getShell(), result));
        exportMgr.add((IAction)new ExportAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager printMgr = new MenuManager(Messages.Print_name);
        printMgr.add((IAction)new PrintResultSetAction(result, this._parent));
        printMgr.add((IAction)new PrintResultSetAction(this._resultInstance, this._parent));
        mgr.add((IContributionItem)saveMgr);
        mgr.add((IContributionItem)exportMgr);
        mgr.add((IContributionItem)printMgr);
        Menu menu = mgr.createContextMenu((Control)txt);
        txt.setMenu(menu);
    }

    @Override
    public void onInstanceReseted() {
        super.onInstanceReseted();
        this._statusView.setText("");
    }

    @Override
    protected void appendAndShowParameters(List params) {
        if (this._paramsItem == null) {
            this._paramsItem = new CTabItem(this._tabFolder, 0, this._numberStaticTab);
            this._paramsItem.setText(Messages.MultipleTabsGridSection_parameter);
            ++this._numberStaticTab;
            this._isParamShown = true;
            this._paramTabNumber = this._numberStaticTab - 1;
            IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
            String viewerName = store.getString(PreferenceConstants.PARAMETER_VIEWER_VIEWERNAME);
            if (ResultSetViewerPreferencePage.PARAM_DEFAULT_VIEWER.equalsIgnoreCase(viewerName)) {
                this.createTableForParameters((Composite)this._tabFolder);
            } else {
                this.createExternalViewerForParameter((Composite)this._tabFolder, viewerName);
            }
            this._paramsItem.setControl((Control)this.provider.getTable());
        }
        this.provider.fillDataIntoParamsTable(params);
    }

    private void createTableForParameters(Composite comp) {
        this.provider = new ParameterViewerProvider();
        this.provider.configureViewer(comp, 66048);
    }

    private void createExternalViewerForParameter(Composite comp, String viewerName) {
        ParameterViewerRegistryReader reader = ParameterViewerRegistryReader.getInstance();
        this.provider = reader.getParameterViewerExecutable(viewerName);
        this.provider.configureViewer(comp, 66048);
    }
}

