/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.export.actions;

import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.IResultSetRow;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyRowsAction
extends Action {
    private TableViewer _table;
    private IResultSetObject _resultObj;

    public CopyRowsAction(String text, TableViewer table, IResultSetObject resultObj) {
        super(text);
        this._table = table;
        this._resultObj = resultObj;
    }

    public void run() {
        ArrayList<IResultSetRow> rows = new ArrayList<IResultSetRow>();
        if (this._table == null || this._resultObj == null) {
            return;
        }
        ISelection s = this._table.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        for (Object object : ss) {
            IResultSetRow row;
            if (!(object instanceof Integer) || (row = this._resultObj.getRowData(((Integer)object).intValue())) == null) continue;
            rows.add(row);
        }
        if (rows.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer("");
        for (IResultSetRow row : rows) {
            sb.append(ColumnAlignedResultItem.getDisplayData(this._resultObj, row, ResultsViewUIPlugin.getDefault().getPreferenceStore().getString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING)));
            sb.append(ColumnAlignedResultItem.getLineSeparator());
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(new Object[]{sb.toString()}, transfer);
    }
}

