/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.export;

import com.ibm.ims.datatools.help.ContextProviderDelegate;
import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.export.AbstractOutputter;
import com.ibm.ims.datatools.sqltools.result.internal.export.IOutputterDescriptor;
import com.ibm.ims.datatools.sqltools.result.internal.export.OutputterConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.SaveResultGroup;
import com.ibm.ims.datatools.sqltools.result.internal.ui.utils.Images;
import com.ibm.ims.datatools.sqltools.result.internal.utils.ILogger;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SaveResultSetDialog
extends TitleAreaDialog
implements IContextProvider {
    private static ILogger _log = ResultsViewUIPlugin.getLogger(null);
    private IFile _originalFile = null;
    private String _originalName = null;
    private IPath _result;
    private IResultSetObject _resultset;
    private IResultInstance _resultInstance;
    private SaveResultGroup _resourceGroup;
    private Button _okButton;
    private Image _dlgTitleImage = null;
    private boolean _first = true;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            if (SaveResultSetDialog.this._resourceGroup != null) {
                IStatus status = SaveResultSetDialog.this._resourceGroup.getStatus();
                if (status.getSeverity() == 4) {
                    SaveResultSetDialog.this.setMessage(status.getMessage(), 3);
                    SaveResultSetDialog.this.getButton(0).setEnabled(false);
                } else {
                    SaveResultSetDialog.this.setMessage(null);
                    SaveResultSetDialog.this.getButton(0).setEnabled(true);
                }
            }
        }
    };
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName());

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public SaveResultSetDialog(Shell parentShell, IResultSetObject resultset) {
        super(parentShell);
        this._resultset = resultset;
    }

    public SaveResultSetDialog(Shell parentShell, IResultInstance result) {
        super(parentShell);
        this._resultInstance = result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this._resultInstance != null) {
            shell.setText(Messages.SaveResultSetDialog_saveAllResults_text);
        } else {
            shell.setText(Messages.SaveResultSetDialog_saveResult_text);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this._resourceGroup.setFocus();
        if (this._resultInstance != null) {
            this.setTitle(Messages.SaveResultSetDialog_saveAllResults_title);
        } else {
            this.setTitle(Messages.SaveResultSetDialog_saveResult_title);
        }
        this._dlgTitleImage = Images.get("com.ibm.ims.datatools.sqltools.resultexport_result.gif");
        this.setTitleImage(this._dlgTitleImage);
        this._first = false;
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)parent, (String)HelpUtil.getContextId((String)"dialog_save_resultset", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SaveResultSetDialog.this.setDialogComplete(SaveResultSetDialog.this.validatePage());
            }
        };
        if (this._resultset != null) {
            this._resourceGroup = new SaveResultGroup(composite, listener, Messages.SaveResultSetDialog_filename, "file", this._resultset, this._listener);
        } else if (this._resultInstance != null) {
            this._resourceGroup = new SaveResultGroup(composite, listener, Messages.SaveResultSetDialog_filename, "file", this._resultInstance, this._listener);
        }
        this._resourceGroup.setAllowExistingResources(true);
        return parentComposite;
    }

    public IPath getResult() {
        return this._result;
    }

    private void initializeControls() {
        if (this._originalFile != null) {
            this._resourceGroup.setContainerFullPath(this._originalFile.getParent().getFullPath());
            this._resourceGroup.setResource(this._originalFile.getName());
        } else if (this._originalName != null) {
            this._resourceGroup.setResource(this._originalName);
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        block14: {
            IFile file;
            int pos;
            Object filename = this._resourceGroup.getResource();
            IOutputterDescriptor descriptor = this._resourceGroup.getOutputterDesp();
            IPath path = this._resourceGroup.getContainerFullPath().append((String)filename);
            if (path.getFileExtension() == null && filename != null && (pos = ((String)filename).lastIndexOf(46)) < 0) {
                filename = (String)filename + "." + descriptor.getFileExtension();
                path = path.addFileExtension(descriptor.getFileExtension());
            }
            if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = NLS.bind((String)Messages.SaveResultSetDialog_overwrite, (Object[])new Object[]{path.toOSString()});
                MessageDialog d = new MessageDialog(this.getShell(), Messages.SaveResultSetDialog_question, null, question, 3, buttons, 0);
                int overwrite = d.open();
                switch (overwrite) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                    default: {
                        this.cancelPressed();
                        return;
                    }
                }
            }
            this._result = path;
            try {
                Properties options = new Properties();
                String resource = this._resourceGroup.getContainerFullPath().toString();
                if (ResourcesPlugin.getWorkspace().getRoot().findMember(resource) == null) break block14;
                String fullpath = ResourcesPlugin.getWorkspace().getRoot().findMember(resource).getLocation().toOSString() + File.separator + (String)filename;
                AbstractOutputter outputter = descriptor.getOutputter();
                if (this._resourceGroup.getDelimiter().equals(OutputterConstants.USER_DEFINED)) {
                    options.setProperty("userdefined_delimiter", this._resourceGroup.getUserDefinedDelimiter());
                }
                options.setProperty("delimiter", this._resourceGroup.getDelimiter());
                options.setProperty("encoding", this._resourceGroup.getEncoding());
                if (this._resultset != null) {
                    outputter.output(this._resultset, options, fullpath);
                }
                if (this._resultInstance != null) {
                    outputter.output(this._resultInstance, options, fullpath);
                }
                try {
                    if (file != null && file.getProject() != null) {
                        file.getProject().refreshLocal(2, null);
                        file.setCharset(this._resourceGroup.getEncoding(), (IProgressMonitor)new NullProgressMonitor());
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (CoreException e) {
                    _log.error("common_error", (Throwable)e);
                }
            }
            catch (IOException ex) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ResultExportWizard_export_error, (String)Messages.ResultExportWizard_failed_to_export_result_set, (IStatus)new Status(4, ResultsViewUIPlugin.getPluginId(), 0, ex.getMessage(), (Throwable)ex));
            }
        }
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this._okButton.setEnabled(value);
    }

    public void setOriginalFile(IFile originalFile) {
        this._originalFile = originalFile;
    }

    public void setOriginalName(String originalName) {
        this._originalName = originalName;
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(Messages.SaveResultSetDialog_message);
        if (!this._resourceGroup.areAllValuesValid()) {
            if (this._resourceGroup.getProblemType() == 1 || this._resourceGroup.getProblemType() == 5) {
                if (this._first) {
                    this.setMessage(this._resourceGroup.getProblemMessage());
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(this._resourceGroup.getProblemMessage());
                }
            } else {
                this.setErrorMessage(this._resourceGroup.getProblemMessage());
            }
            return false;
        }
        return true;
    }
}

