/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.export;

import com.ibm.ims.datatools.sqltools.result.IResultSetObject;
import com.ibm.ims.datatools.sqltools.result.XMLResultSetObject;
import com.ibm.ims.datatools.sqltools.result.internal.export.IOutputterDescriptor;
import com.ibm.ims.datatools.sqltools.result.internal.export.OutputterRegistryReader;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.export.component.EncodingDelimiterOptionsSection;
import com.ibm.ims.datatools.sqltools.result.internal.ui.utils.UIUtil;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.model.ResultItem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ResultFormatWizardPage
extends WizardPage {
    private Text _txtFileName;
    private List _lstFormat;
    private EncodingDelimiterOptionsSection _options;
    private boolean _isXMLResult = false;
    private Map _outputters;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            if (ResultFormatWizardPage.this._options != null) {
                IStatus status = ResultFormatWizardPage.this._options.getStatus();
                if (status.getSeverity() == 4) {
                    ResultFormatWizardPage.this.setMessage(status.getMessage(), 3);
                    ResultFormatWizardPage.this.setPageComplete(false);
                } else {
                    ResultFormatWizardPage.this.setMessage(null);
                    ResultFormatWizardPage.this.setPageComplete(true);
                }
            }
        }
    };

    public ResultFormatWizardPage(IResultSetObject result) {
        super(Messages.ResultFormatWizardPage_title);
        this.setTitle(Messages.ResultFormatWizardPage_title);
        this.setDescription(Messages.ResultFormatWizardPage_description);
        if (result instanceof XMLResultSetObject) {
            this._isXMLResult = true;
        }
        this._outputters = new HashMap();
    }

    public ResultFormatWizardPage(IResultInstance result) {
        super(Messages.ResultFormatWizardPage_title);
        this.setTitle(Messages.ResultFormatWizardPage_title);
        this.setDescription(Messages.ResultFormatWizardPage_description);
        int i = 0;
        while (i < result.getItemCount()) {
            IResultSetObject rs;
            ResultItem ri = result.getItem(i);
            if (ri != null && ri.getResultObject() instanceof IResultSetObject && (rs = (IResultSetObject)ri.getResultObject()) instanceof XMLResultSetObject) {
                this._isXMLResult = true;
                break;
            }
            ++i;
        }
        this._outputters = new HashMap();
    }

    public void createControl(Composite parent) {
        int numColumns;
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns = 3;
        container.setLayout((Layout)layout);
        this.createFileSelectionArea(container, numColumns);
        this.createFormatSelectionArea(container, numColumns);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void createFileSelectionArea(Composite container, int numColumns) {
        UIUtil.createLabel(container, Messages.ResultFormatWizardPage_label_filename, 1);
        int width = this.convertWidthInCharsToPixels(40);
        this._txtFileName = new Text(container, 2052);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        data.horizontalSpan = numColumns - 2;
        this._txtFileName.setLayoutData((Object)data);
        Button b = new Button(container, 8);
        b.setText(Messages.ResultFormatWizardPage_button_browse);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ResultFormatWizardPage.this.getShell(), 8192);
                dialog.setFileName("result");
                IOutputterDescriptor descriptor = OutputterRegistryReader.getInstance().getOutputterDesciptor(ResultFormatWizardPage.this._isXMLResult, ResultFormatWizardPage.this.getOutputterIndex());
                String[] exts = new String[]{descriptor.getExtFilterString(), "*.*"};
                String[] names = new String[]{descriptor.getExtensionFilterDisplayString(), Messages.ResultFormatWizardPage_all_files};
                dialog.setFilterExtensions(exts);
                dialog.setFilterNames(names);
                dialog.setText(Messages.ResultFormatWizardPage_dialog_text);
                String filename = dialog.open();
                if (filename != null) {
                    ResultFormatWizardPage.this._txtFileName.setText(filename);
                }
            }
        });
        this._txtFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String txt = ResultFormatWizardPage.this._txtFileName.getText();
                if (txt.trim().length() == 0) {
                    ResultFormatWizardPage.this.setErrorMessage(Messages.ResultFormatWizardPage_errormessage_choosefile);
                    ResultFormatWizardPage.this.setPageComplete(false);
                } else {
                    ResultFormatWizardPage.this.setErrorMessage(null);
                    ResultFormatWizardPage.this.setPageComplete(true);
                }
            }
        });
    }

    private void createFormatSelectionArea(Composite container, int numColumns) {
        UIUtil.createLabel(container, Messages.ResultFormatWizardPage_label_format, 1);
        this._lstFormat = new List(container, 2052);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = numColumns - 2;
        this._lstFormat.setLayoutData((Object)data);
        this._lstFormat.setItems(OutputterRegistryReader.getInstance().getOutputterDspStrings(this._isXMLResult));
        this._lstFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultFormatWizardPage.this.resourceTypeFieldSelected();
            }
        });
        this._lstFormat.setSelection(0);
        UIUtil.createLabel(container, "", 1);
        UIUtil.createLabel(container, "", 1);
        this._options = new EncodingDelimiterOptionsSection(container, 1, this._listener);
    }

    private void resourceTypeFieldSelected() {
        Object value = this.getFileName();
        String name = value;
        int sep = ((String)value).lastIndexOf(".");
        if (sep > 0) {
            name = ((String)value).substring(0, sep);
        }
        int selIndex = this.getOutputterIndex();
        value = name + "." + OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, selIndex).getFileExtension();
        this._options.setSupportDelimiter(OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, selIndex).supportDelimiter());
        this._options.updateOptionsSection();
        if (name != null && !"".equals(name.trim())) {
            this.setFileName((String)value);
        }
    }

    public String getFileName() {
        return this._txtFileName.getText();
    }

    private void setFileName(String fileName) {
        this._txtFileName.setText(fileName);
    }

    public int getOutputterIndex() {
        return this._lstFormat.getSelectionIndex();
    }

    public String getDelimiter() {
        return this._options.getDelimiter();
    }

    public String getUserDefinedDelimiter() {
        return this._options.getUserDefinedDelimiter();
    }

    public String getEncoding() {
        return this._options.getEncoding();
    }

    public boolean isXMLResult() {
        return this._isXMLResult;
    }

    public IOutputterDescriptor getOutputterDesp() {
        return OutputterRegistryReader.getInstance().getOutputterDesciptor(this._isXMLResult, this.getOutputterIndex());
    }
}

