/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.ui.actions;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import com.ibm.ims.datatools.sqltools.result.internal.utils.ILogger;
import com.ibm.ims.datatools.sqltools.result.internal.utils.StatusTextProvider;
import com.ibm.ims.datatools.sqltools.result.model.IResultInstance;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class SaveResultInstanceAction
extends Action
implements IUpdate {
    private static ILogger _log = ResultsViewUIPlugin.getLogger(null);
    Shell _shell;
    ISelectionProvider _provider;
    private static String OUTER_SEPARATOR_LINE = "=======================================================================================";
    private static String INNER_SEPARATOR_LINE = "---------------------------------------------------------------------------------------";

    public SaveResultInstanceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(Messages.SaveResultInstanceAction_save_history);
        this._shell = shell;
        this._provider = selectionProvider;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"action_save_result_instance", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void update() {
        IStructuredSelection selection = (IStructuredSelection)this._provider.getSelection();
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1) {
            this.setEnabled(false);
            return;
        }
        if (!(obj[0] instanceof IResultInstance)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this._provider.getSelection();
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1) {
            return;
        }
        IResultInstance instance = (IResultInstance)obj[0];
        FileDialog dialog = new FileDialog(this._shell, 8192);
        dialog.setText(Messages.SaveResultInstanceAction_save_hisotry_title);
        String filename = "";
        boolean selectAgain = false;
        do {
            if ((filename = dialog.open()) == null) {
                return;
            }
            File file = new File(filename);
            if (!file.exists()) continue;
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)Messages.ResultExportWizard_overwrite, (Object[])new Object[]{filename});
            MessageDialog d = new MessageDialog(this._shell, Messages.ResultExportWizard_question, null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    selectAgain = false;
                    break;
                }
                case 1: {
                    selectAgain = true;
                    break;
                }
                default: {
                    return;
                }
            }
        } while (selectAgain);
        try {
            FileOutputStream fos = new FileOutputStream(new File(filename));
            PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")));
            this.printResultInstance(w, instance, "", true);
            w.close();
        }
        catch (IOException ex) {
            _log.error("SaveResultInstanceAction_cant_export_result_log", (Throwable)ex);
            ErrorDialog.openError((Shell)this._shell, (String)Messages.SaveResultInstanceAction_save_error, (String)Messages.SaveResultInstanceAction_can_not_save, (IStatus)new Status(4, "com.ibm.ims.datatools.sqltools.result.ui", 0, ex.getMessage(), (Throwable)ex));
        }
    }

    private void printResultInstance(PrintWriter w, IResultInstance instance, String prefix, boolean showFullHeader) {
        if (showFullHeader) {
            w.print((String)prefix + this.addPrefix(StatusTextProvider.getHistoryHeader((IResultInstance)instance), (String)prefix));
        } else {
            w.print((String)prefix + this.addPrefix(StatusTextProvider.getSimpleHeader((IResultInstance)instance), (String)prefix));
        }
        w.println(INNER_SEPARATOR_LINE);
        w.println((String)prefix);
        String dispStr = ColumnAlignedResultItem.getResultInstanceDispString(instance, ResultsViewUIPlugin.getDefault().getPreferenceStore().getString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING));
        w.print((String)prefix + this.addPrefix(dispStr, (String)prefix));
        prefix = (String)prefix + "\t";
        for (IResultInstance subInstance : instance.getSubResults()) {
            if (subInstance == null) continue;
            w.println((String)prefix);
            w.println((String)prefix + OUTER_SEPARATOR_LINE);
            this.printResultInstance(w, subInstance, (String)prefix, false);
        }
    }

    private String addPrefix(String text, String prefix) {
        return text.replaceAll("\n", "\n" + prefix);
    }
}

