/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.preference;

import com.ibm.ims.datatools.sqltools.result.internal.ui.Messages;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ParameterViewerDescriptor;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ParameterViewerRegistryReader;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ResultSetViewerDescriptor;
import com.ibm.ims.datatools.sqltools.result.internal.ui.view.ResultSetViewerRegistryReader;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ResultSetViewerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo viewersCombo;
    private String[] myViewers;
    private Combo paramViewersCombo;
    private Text maxParamCount;
    private String[] paramViewers;
    private String viewerName;
    private IPreferenceStore store;
    public static final String DEFAULT_VIEWER = Messages.ResultSetViewerPage_defaultViewer;
    public static final String PARAM_DEFAULT_VIEWER = Messages.ParameterViewerPage_defaultViewer;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            try {
                int maxparameterLength = Integer.parseInt(ResultSetViewerPreferencePage.this.maxParamCount.getText().trim());
                if (maxparameterLength < 1) {
                    ResultSetViewerPreferencePage.this.setMessage(Messages.ParameterViewerPreferencePage_parameterResultOptions_LessthanOne, 3);
                    ResultSetViewerPreferencePage.this.setValid(false);
                    ResultSetViewerPreferencePage.this.updateApplyButton();
                } else {
                    ResultSetViewerPreferencePage.this.setMessage(null);
                    ResultSetViewerPreferencePage.this.setValid(true);
                    ResultSetViewerPreferencePage.this.updateApplyButton();
                }
            }
            catch (Exception exception) {
                ResultSetViewerPreferencePage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_invalidnumberformat, 3);
                ResultSetViewerPreferencePage.this.setValid(false);
                ResultSetViewerPreferencePage.this.updateApplyButton();
            }
        }
    };

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ResultsViewUIPlugin.getDefault().getPreferenceStore());
        this.store = this.getPreferenceStore();
        this.populateViewerNames();
        this.populateParamViewerNames();
    }

    public static String getParameterViewerNameFromExtension() {
        List viewerDescriptors = ParameterViewerRegistryReader.getInstance().getParameterViewers();
        String viewerName = PARAM_DEFAULT_VIEWER;
        if (viewerDescriptors.size() == 1 && (viewerName = ((ParameterViewerDescriptor)viewerDescriptors.get(0)).getDefaultViewer()) == null) {
            viewerName = PARAM_DEFAULT_VIEWER;
        }
        return viewerName;
    }

    public static String getViewerNameFromExtension() {
        List viewerDescriptors = ResultSetViewerRegistryReader.getInstance().getResultSetViewers();
        String viewerName = DEFAULT_VIEWER;
        if (viewerDescriptors.size() == 1 && (viewerName = ((ResultSetViewerDescriptor)viewerDescriptors.get(0)).getDefaultViewer()) == null) {
            viewerName = DEFAULT_VIEWER;
        }
        return viewerName;
    }

    private void populateViewerNames() {
        List viewerDescriptors = ResultSetViewerRegistryReader.getInstance().getResultSetViewers();
        int viewerCount = viewerDescriptors.size();
        this.myViewers = new String[viewerCount + 1];
        this.myViewers[0] = DEFAULT_VIEWER;
        Iterator iter = viewerDescriptors.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ResultSetViewerDescriptor desc = (ResultSetViewerDescriptor)iter.next();
            this.myViewers[++count] = desc.getViewerID();
        }
    }

    private void populateParamViewerNames() {
        List viewerDescriptors = ParameterViewerRegistryReader.getInstance().getParameterViewers();
        int viewerCount = viewerDescriptors.size();
        this.paramViewers = new String[viewerCount + 1];
        this.paramViewers[0] = PARAM_DEFAULT_VIEWER;
        Iterator iter = viewerDescriptors.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ParameterViewerDescriptor desc = (ParameterViewerDescriptor)iter.next();
            this.paramViewers[++count] = desc.getViewerID();
        }
    }

    public void setViewerName(String name) {
        this.viewerName = name;
    }

    public String getViewerName() {
        return this.viewerName;
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = this.getPreferenceStore();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Group resultViewersGroup = new Group(comp, 0);
        resultViewersGroup.setText(Messages.ResultSetViewerPage_group);
        GridData gridData = new GridData(768);
        resultViewersGroup.setLayoutData((Object)gridData);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        resultViewersGroup.setLayout((Layout)gLayout);
        Label label = new Label((Composite)resultViewersGroup, 0);
        label.setText(Messages.ResultSetViewerPage_select_viewer);
        this.viewersCombo = new Combo((Composite)resultViewersGroup, 12);
        this.viewersCombo.setToolTipText(Messages.ResultSetViewerPage_viewer_tooltip);
        GridData comboData = new GridData(768);
        this.viewersCombo.setLayoutData((Object)comboData);
        Group paramViewersGroup = new Group(comp, 0);
        paramViewersGroup.setText(Messages.ParameterViewerPage_group);
        gridData = new GridData(768);
        paramViewersGroup.setLayoutData((Object)gridData);
        paramViewersGroup.setLayout((Layout)gLayout);
        Label paramLabel = new Label((Composite)paramViewersGroup, 0);
        paramLabel.setText(Messages.ParameterViewerPage_select_viewer);
        this.paramViewersCombo = new Combo((Composite)paramViewersGroup, 12);
        this.paramViewersCombo.setToolTipText(Messages.ParameterViewerPage_viewer_tooltip);
        this.paramViewersCombo.setLayoutData((Object)comboData);
        int i = 0;
        while (i < this.paramViewers.length) {
            this.paramViewersCombo.add(this.paramViewers[i]);
            ++i;
        }
        this.paramViewersCombo.setText(store.getString(PreferenceConstants.PARAMETER_VIEWER_VIEWERNAME));
        this.paramViewersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ResultSetViewerPreferencePage.this.viewerName = ResultSetViewerPreferencePage.this.paramViewersCombo.getText();
            }
        });
        Composite compMaxParameter = new Composite(comp, 0);
        compMaxParameter.setLayoutData((Object)gridData);
        GridLayout layoutMaxParameter = new GridLayout();
        layoutMaxParameter.numColumns = 2;
        compMaxParameter.setLayout((Layout)layoutMaxParameter);
        Label maxParameterLabel = new Label(compMaxParameter, 0);
        maxParameterLabel.setText(Messages.ParameterViewer_ellipsisEnabledValue);
        maxParameterLabel.setToolTipText(Messages.ParameterViewerPreferencePage_parameterResultOptions_maxParmeterCount_tooltip);
        this.maxParamCount = new Text(compMaxParameter, 2052);
        this.maxParamCount.setToolTipText(Messages.ParameterViewerPreferencePage_parameterResultOptions_maxParmeterCount_tooltip);
        this.maxParamCount.setLayoutData((Object)gridData);
        this.maxParamCount.setText(store.getString(PreferenceConstants.ELLIPSIS_ENABLED_VALUE_LENGTH));
        this.maxParamCount.addModifyListener(this.modifyListener);
        int i2 = 0;
        while (i2 < this.myViewers.length) {
            this.viewersCombo.add(this.myViewers[i2]);
            ++i2;
        }
        this.viewersCombo.setText(store.getString(PreferenceConstants.RESULT_SET_VIEWER_VIEWERNAME));
        this.viewersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ResultSetViewerPreferencePage.this.viewerName = ResultSetViewerPreferencePage.this.viewersCombo.getText();
            }
        });
        return comp;
    }

    public boolean performOk() {
        this.store.setValue(PreferenceConstants.RESULT_SET_VIEWER_VIEWERNAME, this.viewersCombo.getText());
        this.store.setValue(PreferenceConstants.PARAMETER_VIEWER_VIEWERNAME, this.paramViewersCombo.getText());
        this.store.setValue(PreferenceConstants.ELLIPSIS_ENABLED_VALUE_LENGTH, this.maxParamCount.getText().trim());
        return super.performOk();
    }

    protected void performDefaults() {
        this.viewersCombo.setText(ResultSetViewerPreferencePage.getViewerNameFromExtension());
        this.paramViewersCombo.setText(ResultSetViewerPreferencePage.getParameterViewerNameFromExtension());
        this.maxParamCount.setText(this.store.getDefaultString(PreferenceConstants.ELLIPSIS_ENABLED_VALUE_LENGTH));
        super.performDefaults();
    }
}

