/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.filters;

import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import com.ibm.ims.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class ResultsFilterHelper {
    private static final char PROFILE_DELIMITER_CHAR = '\u0001';
    private static final String PROFILE_DELIMITER = Character.toString('\u0001');

    public static boolean isFilteredOut(String profileName) {
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        String filterStr = store.getString(PreferenceConstants.PROFILE_FILTERS_FILTERED_PROFILES);
        StringTokenizer st = new StringTokenizer(filterStr, PROFILE_DELIMITER);
        while (st.hasMoreTokens()) {
            String profile = st.nextToken();
            if (!profile.equals(profileName)) continue;
            return true;
        }
        return false;
    }

    public static void saveFilters(String[] profiles) {
        if (profiles == null) {
            return;
        }
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < profiles.length) {
            sb.append(profiles[i]);
            if (profiles.length != i + 1) {
                sb.append(PROFILE_DELIMITER);
            }
            ++i;
        }
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PreferenceConstants.PROFILE_FILTERS_FILTERED_PROFILES, sb.toString());
    }
}

