/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.result.internal.filters;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.sqltools.result.OperationCommand;
import com.ibm.ims.datatools.sqltools.result.internal.filters.ResultsFilterHelper;
import com.ibm.ims.datatools.sqltools.result.internal.model.ResultInstance;
import com.ibm.ims.datatools.sqltools.result.internal.ui.PreferenceConstants;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ConnectionProfileFilter
extends ViewerFilter {
    IPreferenceStore _store;

    public ConnectionProfileFilter(IPreferenceStore store) {
        this._store = store;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ResultInstance) {
            List profiles = ImsDbUtils.getConnectionProfiles();
            ResultInstance instance = (ResultInstance)element;
            boolean isUnknownProfile = true;
            OperationCommand command = instance.getOperationCommand();
            for (ConnectionProfile profile : profiles) {
                if (command == null || !profile.getId().equals(command.getProfileId())) continue;
                isUnknownProfile = false;
                break;
            }
            if (isUnknownProfile) {
                return this._store.getBoolean(PreferenceConstants.PROFILE_FILTERS_UNKNOWNPROFILE);
            }
            return !ResultsFilterHelper.isFilteredOut(instance.getOperationCommand().getProfileId());
        }
        return false;
    }
}

