/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.wizards;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.common.ui.resource.WizardNewFileCreationPage;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoGroup;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.util.ExceptionHandler;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewSQLScrapbookFileWizardPage
extends WizardNewFileCreationPage {
    private static final String fgDefaultExtension = ".sql";
    private ConnectionInfoGroup _group = null;

    public NewSQLScrapbookFileWizardPage(IStructuredSelection selection) {
        super("createScrapBookPage", selection);
        this.setTitle(SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.title"));
    }

    public boolean finish() {
        String fileName = this.getFileName();
        if (fileName != null && !fileName.endsWith(fgDefaultExtension)) {
            this.setFileName(fileName + fgDefaultExtension);
        }
        boolean retValue = super.validatePage();
        final IFile file = this.createNewFile();
        if (retValue && file != null) {
            Shell shell = this.getShell();
            IWorkbenchPage page = SqlscrapbookPlugin.getActivePage();
            if (shell == null || page == null) {
                return true;
            }
            final IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                });
            }
            try {
                this._group.finish();
                if (SqlscrapbookPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.ims.datatools.sqltools.sqlscrapbookpreference.defaultopen")) {
                    SQLScrapbookEditorInput editorInput = new SQLScrapbookEditorInput(file, this._group.getConnectionInfo());
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.ims.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
                }
                return true;
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), shell, SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.open_error.message"), e.getMessage());
            }
        }
        return false;
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (!valid) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = SqlscrapbookPlugin.getWorkspace().getRoot();
        Object fileName = this.getFileName();
        if (fileName != null && !((String)fileName).endsWith(fgDefaultExtension)) {
            fileName = (String)fileName + fgDefaultExtension;
            IPath path = this.getContainerFullPath();
            if (path != null && workspaceRoot.exists(path.append((String)fileName))) {
                this.setErrorMessage(SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.error.AlreadyExists"));
                return false;
            }
        }
        if (!PosixPortablePathValidator.isPortableName((String)fileName)) {
            this.setErrorMessage(SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.error.InvalidFileName"));
            return false;
        }
        if (valid && this._group != null && !this._group.canFinish()) {
            this.setMessage(SqlscrapbookPlugin.getResourceString("NewFileWithProfilePage.error.profile"));
            this.setErrorMessage(null);
            valid = false;
        }
        if (valid && this._group != null && this._group.getWarning() != null) {
            this.setMessage(this._group.getWarning());
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void createPageControl(Composite parent) {
        super.createPageControl(parent);
        ISQLEditorConnectionInfo connInfo = SQLFileUtil.getDefaultConnectionInfo();
        this._group = new ConnectionInfoGroup(parent, (Listener)this, connInfo, false, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HelpUtil.getContextId((String)"new_sql_file", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }
}

