/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.util;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import com.ibm.ims.datatools.sqltools.core.profile.ProfileUtil;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.editor.ScrapbookEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.sql.util.ModelUtil;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public class SQLFileUtil {
    public static final String DSEID = "com.ibm.ims.datatools.connectivity.DataSourceExplorerNavigator";

    public static ISQLEditorConnectionInfo getConnectionInfo(IFile file) {
        String encodedConnection = null;
        encodedConnection = SQLFileUtil.getEncodedConnectionInfo(file);
        ISQLEditorConnectionInfo connectionInfo = encodedConnection != null && !encodedConnection.trim().equals("") ? SQLEditorConnectionInfo.decode((String)encodedConnection) : SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        return connectionInfo;
    }

    public static ISQLEditorConnectionInfo getConnectionInfo4Scrapbook(ISQLEditorConnectionInfo connInfo) {
        ScrapbookEditorConnectionInfo scrapbookConnInfo = new ScrapbookEditorConnectionInfo(connInfo);
        scrapbookConnInfo.setAutoCommit(SqlscrapbookPlugin.getDefault().getPreferenceStore().getInt("com.ibm.ims.datatools.sqltools.sqlscrapbookpreference.commitmode") == 0);
        return scrapbookConnInfo;
    }

    public static String getEncodedConnectionInfo(IFile file) {
        String encodedConnection = null;
        if (file != null) {
            try {
                encodedConnection = file.getPersistentProperty(new QualifiedName("com.ibm.ims.datatools.sqltools.sqlscrapbook", "encodedConnection"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return encodedConnection;
    }

    public static void setEncodedConnectionInfo(IFile fileResource, String encodedConnection) {
        try {
            if (fileResource.exists()) {
                fileResource.setPersistentProperty(new QualifiedName("com.ibm.ims.datatools.sqltools.sqlscrapbook", "encodedConnection"), encodedConnection);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static ISQLEditorConnectionInfo getDefaultConnectionInfo() {
        String dftConn;
        ISQLEditorConnectionInfo editorConnectionInfo = SQLFileUtil.getSelectedConnectionInfo();
        if (editorConnectionInfo == null && (dftConn = SqlscrapbookPlugin.getDefault().getPreferenceStore().getString("SQLEditor.connection.info")) != null && !dftConn.equals("")) {
            editorConnectionInfo = SQLEditorConnectionInfo.decode((String)dftConn);
        }
        if (editorConnectionInfo == null) {
            return SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        }
        return editorConnectionInfo;
    }

    public static ISQLEditorConnectionInfo getSelectedConnectionInfo() {
        IViewReference[] reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < reference.length) {
            if (reference[i].getId().equals(DSEID)) {
                CommonNavigator view = (CommonNavigator)reference[i].getView(true);
                IStructuredSelection sel = (IStructuredSelection)view.getCommonViewer().getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof IConnectionProfile && ProfileUtil.isSupportedProfile((IConnectionProfile)((IConnectionProfile)obj))) {
                    return new SQLEditorConnectionInfo(null, ((IConnectionProfile)obj).getName(), "");
                }
                if (obj instanceof IVirtualNode) {
                    obj = ((IVirtualNode)obj).getParent();
                }
                if (obj instanceof SQLObject) {
                    IConnectionProfile profile;
                    String dbName = ModelUtil.getDatabaseName((EObject)((SQLObject)obj));
                    EObject database = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)((SQLObject)obj));
                    if (database instanceof Database && (profile = ModelUtil.getConnectionProfile((Database)((Database)database))) != null) {
                        return new SQLEditorConnectionInfo(null, profile.getName(), dbName);
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }
}

