/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.editor;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.customizers.ImsDbConnectionPreferences;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import com.ibm.ims.datatools.sqltools.internal.externalfile.ExternalSQLFileEditorInput;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteCurrentSQLAction;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteSQLAction;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteSQLAsOneStatementAction;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteSelectionSQLAction;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.AbstractConnectionInfoComposite;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoComposite2;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnManagerListener;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnServiceListener;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnectionManager;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnectionService;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.editor.ScrapbookEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import com.ibm.ims.datatools.sqltools.sqleditor.ISQLEditorInput;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.matching.GenericSQLMatchingPairs;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.matching.GenericSQLPairMatcher;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.matching.IMatchingPairs;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;

public class SQLScrapbookEditor
extends SQLEditor
implements ScrapbookConnServiceListener,
ScrapbookConnManagerListener {
    public static final String EDITOR_ID = "com.ibm.ims.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public SQLScrapbookEditor() {
        ScrapbookConnectionService.addListener(this);
        ScrapbookConnectionManager.addListener(this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setRulerContextMenuId("#SQLScrapbookEditorRulerContext");
        this.setDocumentProvider(SqlscrapbookPlugin.getDefault().getSQLEditorDocumentProvider());
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        ISQLEditorInput newInput = null;
        if (input instanceof SQLScrapbookEditorInput) {
            newInput = (SQLScrapbookEditorInput)input;
        } else if (input instanceof IFileEditorInput) {
            newInput = new SQLScrapbookEditorInput(((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((IPathEditorInput)input).getPath());
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof ILocationProvider) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((ILocationProvider)input).getPath((Object)input));
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof IAdaptable) {
            URI uri = (URI)input.getAdapter(URI.class);
            if (uri == null) {
                Class<?> clazz = input.getClass();
                try {
                    Method getURI = clazz.getMethod("getURI", null);
                    uri = (URI)getURI.invoke((Object)input, null);
                }
                catch (Exception exception) {}
            }
            if (uri != null) {
                IFileStore store = EFS.getStore((URI)uri);
                newInput = new ExternalSQLFileEditorInput(store);
            }
        }
        if (newInput == null) {
            super.doSetInput(input);
        } else {
            if (input instanceof SQLScrapbookEditorInput) {
                newInput.setEditorSite(this.getEditorSite());
            }
            super.doSetInput((IEditorInput)newInput);
        }
        super.setConnectionInfo(newInput.getConnectionInfo());
    }

    protected void createActions() {
        super.createActions();
        IActionBars bars = ((IEditorSite)this.getSite()).getActionBars();
        this.setAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSelectionAction", (IAction)new ScrapbookExecuteSelectionSQLAction(this));
        this.markAsSelectionDependentAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSelectionAction", true);
        bars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSelectionAction", this.getAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        this.setAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSQLAction", (IAction)new ScrapbookExecuteSQLAction(this));
        bars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSQLAction", this.getAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteSQLAction"));
        this.setAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction", (IAction)new ScrapbookExecuteSQLAsOneStatementAction(this));
        this.markAsSelectionDependentAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction", true);
        bars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction", this.getAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction"));
        this.setAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction", (IAction)new ScrapbookExecuteCurrentSQLAction(this));
        this.markAsSelectionDependentAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction", true);
        bars.setGlobalActionHandler("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction", this.getAction("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.doSetConnectionInfo(connInfo);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionInfoComposite connBar = ((ToolbarSourceViewer)SQLScrapbookEditor.this.getSV()).connBar;
                connBar.init(SQLScrapbookEditor.this.getConnectionInfo().getDatabaseVendorDefinitionId().toString(), SQLScrapbookEditor.this.getConnectionInfo().getConnectionProfileId(), SQLScrapbookEditor.this.getConnectionInfo().getDatabaseName());
                if (connBar.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo && SQLScrapbookEditor.this.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo) {
                    ((ScrapbookEditorConnectionInfo)connBar.getConnectionInfo()).setAutoCommit(((ScrapbookEditorConnectionInfo)SQLScrapbookEditor.this.getConnectionInfo()).isAuto());
                }
                connBar.refreshConnectionStatus();
            }
        });
    }

    protected void doSetConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        ISQLEditorConnectionInfo scrapbookConnInfo;
        ISQLEditorConnectionInfo preConnInfo = this.getConnectionInfo();
        ISQLEditorConnectionInfo iSQLEditorConnectionInfo = scrapbookConnInfo = connInfo instanceof ScrapbookEditorConnectionInfo ? connInfo : SQLFileUtil.getConnectionInfo4Scrapbook(connInfo);
        if (scrapbookConnInfo.encode().equals(preConnInfo.encode())) {
            super.setConnectionInfo(scrapbookConnInfo);
        } else {
            String content = this.getSV().getDocument().get();
            super.setConnectionInfo(scrapbookConnInfo);
            this.getSV().getDocument().set(content);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SQLScrapbookEditor.this.setTitleToolTip(SQLScrapbookEditor.this.getTitleToolTip());
            }
        });
    }

    public void dispose() {
        ScrapbookConnectionService.removeListener(this);
        ScrapbookConnectionManager.removeListener(this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() instanceof SQLEditorStorageEditorInput) {
            super.doSaveAs();
        }
        super.doSave(monitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
        super.doSave(null);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected SQLEditor.AdaptedSourceViewer doCreateSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new ToolbarSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.getConnectionInfo());
    }

    public void refreshConnectionStatus() {
        super.refreshConnectionStatus();
        if (this.getSV() != null) {
            ((ToolbarSourceViewer)this.getSV()).refreshConnectionStatus();
        }
    }

    public void refreshMatcher() {
        SQLDevToolsUIConfiguration sqlDevToolsConfig = SQLToolsUIFacade.getConfiguration((String)this.getDBType(), (DatabaseIdentifier)this.getDatabaseIdentifier());
        ICharacterPairMatcher matcher = sqlDevToolsConfig.getSQLEditorUIService().getSQLPairMatcher();
        if (matcher == null) {
            matcher = new GenericSQLPairMatcher((IMatchingPairs)GenericSQLMatchingPairs.getInstance());
        }
        this.setPairMatcher(matcher);
    }

    public IConnection getConnection() {
        return null;
    }

    @Override
    public void connProfileDisconnected(ConnectionProfile eventProfile) {
        logger.entering(this.getClass().getName(), "connProfileDisconnected(eventProfile.name={0}, eventProfile.id={1})", new Object[]{eventProfile != null ? eventProfile.getName() : "null", eventProfile != null ? eventProfile.getId() : "null"});
        try {
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            ConnectionProfile currProfile = connInfo.getConnectionProfile();
            if (currProfile != null && eventProfile.getId().equals(currProfile.getId())) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SQLScrapbookEditor.this.refreshConnectionStatus();
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(this.getClass().getName(), "connProfileDisconnected(ConnectionProfile)", new Object[0]);
    }

    @Override
    public void connProfileConnected(ConnectionProfile eventProfile) {
        logger.entering(this.getClass().getName(), "connProfileConnected(profile.name={0}, profile.id={1})", new Object[]{eventProfile != null ? eventProfile.getName() : "null", eventProfile != null ? eventProfile.getId() : "null"});
        try {
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            ConnectionProfile currProfile = connInfo.getConnectionProfile();
            if (currProfile != null && eventProfile.getId().equals(currProfile.getId())) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SQLScrapbookEditor.this.refreshConnectionStatus();
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(this.getClass().getName(), "connProfileConnected(ConnectionProfile)", new Object[0]);
    }

    @Override
    public void connProfileUpdated(ConnectionProfile updatedProfile) {
        block9: {
            logger.entering(this.getClass().getName(), "connProfileUpdated(profile.name={0}, profile.id={1})", new Object[]{updatedProfile != null ? updatedProfile.getName() : "null", updatedProfile != null ? updatedProfile.getId() : "null"});
            ISQLEditorConnectionInfo connInfo = null;
            try {
                try {
                    connInfo = this.getConnectionInfo();
                    ConnectionProfile profile = connInfo.getConnectionProfile();
                    if (profile != null && updatedProfile.getId().equals(profile.getId())) {
                        ConnectionConfiguration currConfig = profile.getConnectionConfiguration();
                        connInfo.setDatabaseName(ImsDbConnectionPreferences.getPsbName((ConnectionConfiguration)currConfig));
                        connInfo.setDefaultSchemaName(ImsDbConnectionPreferences.getCurrentSchema((ConnectionConfiguration)currConfig));
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    if (connInfo != null) {
                        this.setConnectionInfo(connInfo);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (connInfo != null) {
                    this.setConnectionInfo(connInfo);
                }
                throw throwable;
            }
            if (connInfo != null) {
                this.setConnectionInfo(connInfo);
            }
        }
        logger.exiting(this.getClass().getName(), "connProfileUpdated(ConnectionProfile)", new Object[0]);
    }

    @Override
    public void connProfileAdded(ConnectionProfile profile) {
        block8: {
            logger.entering(this.getClass().getName(), "connProfileAdded(profile.name={0}, profile.id={1})", new Object[]{profile != null ? profile.getName() : "null", profile != null ? profile.getId() : "null"});
            ISQLEditorConnectionInfo connInfo = null;
            try {
                try {
                    connInfo = this.getConnectionInfo();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    if (connInfo != null) {
                        this.setConnectionInfo(connInfo);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (connInfo != null) {
                    this.setConnectionInfo(connInfo);
                }
                throw throwable;
            }
            if (connInfo != null) {
                this.setConnectionInfo(connInfo);
            }
        }
        logger.exiting(this.getClass().getName(), "connProfileAdded(ConnectionProfile)", new Object[0]);
    }

    @Override
    public void connProfileRemoved(ConnectionProfile profile) {
        block8: {
            logger.entering(this.getClass().getName(), "connProfileRemoved(profile.name={0}, profile.id={1})", new Object[]{profile != null ? profile.getName() : "null", profile != null ? profile.getId() : "null"});
            ISQLEditorConnectionInfo connInfo = null;
            try {
                try {
                    connInfo = this.getConnectionInfo();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    if (connInfo != null) {
                        this.setConnectionInfo(connInfo);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (connInfo != null) {
                    this.setConnectionInfo(connInfo);
                }
                throw throwable;
            }
            if (connInfo != null) {
                this.setConnectionInfo(connInfo);
            }
        }
        logger.exiting(this.getClass().getName(), "connProfileRemoved(ConnectionProfile)", new Object[0]);
    }

    public class ToolbarSourceViewer
    extends SQLEditor.AdaptedSourceViewer
    implements Listener {
        private AbstractConnectionInfoComposite connBar;
        private boolean initialized;

        public ToolbarSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, ISQLEditorConnectionInfo initialConnInfo) {
            super((SQLEditor)SQLScrapbookEditor.this, parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.initialized = false;
            if (initialConnInfo != null) {
                this.connBar.init(initialConnInfo);
            }
        }

        protected void createControl(Composite parent, int styles) {
            Composite fDefaultComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginBottom = 0;
            fDefaultComposite.setLayout((Layout)gridLayout);
            fDefaultComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.connBar = new ConnectionInfoComposite2(fDefaultComposite, Window.getDefaultOrientation(), this, null, null, 410);
            this.connBar.setLayoutData(new GridData(4, 0x1000000, true, false));
            ((GridLayout)this.connBar.getLayout()).marginWidth = 12;
            Composite textComposite = new Composite(fDefaultComposite, 0);
            textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            textComposite.setLayout((Layout)new FillLayout());
            super.createControl(textComposite, styles);
        }

        public void handleEvent(Event event) {
            String content = this.getDocument().get();
            SQLScrapbookEditor.this.doSetConnectionInfo(this.connBar.getConnectionInfo());
            this.getDocument().set(content);
            SQLScrapbookEditor.this.refreshMatcher();
        }

        public void refreshConnectionStatus() {
            if (this.connBar != null) {
                if (!this.initialized) {
                    this.connBar.init();
                    this.initialized = true;
                }
                if (this.connBar.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo && SQLScrapbookEditor.this.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo) {
                    ((ScrapbookEditorConnectionInfo)this.connBar.getConnectionInfo()).setAutoCommit(((ScrapbookEditorConnectionInfo)SQLScrapbookEditor.this.getConnectionInfo()).isAuto());
                }
                this.connBar.refreshConnectionStatus();
            }
        }

        protected void handleDispose() {
            if (this.getDocument() != null && SQLScrapbookEditor.this._fSQLUpdater != null) {
                this.getDocument().removeDocumentListener((IDocumentListener)SQLScrapbookEditor.this._fSQLUpdater);
            }
            super.handleDispose();
        }
    }
}

