/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnServiceListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;

public class ScrapbookConnectionService
extends ConnectionServiceListener {
    public static final String TAG = ScrapbookConnectionService.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static List<ScrapbookConnServiceListener> listeners;

    static {
        IConnectionService cService = ConnectionsPlugin.getDefault().getConnectionService();
        cService.addConnectionServiceListener((ConnectionServiceListener)new ScrapbookConnectionService());
        listeners = new ArrayList<ScrapbookConnServiceListener>();
    }

    private ScrapbookConnectionService() {
    }

    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        try {
            if ("com.ibm.im.ims.workbench.imsdb.connections.category".equals(event.getConnectionCategoryId())) {
                ConnectionProfile profile = event.getConnectionProfile();
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    logger.info("Connection connected name={0},id={1},category={2}", new Object[]{profile.getName(), profile.getId(), event.getConnectionCategoryId()});
                    for (ScrapbookConnServiceListener listener : listeners) {
                        listener.connProfileConnected(profile);
                    }
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    logger.info("Connection disconnected name={0},id={1},category={2}", new Object[]{profile.getName(), profile.getId(), event.getConnectionCategoryId()});
                    for (ScrapbookConnServiceListener listener : listeners) {
                        listener.connProfileDisconnected(profile);
                    }
                } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                    Exception eventException = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                    logger.info("Connection exception name={0},id={1},category={2}: {3}", new Object[]{profile.getName(), profile.getId(), event.getConnectionCategoryId(), eventException.getMessage()});
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "event(ConnectionServiceEvent)", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ScrapbookConnServiceListener listener) {
        List<ScrapbookConnServiceListener> list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ScrapbookConnServiceListener listener) {
        List<ScrapbookConnServiceListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }
}

