/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.ScrapbookConnManagerListener;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;

public class ScrapbookConnectionManager
extends ConnectionManagerListener {
    public static final String TAG = ScrapbookConnectionManager.class.getName();
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static List<ScrapbookConnManagerListener> listeners;

    static {
        IConnectionManager cManager = ConnectionsPlugin.getDefault().getConnectionManager();
        cManager.addListener((ConnectionManagerListener)new ScrapbookConnectionManager());
        listeners = new ArrayList<ScrapbookConnManagerListener>();
    }

    private ScrapbookConnectionManager() {
    }

    public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
        logger.entering(TAG, "event(event={0})", new Object[]{event});
        try {
            ConnectionProfile profile = event.getConnectionProfile();
            IConnectionCategory category = profile.getConnectionDescriptor().getCategory();
            if ("com.ibm.im.ims.workbench.imsdb.connections.category".equals(category.getId())) {
                if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                    logger.info("Connection updated name={0},id={1},category={2}", new Object[]{profile.getName(), profile.getId(), category.getId()});
                    for (ScrapbookConnManagerListener listener : listeners) {
                        listener.connProfileUpdated(profile);
                    }
                } else if (event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                    logger.info("Connection added name={0},id={1},category={2}", new Object[]{profile.getName(), profile.getId(), category.getId()});
                    for (ScrapbookConnManagerListener listener : listeners) {
                        listener.connProfileAdded(profile);
                    }
                } else if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                    logger.info("Connection removed name={0},id={1},category={2}", new Object[]{profile.getName(), profile.getId(), category.getId()});
                    for (ScrapbookConnManagerListener listener : listeners) {
                        listener.connProfileRemoved(profile);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        logger.exiting(TAG, "event(ConnectionManagerEvent)", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ScrapbookConnManagerListener listener) {
        List<ScrapbookConnManagerListener> list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ScrapbookConnManagerListener listener) {
        List<ScrapbookConnManagerListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }
}

