/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.ProfileManager;
import com.ibm.ims.datatools.sqltools.common.ui.util.SWTUtils;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.profile.ProfileUtil;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.AbstractConnectionInfoComposite;
import com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionInfoGroup
extends AbstractConnectionInfoComposite
implements SelectionListener,
Listener {
    private Label _labelName = null;
    private Combo _comboProfileName = null;
    private Label _labelDbName = null;
    private Text _textDbName = null;
    private Button _checkBoxConnect = null;
    private Text _textWarning = null;
    private boolean _isConnected = false;
    private boolean _showWarning = true;

    public ConnectionInfoGroup(Composite parent, Listener listener, boolean showWarning) {
        this(parent, listener, null, null, showWarning, false);
    }

    public ConnectionInfoGroup(Composite parent, Listener listener, String profileName, String dbName, boolean showWarning, boolean mustConnect) {
        this(parent, listener, (ISQLEditorConnectionInfo)new SQLEditorConnectionInfo(null, profileName, dbName), showWarning, false);
    }

    public ConnectionInfoGroup(Composite parent, Listener listener, ISQLEditorConnectionInfo connInfo, boolean showWarning, boolean mustConnect) {
        this(parent, listener, connInfo, showWarning, mustConnect, null);
    }

    public ConnectionInfoGroup(Composite parent, Listener listener, ISQLEditorConnectionInfo connInfo, boolean showWarning, boolean mustConnect, Collection supportedDBDefinitionNames) {
        super(parent, 0, listener, connInfo, supportedDBDefinitionNames, 0xD | (mustConnect ? 64 : 0));
        this._showWarning = showWarning;
        this.createContents();
        if ((this._style & 0x80) == 0) {
            this.init();
        }
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    protected Control createContents() {
        GridLayout gridLayout1 = new GridLayout();
        GridLayout gridLayout2 = new GridLayout();
        GridData gridData2 = new GridData();
        GridData gridData3 = new GridData();
        GridData gridData6 = new GridData();
        this.setLayoutData(new GridData(1808));
        gridLayout1.marginWidth = 0;
        gridLayout1.numColumns = 2;
        this.setLayout((Layout)gridLayout1);
        this._labelName = new Label((Composite)this, 0);
        this._labelName.setText(Messages.SelectProfileDialog_profile_name);
        Composite compositeName = new Composite((Composite)this, 0);
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        compositeName.setLayoutData((Object)gridData3);
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        compositeName.setLayout((Layout)gridLayout2);
        this.createComboProfileName(compositeName);
        this._labelDbName = new Label((Composite)this, 0);
        this._labelDbName.setText(Messages.ConnectionInfoGroup_database_name);
        this.createTextDbName(this);
        if ((this._style & 0x40) != 64) {
            this._checkBoxConnect = new Button((Composite)this, 32);
            gridData2.horizontalSpan = 2;
            this._checkBoxConnect.setLayoutData((Object)gridData2);
            this._checkBoxConnect.setText(Messages.SelectProfileDialog_donot_connect);
            this._checkBoxConnect.addListener(13, (Listener)this);
            if (this._listener != null) {
                this._checkBoxConnect.addListener(13, this._listener);
            }
        }
        if (this._showWarning) {
            this._textWarning = new Text((Composite)this, 66);
            gridData6.grabExcessHorizontalSpace = true;
            gridData6.horizontalAlignment = 4;
            gridData6.verticalAlignment = 2;
            gridData6.horizontalSpan = 2;
            gridData6.verticalSpan = 2;
            this._textWarning.setLayoutData((Object)gridData6);
            this._textWarning.setEditable(false);
            this._textWarning.setText(Messages.SelectProfileDialog_warning);
            this._textWarning.setVisible(false);
            this.setSize(new Point(460, 469));
        }
        return this;
    }

    public void finish() {
        this.updateFields();
        if (!this.canFinish()) {
            return;
        }
        if ((this._style & 0x40) != 64 && this._checkBoxConnect.getSelection()) {
            this._isConnected = false;
        } else if (!SWTUtils.notEmpty((Combo)this._comboProfileName)) {
            this._isConnected = false;
        } else {
            IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(this._profileId);
            if (profile == null) {
                this._isConnected = false;
            } else {
                try {
                    ProfileUtil.getOrCreateReusableConnection((DatabaseIdentifier)new DatabaseIdentifier(this._profileId, this._dbName));
                    this._isConnected = true;
                    String user = ProfileUtil.getProfileUserName((DatabaseIdentifier)new DatabaseIdentifier(this._profileId, this._dbName), (boolean)true);
                    this._connInfo.setDefaultSchemaName(user);
                }
                catch (Exception e) {
                    String statusmsg = e.getMessage();
                    if (statusmsg == null) {
                        statusmsg = "";
                    }
                    Status status = new Status(4, "com.ibm.ims.datatools.sqltools.editor.core", 0, statusmsg, (Throwable)e);
                    Shell shell = this.getShell();
                    String title = Messages.SelectProfileDialog_error_jdbc_title;
                    String msg = Messages.SelectProfileDialog_error_jdbc_message;
                    ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)status);
                }
            }
        }
        if (this._isConnected) {
            this._connInfo.setProfileStatus(5);
        } else {
            this._connInfo.setProfileStatus(2);
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        this.updateConnectCheckBox();
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (event.widget == this._checkBoxConnect) {
            this.updateConnectCheckBox();
        }
    }

    @Override
    public void init(String dbVendorName, String initialProfileId, String initialDatabaseName) {
        super.init(dbVendorName, initialProfileId, initialDatabaseName);
        this.updateConnectCheckBox();
    }

    void updateConnectCheckBox() {
        if (this._checkBoxConnect != null) {
            this._checkBoxConnect.setEnabled(this._profileId != null && !this._connInfo.isConnected());
            if (this._showWarning) {
                this._textWarning.setVisible(this._checkBoxConnect.isEnabled() && this._checkBoxConnect.getSelection());
            }
        }
    }

    public boolean canFinish() {
        return (this._style & 0x40) != 64 || SWTUtils.notEmpty((Combo)this._comboProfileName);
    }

    public String getWarning() {
        if ((this._style & 0x40) != 64 && this._checkBoxConnect.getSelection()) {
            return Messages.SelectProfileDialog_warning;
        }
        return null;
    }

    private void createComboProfileName(Composite composite) {
        GridData gridData5 = new GridData();
        this._comboProfileName = new Combo(composite, 8);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._comboProfileName.setLayoutData((Object)gridData5);
        this.initProfileNames(DATABASE_VENDOR_DEFINITION_ID.getProductName(), this._profileId);
        this._comboProfileName.addSelectionListener((SelectionListener)this);
    }

    private void createTextDbName(Composite composite) {
        GridData gridData5 = new GridData();
        this._textDbName = new Text(composite, 8);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._textDbName.setLayoutData((Object)gridData5);
        if (this._dbName != null) {
            this._textDbName.setText(this._dbName);
        }
    }

    @Override
    public Combo getProfileNamesControl() {
        return this._comboProfileName;
    }

    @Override
    public Text getDbNameControl() {
        return this._textDbName;
    }
}

