/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook.connection;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.customizers.ImsDbConnectionPreferences;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.sqltools.core.DatabaseVendorDefinitionId;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractConnectionInfoComposite
extends Composite {
    public static final int STYLE_CREATE_PROFILE = 1;
    public static final int STYLE_SHOW_STATUS = 2;
    public static final int STYLE_MULTI_LINE = 4;
    public static final int STYLE_SEPARATE_TYPE_NAME = 8;
    public static final int STYLE_SINGLE_GROUP = 16;
    public static final int STYLE_LABEL_GROUP = 32;
    public static final int STYLE_MUST_CONNECT = 64;
    public static final int STYLE_LAZY_INIT = 128;
    public static final int STYLE_SHOW_COMMIT_MODE = 256;
    protected static final DatabaseVendorDefinitionId DATABASE_VENDOR_DEFINITION_ID = SQLToolsFacade.getNonSpecificDatabaseVendorDefinitionId();
    protected String _profileId = null;
    protected String _dbName = null;
    protected DatabaseVendorDefinitionId _dbVendorId = DATABASE_VENDOR_DEFINITION_ID;
    protected ISQLEditorConnectionInfo _connInfo = null;
    protected Listener _listener;
    protected int _style = 42;
    protected Collection _supportedDBDefinitionNames = null;
    protected Collection _supportedDBDefinitionIds = null;

    public AbstractConnectionInfoComposite(Composite parent, int style) {
        super(parent, style);
    }

    public AbstractConnectionInfoComposite(Composite parent, int style, Listener listener, ISQLEditorConnectionInfo connInfo, Collection supportedDBDefinitionNames, int infoStyle) {
        super(parent, style);
        this.setup(connInfo);
        this._listener = listener;
        this._style = infoStyle;
    }

    private void setup(ISQLEditorConnectionInfo connInfo) {
        if (connInfo != null) {
            this._profileId = connInfo.getConnectionProfileId();
            this._dbName = connInfo.getDatabaseName();
            this._dbVendorId = connInfo.getDatabaseVendorDefinitionId() == null ? DATABASE_VENDOR_DEFINITION_ID : connInfo.getDatabaseVendorDefinitionId();
        }
    }

    protected void updateFields() {
        this.readControlValues();
        this._connInfo = new SQLEditorConnectionInfo(this._dbVendorId, this._profileId, this._dbName);
    }

    protected void initDBName() {
        ConnectionConfiguration config;
        String psbName;
        ConnectionProfile profile;
        if (this._profileId != null && (profile = ImsDbUtils.getConnectionProfileById((String)this._profileId)) != null && (psbName = ImsDbConnectionPreferences.getPsbName((ConnectionConfiguration)(config = profile.getConnectionConfiguration()))) != null) {
            this.getDbNameControl().setText(psbName);
        }
    }

    protected void readControlValues() {
        this._dbVendorId = DATABASE_VENDOR_DEFINITION_ID;
        if (this.getProfileNamesControl().getText() != null && !"".equals(this.getProfileNamesControl().getText())) {
            List profileQNames = ImsDbUtils.getQualifiedProfileNames();
            this._profileId = (String)((Pair)profileQNames.get(this.getProfileNamesControl().getSelectionIndex())).getRight();
        } else {
            this._profileId = null;
        }
        this._dbName = this.getDbNameControl() != null && this.getDbNameControl().getText() != null && !"".equals(this.getDbNameControl().getText()) ? this.getDbNameControl().getText() : null;
    }

    public void setInfoStyle(int style) {
        this._style = style;
    }

    public int getInfoStyle() {
        return this._style;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._connInfo;
    }

    protected void notifyListener() {
        if (this._listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this._listener.handleEvent(changeEvent);
        }
    }

    public void init() {
        this.init(this._dbVendorId.toString(), this._profileId, this._dbName);
    }

    public void init(ISQLEditorConnectionInfo connInfo) {
        this.setup(connInfo);
        this.init();
    }

    public void init(String dbVendorName, String initialProfileId, String initialDatabaseName) {
        this.setConnectionInfo(dbVendorName, initialProfileId, initialDatabaseName);
        this.initProfileNames(this._dbVendorId.toString(), this._profileId);
        this.initDBName();
    }

    protected DatabaseVendorDefinitionId findDatabaseVendorDefinitionId(DatabaseVendorDefinitionId dbId) {
        for (DatabaseVendorDefinitionId existId : this._supportedDBDefinitionIds) {
            if (!existId.equals((Object)dbId)) continue;
            return existId;
        }
        return null;
    }

    protected void initProfileNames(String dbVendorName, String initialProfileId) {
        ConnectionProfile initProfile;
        this.getProfileNamesControl().removeAll();
        for (Pair qName : ImsDbUtils.getQualifiedProfileNames()) {
            this.getProfileNamesControl().add((String)qName.getLeft());
        }
        if (initialProfileId != null && (initProfile = ImsDbUtils.getConnectionProfileById((String)initialProfileId)) != null) {
            this.getProfileNamesControl().setText(initProfile.getName());
        }
    }

    protected void setConnectionInfo(String dbVendorName, String initialProfileId, String initialDatabaseName) {
        this._profileId = initialProfileId;
        this._dbName = initialDatabaseName;
        this._dbVendorId = dbVendorName == null ? DATABASE_VENDOR_DEFINITION_ID : new DatabaseVendorDefinitionId(dbVendorName);
        this._connInfo = new SQLEditorConnectionInfo(this._dbVendorId, this._profileId, this._dbName);
    }

    public abstract Combo getProfileNamesControl();

    public abstract Text getDbNameControl();

    protected String[] getCurrentProfileNames() {
        return ImsDbUtils.getConnectionProfileNames().toArray(new String[0]);
    }

    public void refreshConnectionStatus() {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.readControlValues();
        if (e.widget == this.getProfileNamesControl()) {
            this.initDBName();
        }
        this.updateFields();
        this.notifyListener();
    }

    public void handleEvent(Event event) {
    }
}

