/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.internal.sqlscrapbook;

import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.sqleditor.ISQLEditorInput;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.part.FileEditorInput;

public class SQLEditorFileEditorInput
extends FileEditorInput
implements ISQLEditorInput {
    private ISQLEditorConnectionInfo fConnInfo;

    public static IFile createTempFileResource(String initialFileContent) {
        String fileNamePrefix = "SQLStatement";
        String fileExtension = ".sql";
        return SQLEditorFileEditorInput.createTempFileResource(initialFileContent, fileNamePrefix, fileExtension);
    }

    public static IFile createTempFileResource(String initialFileContent, String fileNamePrefix, String fileExtension) {
        IFile fileResource = null;
        if (initialFileContent == null) {
            initialFileContent = "";
        }
        if (fileNamePrefix == null) {
            fileNamePrefix = "";
        }
        if (fileExtension == null) {
            fileExtension = ".sql";
        } else if (!((String)fileExtension).startsWith(".")) {
            fileExtension = "." + (String)fileExtension;
        }
        try {
            int c;
            File tempFile = File.createTempFile(fileNamePrefix, (String)fileExtension);
            StringReader reader = new StringReader(initialFileContent);
            FileWriter writer = new FileWriter(tempFile);
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            reader.close();
            writer.close();
            String pathStr = tempFile.getAbsolutePath();
            Path path = new Path(pathStr);
            fileResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (Exception exception) {}
        return fileResource;
    }

    public SQLEditorFileEditorInput(IFile aFile) {
        super(aFile);
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo == null ? SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO : connInfo;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public String getId() {
        return this.toString();
    }
}

