/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;

public class J2CUIPropertyUtil
extends PropertyUtil {
    public static ArrayList<ISingleValuedProperty> getProperties(IPropertyGroup propertyGroup, int type) {
        ArrayList<ISingleValuedProperty> retProperties = new ArrayList<ISingleValuedProperty>(3);
        if (propertyGroup == null) {
            return retProperties;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (type == 1 && CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 2 && CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 3 && CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 4 && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                }
            }
            ++i;
        }
        return retProperties;
    }

    public static ArrayList<ISingleValuedProperty> getAllProperties(IPropertyGroup propertyGroup, int type) {
        ArrayList<ISingleValuedProperty> retProperties = new ArrayList<ISingleValuedProperty>(3);
        if (propertyGroup == null) {
            return retProperties;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                ArrayList<ISingleValuedProperty> list = J2CUIPropertyUtil.getAllProperties((IPropertyGroup)properties[i], type);
                if (!list.isEmpty()) {
                    retProperties.addAll(list);
                }
            } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (type == 1 && CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 2 && CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 3 && CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                } else if (type == 4 && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)cprop)) {
                    retProperties.add((ISingleValuedProperty)cprop);
                }
            }
            ++i;
        }
        return retProperties;
    }

    public static ArrayList<ArrayList> getProperties(IPropertyGroup propertyGroup) {
        ArrayList<JavaProjectProperty> projList = new ArrayList<JavaProjectProperty>(3);
        ArrayList<JavaPackageProperty> pkgList = new ArrayList<JavaPackageProperty>(3);
        ArrayList<JavaClassNameProperty> classList = new ArrayList<JavaClassNameProperty>(3);
        ArrayList<FileProperty> fileList = new ArrayList<FileProperty>(3);
        if (propertyGroup == null) {
            return null;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                ArrayList<ArrayList> list = J2CUIPropertyUtil.getProperties((IPropertyGroup)properties[i]);
                if (list != null) {
                    projList.addAll(list.get(0));
                    pkgList.addAll(list.get(1));
                    classList.addAll(list.get(2));
                    fileList.addAll(list.get(3));
                }
            } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    projList.add((JavaProjectProperty)cprop);
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    pkgList.add((JavaPackageProperty)cprop);
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    classList.add((JavaClassNameProperty)cprop);
                } else if (CustomPropertyHelper.isSingleFileProperty((ICustomProperty)cprop)) {
                    fileList.add((FileProperty)cprop);
                }
            }
            ++i;
        }
        ArrayList<ArrayList> retProperties = new ArrayList<ArrayList>(4);
        retProperties.add(projList);
        retProperties.add(pkgList);
        retProperties.add(classList);
        retProperties.add(fileList);
        return retProperties;
    }

    public static String getJavaClassPath(IPropertyGroup propertyGroup) {
        if (propertyGroup == null) {
            return null;
        }
        String[] names = J2CUIPropertyUtil.getJavaClassPathNames(propertyGroup);
        if (names != null && names[2] != null && names[2].length() > 0) {
            StringBuffer path = new StringBuffer(names[2]);
            if (!path.toString().endsWith(".java")) {
                path.append(".java");
            }
            if (names[1] != null && names[1].length() > 0) {
                path.insert(0, '/').insert(0, names[1]);
                if (names[0] != null && names[0].length() > 0) {
                    path.insert(0, '/').insert(0, names[0]).insert(0, '/');
                }
            }
            return path.toString();
        }
        return null;
    }

    public static String[] getJavaClassPathNames(IPropertyGroup propertyGroup) {
        String[] names = new String[3];
        if (propertyGroup == null) {
            return null;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) && names[0] == null && names[1] == null && names[2] == null) {
                String[] retNames = J2CUIPropertyUtil.getJavaClassPathNames((IPropertyGroup)properties[i]);
                if (retNames != null) {
                    if (retNames[0] != null && retNames[0].length() > 0) {
                        names[0] = retNames[0];
                    }
                    if (retNames[1] != null && retNames[1].length() > 0) {
                        names[1] = retNames[1];
                    }
                    if (retNames[2] != null && retNames[2].length() > 0) {
                        names[2] = retNames[2];
                    }
                }
            } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)properties[i])) {
                ICustomProperty cprop = (ICustomProperty)properties[i];
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    names[0] = ((JavaProjectProperty)cprop).getValueAsString();
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    names[1] = ((JavaPackageProperty)cprop).getValueAsString().replace('.', '/');
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    names[2] = ((JavaClassNameProperty)cprop).getValueAsString();
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)properties[i])) {
                INodeProperty root = ((ITreeProperty)properties[i]).getRoot();
                String[] retNames = null;
                if (root != null) {
                    retNames = J2CUIPropertyUtil.getJavaClassPathNames(root.createConfigurationProperties());
                }
                if (retNames != null) {
                    if (retNames[0] != null && retNames[0].length() > 0) {
                        names[0] = retNames[0];
                    }
                    if (retNames[1] != null && retNames[1].length() > 0) {
                        names[1] = retNames[1];
                    }
                    if (retNames[2] != null && retNames[2].length() > 0) {
                        names[2] = retNames[2];
                    }
                }
            }
            if (names[0] != null && names[1] != null && names[2] != null) break;
            ++i;
        }
        return names;
    }

    public static void assignValue(IPropertyDescriptor spd, IPropertyDescriptor tpd) throws CoreException {
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)tpd)) {
            ((ISingleValuedProperty)tpd).setValue(((ISingleValuedProperty)spd).getValue());
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)tpd)) {
            Object[] values = ((IMultiValuedProperty)spd).getValues();
            IMultiValuedProperty target = (IMultiValuedProperty)tpd;
            int i = 0;
            while (i < values.length) {
                target.addValue(values[i]);
                ++i;
            }
        }
    }

    public static void populateJavaClassPathList(IPropertyGroup propertyGroup, ArrayList files) {
        if (propertyGroup == null) {
            return;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        if (properties == null || properties.length < 1) {
            return;
        }
        String pj = null;
        String pkg = null;
        ArrayList<String> javaClasses = new ArrayList<String>();
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor prop = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)prop)) {
                J2CUIPropertyUtil.populateJavaClassPathList((IPropertyGroup)prop, files);
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)prop)) {
                J2CUIPropertyUtil.populateJavaClassPathList(((ITreeProperty)prop).getRoot(), files);
            } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                ICustomProperty cprop = (ICustomProperty)prop;
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    pj = ((JavaProjectProperty)prop).getValueAsString();
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    pkg = ((JavaPackageProperty)prop).getValueAsString();
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    javaClasses.add(((JavaClassNameProperty)prop).getValueAsString());
                }
            }
            ++i;
        }
        if (pj != null && pj.length() > 0 && pkg != null && pkg.length() > 0 && javaClasses.size() > 0) {
            StringBuffer prefix = new StringBuffer(pj).append('/').append(pkg).append('/');
            int i2 = 0;
            while (i2 < javaClasses.size()) {
                String name = (String)javaClasses.get(i2);
                if (name != null && name.length() > 0) {
                    files.add(new StringBuffer(name).insert(0, prefix).toString());
                }
                ++i2;
            }
        }
    }

    public static void populateJavaClassPathList(INodeProperty node, ArrayList files) {
        if (node == null) {
            return;
        }
        IPropertyGroup pg = node.createConfigurationProperties();
        J2CUIPropertyUtil.populateJavaClassPathList(pg, files);
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                J2CUIPropertyUtil.populateJavaClassPathList(children[i], files);
                ++i;
            }
        }
    }

    public static void modifyJavaProjectNameProperty(Iterator propIter, String projNameOld, String projNameNew) {
        while (propIter.hasNext()) {
            JavaProjectProperty pj;
            ICustomProperty cprop;
            IPropertyDescriptor pDesc = (IPropertyDescriptor)propIter.next();
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)pDesc)) {
                IPropertyGroup gr = (IPropertyGroup)pDesc;
                J2CUIPropertyUtil.modifyJavaProjectNameProperty(Arrays.asList(gr.getProperties()).iterator(), projNameOld, projNameNew);
            }
            if (!PropertyHelper.isCustomProperty((IPropertyDescriptor)pDesc) || !CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)(cprop = (ICustomProperty)pDesc)) || !(pj = (JavaProjectProperty)pDesc).getValueAsString().equals(projNameOld)) continue;
            try {
                pj.setValueAsString(projNameNew);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

