/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.J2CUIDataTypeHierarchyScope;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIWidgetFactory;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class J2CUICoreHelper {
    public static final String RUNTIME_TYPE_V70_STUB = "WebSphere Application Server v7.0 stub";
    public static final String RUNTIME_TYPE_V70 = "WebSphere Application Server v7.0";
    public static final String RUNTIME_TYPE_V70_ID = "com.ibm.ws.ast.st.runtime.v70";
    private static J2CUICoreHelper helper_;
    private IPropertyUIWidgetFactory factory_ = PropertyUIFactory.instance().getUIFactory();
    private J2CUIWidgetFactory j2cWidgetFactory_ = new J2CUIWidgetFactory();

    public static J2CUICoreHelper getDefault() {
        if (helper_ == null) {
            helper_ = new J2CUICoreHelper();
        }
        return helper_;
    }

    public IPropertyUIWidgetFactory getFactory() {
        return this.factory_;
    }

    public J2CUIWidgetFactory getJ2CUIWidgetFactory() {
        return this.j2cWidgetFactory_;
    }

    public String[] getDisplayString(String msg) {
        String[] rv = new String[1];
        StringBuffer str = new StringBuffer(msg.trim());
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '&') {
                str.deleteCharAt(i);
                break;
            }
            ++i;
        }
        if (str.charAt(str.length() - 1) == ':') {
            str.deleteCharAt(str.length() - 1);
        }
        StringBuffer str1 = new StringBuffer("'");
        str1.append(str);
        str1.append("'");
        rv[0] = str1.toString();
        return rv;
    }

    public IType[] browseDataType(Shell parentShell, String title, String message, boolean multipleSelection) {
        return this.browseDataType(parentShell, title, message, multipleSelection, null);
    }

    public IType[] browseDataType(Shell parentShell, String title, String message, boolean multipleSelection, ITypeInfoFilterExtension filterExtension) {
        return this.browseDataType((IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), parentShell, title, message, multipleSelection);
    }

    public IType[] browseDataType(IResource[] resources, Shell parentShell, String title, String message, boolean multipleSelection) {
        return this.browseDataType(resources, parentShell, title, message, multipleSelection, null);
    }

    public IType[] browseDataType(IResource[] resources, Shell parentShell, String title, String message, boolean multipleSelection, ITypeInfoFilterExtension filterExtension) {
        ArrayList<IType> searchTypes = new ArrayList<IType>();
        ArrayList<IResource> resourceList = new ArrayList<IResource>(resources.length);
        IType type = null;
        int i = 0;
        while (i < resources.length) {
            IJavaElement javaElement = JavaCore.create((IResource)resources[i]);
            if (javaElement != null) {
                if (javaElement instanceof IJavaProject) {
                    try {
                        type = ((IJavaProject)javaElement).findType("jakarta.resource.cci.Record");
                    }
                    catch (JavaModelException javaModelException) {
                        type = null;
                    }
                }
                if (type != null) {
                    resourceList.add(resources[i]);
                    if (searchTypes.indexOf(type) == -1) {
                        searchTypes.add(type);
                    }
                }
            }
            ++i;
        }
        IType[] types = new IType[searchTypes.size()];
        searchTypes.toArray(types);
        IResource[] newResources = new IResource[resourceList.size()];
        resourceList.toArray(newResources);
        return this.browseDataTypeDialog(types, newResources, parentShell, title, message, multipleSelection, filterExtension);
    }

    private IType[] browseDataTypeDialog(IType[] searchTypes, IResource[] resources, Shell parentShell, String title, String message, boolean multipleSelection, final ITypeInfoFilterExtension filterExtension) {
        ArrayList<Object> types = new ArrayList<Object>();
        try {
            J2CUIDataTypeHierarchyScope scope = new J2CUIDataTypeHierarchyScope(searchTypes, null, resources);
            TypeSelectionExtension typeExtension = new TypeSelectionExtension(){

                public ITypeInfoFilterExtension getFilterExtension() {
                    return filterExtension;
                }
            };
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)new ProgressMonitorDialog(parentShell), (IJavaSearchScope)scope, (int)2, (boolean)multipleSelection, (String)"*", (TypeSelectionExtension)typeExtension);
            dialog.setTitle(title);
            dialog.setMessage(message);
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0) {
                int i = 0;
                while (i < results.length) {
                    if (results[i] instanceof IType) {
                        types.add(results[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        IType[] returnTypes = new IType[types.size()];
        types.toArray(returnTypes);
        return returnTypes;
    }

    public IResource[] getSearchProjects(String currentProjectName) {
        IProject[] resources = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> selectedResources = new ArrayList<IProject>(6);
        IProject currentProject = null;
        if (currentProjectName != null && currentProjectName.length() > 0) {
            currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(currentProjectName);
        }
        if (currentProject != null) {
            selectedResources.add(currentProject);
        }
        int i = 0;
        while (i < resources.length) {
            if (selectedResources.indexOf(resources[i]) == -1) {
                IVirtualComponent comp = ComponentCore.createComponent((IProject)resources[i]);
                if (currentProject == null || !this.isWebComponent(comp)) {
                    selectedResources.add(resources[i]);
                }
            }
            ++i;
        }
        IResource[] returnResources = new IResource[selectedResources.size()];
        selectedResources.toArray(returnResources);
        return returnResources;
    }

    public boolean isWebComponent(IVirtualComponent comp) {
        try {
            return ResourceUtils.isDynamicWebProject(comp.getProject());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public URI createEMFURI(String path, int type) {
        URI uri;
        StringBuffer file = new StringBuffer("/");
        if (!path.startsWith("/")) {
            file.append(path);
            uri = type == 1 ? URI.createPlatformResourceURI((String)file.toString()) : URI.createFileURI((String)file.toString());
        } else {
            uri = type == 1 ? URI.createPlatformResourceURI((String)path) : URI.createFileURI((String)path);
        }
        return uri;
    }

    public String getCurrentProjectRuntime(String name) {
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        String ptype = ResourceUtils.getJ2EEProjectType(currentProject);
        String runtime = null;
        if (ptype.endsWith("web") || ptype.endsWith("ejb")) {
            try {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 = ProjectFacetsManager.create((IProject)currentProject).getPrimaryRuntime();
                if (runtime2 != null) {
                    IRuntime serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime2);
                    runtime = serverRuntime.getName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return runtime;
    }

    public String getCurrentProjectType(String name) {
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return this.buildProjectType(currentProject);
    }

    public String buildProjectType(IProject currentProject) {
        String projectType_ = null;
        if (ResourceUtils.isEJBProject(currentProject)) {
            projectType_ = "EJB";
        } else if (ResourceUtils.isDynamicWebProject(currentProject)) {
            projectType_ = "Web";
        } else if (ResourceUtils.isJavaProject(currentProject)) {
            projectType_ = "Java";
        }
        return projectType_;
    }

    public String getProperBiDiString(String str) {
        return str;
    }

    public String getProperBiDiString(String str, String delimiter, boolean appendDefault) {
        return str;
    }

    public void populateModelsTargetRuntime(IDataModel importDataModel) {
        this.populateModelsTargetRuntime(importDataModel, null);
    }

    public void populateModelsTargetRuntime(IDataModel importDataModel, boolean force51Target) {
        if (force51Target) {
            this.populateModelsTargetRuntime(importDataModel, RUNTIME_TYPE_V70_ID);
        } else {
            this.populateModelsTargetRuntime(importDataModel, null);
        }
    }

    public void populateModelsTargetRuntime(IDataModel importDataModel, String runtimeID) {
        DataModelPropertyDescriptor[] descriptors = importDataModel.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        Object value = null;
        if (runtimeID != null) {
            if (descriptors != null && descriptors.length > 0) {
                try {
                    int i = 0;
                    while (i < descriptors.length) {
                        IRuntime rT;
                        String targetServerTypeId;
                        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runT = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)descriptors[i].getPropertyValue();
                        if (runT != null && (targetServerTypeId = (rT = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runT)).getRuntimeType().getId()).equals(runtimeID)) {
                            value = descriptors[i].getPropertyValue();
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (value != null) {
                importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", value);
                return;
            }
        }
        if (descriptors != null && descriptors.length > 0) {
            value = descriptors[0].getPropertyValue();
        }
        List lst = ProductManager.getDefaultRuntimes();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime defaultRuntime = null;
        if (!lst.isEmpty()) {
            defaultRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)lst.get(0);
        }
        if (defaultRuntime != null) {
            try {
                importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)defaultRuntime);
            }
            catch (Exception exception) {
                importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", value);
            }
        } else {
            importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", value);
        }
    }

    public IPackageFragmentRoot getSourcePackage(IJavaProject javaProject) throws JavaModelException {
        if (javaProject == null) {
            return null;
        }
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < fragmentRoots.length) {
            if (fragmentRoots[i].getKind() == 1) {
                return fragmentRoots[i];
            }
            ++i;
        }
        return javaProject.getPackageFragmentRoot(javaProject.getCorrespondingResource());
    }
}

