/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.propertygroup.IPropertyGroup;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class J2CTeamSupporter {
    protected Object context_;
    protected ArrayList files_ = new ArrayList();

    public J2CTeamSupporter(Object context) {
        this.context_ = context;
    }

    public void addFile(String file) {
        IFile iFile;
        if (file != null && file.length() > 0 && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(file))) != null && iFile.exists() && iFile.isReadOnly() && this.files_.indexOf(iFile) == -1) {
            this.files_.add(file);
        }
    }

    public void addFiles(String[] files) {
        int i = 0;
        while (i < files.length) {
            this.addFile(files[i]);
            ++i;
        }
    }

    public void addFile(IFile file) {
        if (file != null && file.exists() && file.isReadOnly() && this.files_.indexOf(file) == -1) {
            this.files_.add(file);
        }
    }

    public void addFiles(IFile[] files) {
        int i = 0;
        while (i < files.length) {
            this.addFile(files[i]);
            ++i;
        }
    }

    public IStatus validateFiles() {
        if (!this.files_.isEmpty()) {
            IWorkspace workspace = null;
            int i = 0;
            while (i < this.files_.size()) {
                workspace = ((IFile)this.files_.get(i)).getWorkspace();
                if (workspace != null) break;
                ++i;
            }
            if (workspace != null) {
                IFile[] files = new IFile[this.files_.size()];
                this.files_.toArray(files);
                return workspace.validateEdit(files, this.context_);
            }
        }
        return Status.OK_STATUS;
    }

    public void addJavaFiles(IPropertyGroup propertyGroup) {
        ArrayList files = new ArrayList();
        J2CUIPropertyUtil.populateJavaClassPathList(propertyGroup, files);
        if (!files.isEmpty()) {
            int i = 0;
            while (i < files.size()) {
                String file = (String)files.get(i);
                int firstSeparator = file.indexOf(47);
                int secondSeparator = file.lastIndexOf(47);
                String strProject = file.substring(0, firstSeparator);
                String strPackage = file.substring(firstSeparator + 1, secondSeparator);
                String name = file.substring(secondSeparator + 1);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IJavaProject javaProject = JavaCore.create((IProject)root.getProject(strProject));
                if (javaProject != null) {
                    try {
                        IType type = javaProject.findType(strPackage, name);
                        if (type != null) {
                            this.addFile((IFile)type.getCompilationUnit().getCorrespondingResource());
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
    }
}

