/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public final class CreateProjectUtils {
    public static String getEARProjectName(String projectName) {
        IProject project_ = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Vector myEARs = new Vector();
        myEARs = CreateProjectUtils.hasEARSforJ2EEProj(project_);
        if (myEARs != null && myEARs.size() > 0) {
            IVirtualComponent childComponent = (IVirtualComponent)myEARs.get(0);
            String EARName = childComponent.getName();
            return EARName;
        }
        return projectName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSourceFolder(String projectName) {
        IProject project_ = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project_ == null) return projectName;
        IJavaProject jProj = JavaCore.create((IProject)project_);
        try {
            IPackageFragmentRoot[] pkfrag = jProj.getAllPackageFragmentRoots();
            if (pkfrag == null) return projectName;
            if (pkfrag.length <= 0) return projectName;
            int i = 0;
            while (true) {
                if (i >= pkfrag.length) {
                    return projectName;
                }
                IPackageFragmentRoot pkf = pkfrag[i];
                if (pkf != null && pkf.getKind() == 1) {
                    String sourceFolder = "";
                    int ii = 0;
                    if (pkf.getPath() == null) return "";
                    sourceFolder = pkf.getPath().toString();
                    ii = projectName.length();
                    return sourceFolder.substring(ii + 1, sourceFolder.length());
                }
                ++i;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return "";
        }
    }

    public static String getProjectAddToEAR(String projectName) {
        IProject project_ = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Vector myEARs = new Vector();
        myEARs = CreateProjectUtils.hasEARSforJ2EEProj(project_);
        if (myEARs != null) {
            if (myEARs.size() > 0) {
                return "yes";
            }
            return "no";
        }
        return "no";
    }

    public static Vector getEARModules() {
        Vector<IVirtualComponent> moduleEARs = new Vector<IVirtualComponent>();
        IProject[] projs = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear");
        int i = 0;
        while (i < projs.length) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)projs[i]);
            moduleEARs.add(comp);
            ++i;
        }
        return moduleEARs;
    }

    public static Vector hasEARSforJ2EEProj(IProject j2eeProj) {
        Vector res = new Vector();
        if (j2eeProj == null) {
            return res;
        }
        if (j2eeProj.getName() == null) {
            return res;
        }
        if (ResourceUtils.isEJBProject(j2eeProj) || ResourceUtils.isJCAProject(j2eeProj) || ResourceUtils.isDynamicWebProject(j2eeProj)) {
            Vector allEars = CreateProjectUtils.getEARModules();
            int u = 0;
            while (u < allEars.size()) {
                IVirtualReference ref = null;
                IVirtualReference[] refs = ((IVirtualComponent)allEars.get(u)).getReferences();
                int i = 0;
                while (i < refs.length) {
                    String rName;
                    IVirtualReference reference = refs[i];
                    if (reference.getReferencedComponent() != null && (rName = reference.getReferencedComponent().getName()) != null && rName.equals(j2eeProj.getName())) {
                        ref = reference;
                        break;
                    }
                    ++i;
                }
                if (ref != null) {
                    res.add(allEars.get(u));
                }
                ++u;
            }
        }
        return res;
    }
}

