/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.datastore;

import com.ibm.j2c.ui.core.CoreConstants;
import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.JavaClassNameProperty;
import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.Hashtable;
import org.eclipse.emf.common.util.URI;

public class GenerateDynamicProp {
    public static final String PropName = "name";
    public static final String PropValue = "value";
    public static final String DataType = "DataType";
    public static final String ProjType = "type";
    public static final String Default = "default";
    public static final String debug = "debug";
    public static final String debugtrue = "true";
    public static final String PROPERTYNODE = "property";
    public static final String ProjType_EJB = "EJB";
    public static final String ProjType_JAVA = "Java";
    public static final String ProjType_WEB = "Web";
    public static final String GENERATEPROJECT_NODE = "project";
    public static final String GENERATEADAPTER_CMD = "com.ibm.adapter.command";
    public static final String TARGET_NODE = "target";
    public static final String CREATEPROJECT_NODE = "createProject";
    protected static Hashtable propertyNameLists_ = null;

    public static void dump(String str) {
        CoreConstants.dump(str);
    }

    public static Hashtable generateTreePropertyGroup(Hashtable PropertyLists, String myGroupName, INodeProperty properties) {
        return PropertyLists;
    }

    public static Hashtable generatePropertyGroups(IPropertyGroup properties) {
        if (properties == null) {
            return null;
        }
        propertyNameLists_ = new Hashtable();
        String myGroupName = properties.getName();
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return null;
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                propertyNameLists_ = GenerateDynamicProp.generateBaseProperty(myGroupName, propertyNameLists_, (ISingleTypedProperty)ipd);
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                IPropertyGroup bpg = (IPropertyGroup)ipd;
                if (bpg.getProperties() != null && bpg.getProperties().length >= 1) {
                    propertyNameLists_ = GenerateDynamicProp.generatePropertyGroups(propertyNameLists_, myGroupName, bpg, true);
                }
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)ipd)) {
                GenerateDynamicProp.populateJavaClassPathList(myGroupName, propertyNameLists_, ((ITreeProperty)ipd).getRoot());
            }
            ++i;
        }
        return propertyNameLists_;
    }

    protected static void populateJavaClassPathList(String myGroupName, Hashtable propertyNameLists_, IPropertyGroup propertyGroup) {
        if (propertyGroup == null) {
            return;
        }
        JavaProjectProperty pj = null;
        JavaPackageProperty pkg = null;
        JavaClassNameProperty file = null;
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        if (properties == null) {
            return;
        }
        String myLongGroupName = String.valueOf(myGroupName) + "/" + propertyGroup.getName();
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor prop = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)prop)) {
                GenerateDynamicProp.populateJavaClassPathList(myLongGroupName, propertyNameLists_, (IPropertyGroup)prop);
            } else if (PropertyHelper.isTreeProperty((IPropertyDescriptor)prop)) {
                GenerateDynamicProp.populateJavaClassPathList(myLongGroupName, propertyNameLists_, ((ITreeProperty)prop).getRoot());
            } else if (!PropertyHelper.isCustomProperty((IPropertyDescriptor)prop)) {
                String myName = prop.getName();
                String mylongName = String.valueOf(myLongGroupName) + "/" + myName;
                String value = PropertyUtil.getValueAsString((IPropertyDescriptor)prop);
                propertyNameLists_.put(mylongName, value);
            } else {
                ICustomProperty cprop = (ICustomProperty)prop;
                String myName = prop.getName();
                String mylongName = String.valueOf(myLongGroupName) + "/" + myName;
                if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cprop)) {
                    pj = (JavaProjectProperty)prop;
                    if (pj != null) {
                        propertyNameLists_.put(mylongName, pj.getValueAsString());
                    }
                } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cprop)) {
                    pkg = (JavaPackageProperty)prop;
                    if (pkg != null) {
                        propertyNameLists_.put(mylongName, pkg.getValueAsString());
                    }
                } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cprop)) {
                    file = (JavaClassNameProperty)prop;
                    if (file != null) {
                        propertyNameLists_.put(mylongName, file.getValueAsString());
                    }
                } else {
                    String value = PropertyUtil.getValueAsString((IPropertyDescriptor)prop);
                    propertyNameLists_.put(mylongName, value);
                }
            }
            ++i;
        }
    }

    protected static void populateJavaClassPathList(String myGroupName, Hashtable propertyNameLists_, INodeProperty node) {
        if (node == null) {
            return;
        }
        String mylongGroupName = String.valueOf(myGroupName) + "/" + node.getName();
        IPropertyGroup pg = node.createConfigurationProperties();
        GenerateDynamicProp.populateJavaClassPathList(mylongGroupName, propertyNameLists_, pg);
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                GenerateDynamicProp.populateJavaClassPathList(myGroupName, propertyNameLists_, children[i]);
                ++i;
            }
        }
    }

    public static Hashtable generatePropertyGroups(Hashtable PropertyLists, String ancestorName, IPropertyGroup properties, boolean isChildren) {
        if (properties == null) {
            return propertyNameLists_;
        }
        String myGpName = properties.getName();
        String mylongName = String.valueOf(ancestorName) + "/" + myGpName;
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return propertyNameLists_;
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                PropertyLists = GenerateDynamicProp.generateBaseProperty(mylongName, PropertyLists, (ISingleTypedProperty)ipd);
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                IPropertyGroup bpg = (IPropertyGroup)ipd;
                PropertyLists = GenerateDynamicProp.generatePropertyGroups(PropertyLists, mylongName, bpg, isChildren);
            }
            ++i;
        }
        return PropertyLists;
    }

    public static void testCustomProperty(ICustomProperty cProperty) {
        if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cProperty)) {
            GenerateDynamicProp.dump("isJavaProjectProperty ");
        } else if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cProperty)) {
            GenerateDynamicProp.dump("isJavaPackageNameProperty ");
        } else if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cProperty)) {
            GenerateDynamicProp.dump("isJavaClassNameProperty ");
        } else if (!CustomPropertyHelper.isSingleFileProperty((ICustomProperty)cProperty)) {
            if (CustomPropertyHelper.isMultiFolderProperty((ICustomProperty)cProperty)) {
                GenerateDynamicProp.dump("isMultiFolderProperty ");
            } else if (CustomPropertyHelper.isMultiFileProperty((ICustomProperty)cProperty)) {
                GenerateDynamicProp.dump("isMultiFileProperty ");
            } else if (CustomPropertyHelper.isSingleFolderProperty((ICustomProperty)cProperty)) {
                GenerateDynamicProp.dump("isSingleFolderProperty ");
            }
        }
    }

    public static Hashtable generateBaseProperty(String ancestorName, Hashtable PropertyLists, ISingleTypedProperty property) {
        block12: {
            Object[] Listvalues;
            String myLongPropName;
            block9: {
                block10: {
                    block11: {
                        String value;
                        String myPropName = property.getName();
                        myLongPropName = String.valueOf(ancestorName) + "/" + myPropName;
                        if (PropertyUtil.isSensitive((IPropertyDescriptor)property)) {
                            return PropertyLists;
                        }
                        if (!PropertyUtil.isEnabled((IPropertyDescriptor)property)) {
                            return PropertyLists;
                        }
                        if (!PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) break block9;
                        if (((ISingleValuedProperty)property).getValue() == null) break block10;
                        if (!PropertyHelper.isCustomProperty((IPropertyDescriptor)property)) break block11;
                        ICustomProperty cProperty = (ICustomProperty)property;
                        if (CoreConstants.isDebug_) {
                            GenerateDynamicProp.testCustomProperty(cProperty);
                        }
                        if ((value = PropertyUtil.getValueAsString((IPropertyDescriptor)property)) != null) {
                            PropertyLists.put(myLongPropName, value);
                        }
                        break block12;
                    }
                    String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                    if (value == null) break block12;
                    PropertyLists.put(myLongPropName, value);
                    break block12;
                }
                String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                if (value != null) break block12;
                PropertyLists.put(myLongPropName, "null");
                break block12;
            }
            if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property) && (Listvalues = ((IMultiValuedProperty)property).getValues()) != null) {
                int i = 0;
                while (i < Listvalues.length) {
                    if (Listvalues[i] != null) {
                        if (Listvalues[i] instanceof URI) {
                            URI filepath = (URI)Listvalues[i];
                            PropertyLists.put(myLongPropName, filepath.toFileString());
                        } else {
                            PropertyLists.put(myLongPropName, Listvalues[i].toString());
                        }
                    }
                    ++i;
                }
            }
        }
        return PropertyLists;
    }
}

