/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.wizard.password;

import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PasswordWizardPage
extends WizardPage
implements Listener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private boolean passwordModified = false;
    private static final int margin = 5;
    private static final int rightPercentage = 65;
    private Text passwordField;
    private String pageTitle;

    public PasswordWizardPage(String pageName, String title, IStructuredSelection selection) {
        super(pageName);
        this.pageTitle = title;
        this.selection = selection;
        this.setImageDescriptor(Utility.getImageDescriptor((String)WorkbenchPlugin.icons.getString("field_edit_wizard_large")));
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            Font font = parent.getFont();
            FormLayout layout = new FormLayout();
            layout.marginHeight = 3;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(font);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            int requiredLabelWidth = Utility.getTextWidth((Composite)parent, (int)0, (String)"*");
            int labelWidth = Utility.getTextWidth((Composite)parent, (int)0, (String)WorkbenchPlugin.labels.getString("WB118")) + requiredLabelWidth;
            FormData fd = uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 0), null);
            Label pwdReq = uih.genRequiredSymbol(composite, 0, fd, parent.getDisplay().getSystemColor(3));
            pwdReq.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment((Control)pwdReq, 5), null);
            Label passwordLabel = new Label(composite, 0);
            passwordLabel.setText(WorkbenchPlugin.labels.getString("WB118"));
            passwordLabel.setLayoutData((Object)fd);
            passwordLabel.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.passwordField = new Text(composite, 0x400800);
            this.passwordField.setLayoutData((Object)fd);
            this.passwordField.setFont(font);
            this.setTitle(WorkbenchPlugin.labels.getString(this.pageTitle));
            this.setDescription(WorkbenchPlugin.descriptions.getString("WB123"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench" + String.valueOf(WorkbenchPlugin.getDefault()));
            this.setControl((Control)composite);
            this.initialize();
        }
        catch (CoreException coreException) {
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        this.passwordField.addListener(24, (Listener)this);
        this.passwordField.setEnabled(true);
        this.passwordField.setToolTipText(WorkbenchPlugin.descriptions.getString("WB474"));
        this.passwordField.setFocus();
        this.passwordField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.character >= 'a' && event.character <= 'z') {
                    event.text = event.text.toUpperCase();
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void handleEvent(Event event) {
        try {
            if (event.widget == this.passwordField) {
                if (this.passwordModified && this.passwordField.getText().isEmpty()) {
                    String errorMessage = WorkbenchPlugin.errors.getString("IOCWB0405");
                    this.setErrorMessage(errorMessage);
                } else if (this.passwordModified) {
                    this.setErrorMessage(null);
                } else {
                    this.passwordModified = true;
                }
            }
            this.setPageComplete(this.getErrorMessage() == null && !this.passwordField.getText().isEmpty());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
        }
    }

    protected String getPassword() {
        return this.passwordField.getText();
    }
}

