/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.wizard.password;

import com.ibm.im.ims.catalog.ui.wizard.password.PasswordWizardPage;
import com.ibm.im.ims.workbench.WorkbenchPlugin;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PasswordWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private PasswordWizardPage passwordPage;
    private String password = "";
    private String pageTitle;

    public PasswordWizard(String title) {
        this.pageTitle = title;
        this.setWindowTitle(WorkbenchPlugin.labels.getString("WB121"));
    }

    public boolean canFinish() {
        try {
            return this.passwordPage.isPageComplete();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        try {
            this.passwordPage = new PasswordWizardPage(" ", this.pageTitle, this.selection);
            this.addPage((IWizardPage)this.passwordPage);
            this.passwordPage.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean performFinish() {
        this.password = this.passwordPage.getPassword();
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            PasswordWizard.this.doFinish(monitor);
                        }
                        catch (Throwable e) {
                            logger.throwing(this.getClass().getName(), "performFinish()", e);
                            logger.error(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, op);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
            return false;
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException, IOException, ModelException, JAXBException {
        monitor.worked(1);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

