/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.search;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchContentProvider;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchLabelProvider;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.model.DbdModel;
import com.ibm.im.ims.workbench.model.PcbDBModel;
import com.ibm.im.ims.workbench.model.PcbGsamModel;
import com.ibm.im.ims.workbench.model.PsbModel;
import com.ibm.im.ims.workbench.model.utilities.ModelException;
import com.ibm.ims.dli.DLIException;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.swt.XSwt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class CatalogSearchView
extends ViewPart
implements IDoubleClickListener,
ISelectionChangedListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TreeViewer treeViewer;
    private Text text;
    private CatalogTreeParent invisibleRoot = new CatalogTreeParent("", "NONE");
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static ISelection selection = null;
    public static final String TS_VERSION_SEPARATOR = " - ";
    private String currIMSConnName;
    private Throwable exceptionDuringSearch = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.text = new Text(parent, 2060);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new CatalogSearchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CatalogSearchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.hookContextMenu();
        this.hookListeners();
        this.treeViewer.setInput((Object)this.invisibleRoot);
        this.text.setText("");
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(CatNavMessages.getLabel().getString("CNSD"));
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void hookListeners() {
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deleteTree(String imsConnName) {
        if (this.currIMSConnName != null && this.currIMSConnName.equals(imsConnName)) {
            CatalogTreeObject treeRootObj = (CatalogTreeObject)this.treeViewer.getInput();
            this.clearTree(treeRootObj);
            this.treeViewer.refresh();
        }
    }

    private void clearTree(CatalogTreeObject parent) {
        if (parent instanceof CatalogTreeParent) {
            CatalogTreeObject[] children = ((CatalogTreeParent)parent).getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof CatalogTreeParent) {
                    this.clearTree(children[i]);
                }
                ((CatalogTreeParent)parent).removeChild(children[i]);
                ++i;
            }
        }
    }

    public void findReferencingPsbs(CatalogTreeParent dbdNode) throws Exception {
        this.buildDbdWithPsbs(dbdNode);
        this.treeViewer.setInput((Object)this.invisibleRoot);
        this.setText(this.invisibleRoot.getChildren()[0], dbdNode.getName());
        this.treeViewer.refresh();
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.expandToLevel(2);
    }

    public void processException() {
        if (this.exceptionDuringSearch != null) {
            logger.error(this.exceptionDuringSearch);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)CatNavMessages.getError().getString("CATNAV_ERROR"), (String)this.exceptionDuringSearch.getMessage());
        }
    }

    public void buildVersionTree(CatalogTreeParent treeItem) throws Exception {
        IImsDbConnection conn;
        String objectName = treeItem.getName();
        String objectType = treeItem.getType();
        CatalogTreeParent topFolder = null;
        List allTSVersions = null;
        String activeTS = null;
        String currentVersion = " [" + CatNavMessages.getLabel().getString("CNSD_CURRENTACTIVE") + "]";
        CatalogTreeConnection connNode = treeItem.getTreeConnectionNode();
        CatalogNav catNav = CatalogNav.getSingletonInstance();
        StringBuffer sb = null;
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuffer("Instances of ");
        }
        if (objectType.equals("PSB")) {
            if (logger.isLoggable(Level.FINEST)) {
                sb.append("PSB " + objectName + ":\n");
            }
            topFolder = new CatalogTreeParent("PSB", "PSB FOLDER", connNode);
            allTSVersions = catNav.getPsbAllTSVersions(connNode, treeItem.getName());
            byte[] xml = catNav.getActivePsbXml(connNode, treeItem.getName());
            if (xml != null) {
                PsbModel psbModel = new PsbModel((InputStream)new ByteArrayInputStream(xml));
                activeTS = psbModel.getTimestamp();
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                sb.append("DBD " + objectName + ":\n");
            }
            topFolder = new CatalogTreeParent("DBD", "DBD FOLDER", connNode);
            conn = connNode.getConnection();
            allTSVersions = conn.getDbdAllTSVersions(treeItem.getName());
            byte[] xml = catNav.getActiveDbdXml(connNode, treeItem.getName());
            if (xml != null) {
                DbdModel dbdModel = new DbdModel((InputStream)new ByteArrayInputStream(xml));
                activeTS = dbdModel.getTimestamp();
            }
        }
        if (activeTS == null) {
            conn = connNode.getConnection();
            activeTS = conn.getActiveTimestampFromHeader(treeItem.getName());
        }
        long latestInstanceTS = 0L;
        CatalogTreeObject latestNode = null;
        for (String currTS : allTSVersions) {
            CatalogTreeParent currInstance = null;
            Object readableTs = this.convertTimeStamp(currTS);
            if (activeTS != null && currTS.equals(activeTS)) {
                readableTs = (String)readableTs + currentVersion;
                currInstance = new CatalogTreeParent(objectName + TS_VERSION_SEPARATOR + (String)readableTs, objectType, connNode);
                currInstance.setCurrActive(true);
                currInstance.setInstanceTimestamp(currTS);
            } else {
                currInstance = new CatalogTreeParent(objectName + TS_VERSION_SEPARATOR + (String)readableTs, objectType, connNode);
                currInstance.setCurrActive(false);
                currInstance.setInstanceTimestamp(currTS);
            }
            if (logger.isLoggable(Level.FINEST)) {
                sb.append("TS: " + currTS + TS_VERSION_SEPARATOR + (String)readableTs + "\n");
            }
            if (activeTS != null) {
                currInstance.setCurrentActiveExistsForResource(true);
            }
            currInstance.setAllInstancesSearchSubject(treeItem);
            topFolder.addChild(currInstance);
            long currTSLong = Long.parseLong(currTS);
            if (currTSLong <= latestInstanceTS) continue;
            latestInstanceTS = currTSLong;
            latestNode = currInstance;
        }
        if (latestNode != null) {
            latestNode.setLatestInstance(true);
            if (logger.isLoggable(Level.FINEST)) {
                sb.append("Latest instance: " + latestNode.getInstanceTimestamp());
                logger.finest(sb.toString());
            }
        }
        this.invisibleRoot = new CatalogTreeParent("", "NONE");
        this.invisibleRoot.addChild(topFolder);
        this.treeViewer.setInput((Object)this.invisibleRoot);
        this.text.setText(this.getText(treeItem, allTSVersions.size()));
        this.treeViewer.refresh();
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.expandToLevel(2);
    }

    private String convertTimeStamp(String ts) {
        String retVal = "";
        try {
            if (ts.equals("9936500000000")) {
                retVal = CatNavMessages.getLabel().getString("UNKNOWN_TIMESTAMP");
            } else {
                Date date = new SimpleDateFormat("yyDDDHHmmssSS").parse(ts);
                retVal = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault()).format(date);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return retVal;
    }

    public void setText(Object element, String objName) {
        Object retVal = "";
        if (element instanceof CatalogTreeParent) {
            CatalogTreeParent treeObject = (CatalogTreeParent)element;
            String objType = treeObject.getType();
            String childrenNum = "  -  " + String.valueOf(treeObject.getChildren().length);
            if (objType != null) {
                if (objType.equals("PSB FOLDER")) {
                    Object[] inserts = new Object[]{objName.trim(), childrenNum};
                    retVal = (String)retVal + CatNavMessages.getDescription().getString("CSV_PSBS_FOUND", inserts);
                } else if (objType.equals("DBD FOLDER")) {
                    Object[] inserts = new Object[]{objName.trim(), childrenNum};
                    retVal = (String)retVal + CatNavMessages.getDescription().getString("CSV_DBDS_FOUND", inserts);
                }
            }
        }
        this.text.setText((String)retVal);
    }

    private String getText(Object element, int numberOfChildren) {
        String retVal = null;
        if (element instanceof CatalogTreeParent) {
            CatalogTreeParent treeObject = (CatalogTreeParent)element;
            String objType = treeObject.getType();
            String objName = treeObject.getName();
            if (objType != null) {
                Object[] inserts = new Object[]{objType, objName.trim(), numberOfChildren};
                retVal = CatNavMessages.getDescription().getString("CSV_INSTANCES", inserts);
            }
        }
        return retVal;
    }

    public CatalogTreeParent buildPsbWithDbds(CatalogTreeParent psbNode) throws Exception {
        CatalogTreeParent retVal = new CatalogTreeParent("", "NONE");
        CatalogTreeConnection connNode = psbNode.getTreeConnectionNode();
        this.currIMSConnName = connNode.getName();
        String psbName = psbNode.getName();
        try {
            List gsamPcbList;
            IImsDbConnection conn = connNode.getConnection();
            byte[] xml = conn.getPsbXml(psbName);
            PsbModel psbModel = new PsbModel((InputStream)new ByteArrayInputStream(xml));
            HashSet<String> dbdNames = new HashSet<String>();
            List pcbList = psbModel.getDBPcbList();
            if (pcbList != null) {
                int j = 0;
                while (j < pcbList.size()) {
                    PcbDBModel currPcb = (PcbDBModel)pcbList.get(j);
                    dbdNames.add(currPcb.getDbdName());
                    ++j;
                }
            }
            if ((gsamPcbList = psbModel.getGsamPcbList()) != null) {
                int j = 0;
                while (j < gsamPcbList.size()) {
                    PcbGsamModel currPcb = (PcbGsamModel)gsamPcbList.get(j);
                    dbdNames.add(currPcb.getDbdName());
                    ++j;
                }
            }
            CatalogTreeParent dbdFolder = new CatalogTreeParent("DBD", "DBD FOLDER", connNode);
            Iterator it = dbdNames.iterator();
            while (it.hasNext()) {
                CatalogTreeParent dbdNode = new CatalogTreeParent((String)it.next(), "DBD", connNode);
                dbdFolder.addChild(dbdNode);
            }
            retVal.addChild(dbdFolder);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            this.setSearchException(cause);
        }
        return retVal;
    }

    public CatalogTreeParent buildDbdWithPsbs(CatalogTreeParent dbdNode) throws Exception {
        CatalogTreeParent retVal = new CatalogTreeParent("", "NONE");
        CatalogTreeConnection treeConnectionNode = dbdNode.getTreeConnectionNode();
        try {
            this.currIMSConnName = treeConnectionNode.getName();
            String dbdName = dbdNode.getName();
            String activeTS = null;
            String psbName = null;
            CatalogTreeParent psbFolder = new CatalogTreeParent("PSB", "PSB FOLDER", treeConnectionNode);
            HashSet<String> psbNames = new HashSet<String>();
            IImsDbConnection conn = treeConnectionNode.getConnection();
            Vector psbList = conn.getReferencingPsbs(dbdName);
            if (psbList != null) {
                for (String[] psb : psbList) {
                    if (psbName == null || !psbName.equals(psb[0])) {
                        psbName = psb[0];
                        activeTS = conn.getActiveTimestampFromHeader(psbName);
                    }
                    if (activeTS == null || !psb[1].equals(activeTS) && !psb[1].isEmpty()) continue;
                    psbNames.add(psbName);
                }
            }
            Iterator it = psbNames.iterator();
            while (it.hasNext()) {
                CatalogTreeParent psbNode = new CatalogTreeParent((String)it.next(), "PSB", treeConnectionNode);
                psbFolder.addChild(psbNode);
            }
            retVal.addChild(psbFolder);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            this.setSearchException(cause);
        }
        return retVal;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.text.dispose();
        this.treeViewer.removeDoubleClickListener((IDoubleClickListener)this);
    }

    public void doubleClick(DoubleClickEvent event) {
        try {
            ISelection selection = event.getSelection();
            Object obj = null;
            ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof CatalogTreeObject) {
                if (((CatalogTreeObject)obj).getType() == "DBD") {
                    Utility.openDBDEditor(obj);
                } else if (((CatalogTreeObject)obj).getType() == "PSB") {
                    Utility.openPSBEditor(obj);
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            logger.error((Throwable)e);
            MessageDialog.openError((Shell)XSwt.getActiveShell(), (String)CatNavMessages.getError().getString("CATNAV_ERROR"), (String)cause.getMessage());
        }
    }

    public void buildSearchResult(CatalogTreeConnection connNode, List<String> dbdNames, List<String> psbNames, String searchPattern) throws DLIException, SQLException, ModelException {
        CatalogTreeParent dbdNode;
        this.text.setText("");
        this.currIMSConnName = connNode.getName();
        this.invisibleRoot = new CatalogTreeParent("", "NONE");
        if (dbdNames != null && !dbdNames.isEmpty()) {
            CatalogTreeParent dbdFolder = new CatalogTreeParent("DBD", "DBD FOLDER", connNode);
            for (String dbd : dbdNames) {
                dbdNode = new CatalogTreeParent(dbd, "DBD", connNode);
                dbdFolder.addChild(dbdNode);
            }
            this.invisibleRoot.addChild(dbdFolder);
        }
        if (psbNames != null && !psbNames.isEmpty()) {
            CatalogTreeParent psbFolder = new CatalogTreeParent("PSB", "DBD FOLDER", connNode);
            for (String psb : psbNames) {
                dbdNode = new CatalogTreeParent(psb, "PSB", connNode);
                psbFolder.addChild(dbdNode);
            }
            this.invisibleRoot.addChild(psbFolder);
        }
        this.treeViewer.setInput((Object)this.invisibleRoot);
        this.setInfoMessage(dbdNames, psbNames, searchPattern);
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel(2);
    }

    private void setInfoMessage(List<String> dbdNames, List<String> psbNames, String searchPattern) {
        if (dbdNames != null && !dbdNames.isEmpty() && (psbNames == null || psbNames.isEmpty())) {
            Object[] inserts = new Object[]{dbdNames.size()};
            this.text.setText(CatNavMessages.getDescription().getString("CSV_FOUND_DBDS", inserts));
        } else if (psbNames != null && !psbNames.isEmpty() && (dbdNames == null || dbdNames.isEmpty())) {
            Object[] inserts = new Object[]{psbNames.size()};
            this.text.setText(CatNavMessages.getDescription().getString("CSV_FOUND_PSBS", inserts));
        } else if (dbdNames != null && !dbdNames.isEmpty() && psbNames != null && !psbNames.isEmpty()) {
            Object[] inserts = new Object[]{dbdNames.size(), psbNames.size()};
            this.text.setText(CatNavMessages.getDescription().getString("CSV_FOUND_DBDPSBS", inserts));
        } else {
            this.text.setText(CatNavMessages.getDescription().getString("CSV_FOUND_NONE", (Object[])new String[]{searchPattern}));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        selection = event.getSelection();
    }

    public void setSearchException(Throwable e) {
        this.exceptionDuringSearch = e;
    }

    public void clearSearchException() {
        this.exceptionDuringSearch = null;
    }

    public Throwable getSearchException() {
        return this.exceptionDuringSearch;
    }
}

