/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.search;

import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogViewLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CatalogSearchLabelProvider
extends StyledCellLabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private StyledString text;

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        this.text = new StyledString();
        if (element instanceof CatalogTreeParent) {
            CatalogTreeParent treeObject = (CatalogTreeParent)element;
            String objName = treeObject.getName();
            this.text.append(objName);
        }
        cell.setImage(this.getImage(element));
        cell.setText(this.text.toString());
        cell.setStyleRanges(this.text.getStyleRanges());
        super.update(cell);
    }

    private Image getImage(Object obj) {
        CatalogTreeObject node = null;
        if (!(obj instanceof CatalogTreeObject)) {
            return null;
        }
        node = (CatalogTreeObject)obj;
        if (node.getType() == "IMS CATALOG CONNECTION") {
            return CatalogViewLabelProvider.CatalogConnectionOpen_image;
        }
        if (node.getType() == "DBD FOLDER") {
            return CatalogViewLabelProvider.DBDFolderOpen_image;
        }
        if (node.getType() == "DBD") {
            return CatalogViewLabelProvider.Dbd_image;
        }
        if (node.getType() == "SEGMENT") {
            return CatalogViewLabelProvider.Table_image;
        }
        if (node.getType() == "PSB FOLDER") {
            return CatalogViewLabelProvider.PSBFolderOpen_image;
        }
        if (node.getType() == "PCB TP" || node.getType() == "PCB DB" || node.getType() == "PCB GSAM") {
            return CatalogViewLabelProvider.Schema_image;
        }
        if (node.getType() == "PSB") {
            return CatalogViewLabelProvider.Psb_image;
        }
        if (node.getType() == "SENSEG") {
            return CatalogViewLabelProvider.Sensegs_image;
        }
        if (node.getType() == "PCB TP FOLDER" || node.getType() == "PCB DB FOLDER" || node.getType() == "PCB GSAM FOLDER" || node.getType() == "ALL CONNECTIONS" || node.getType() == "FAVORITES") {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (node.getType() == "FIELD") {
            return CatalogViewLabelProvider.Column_image;
        }
        return null;
    }
}

