/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav.actions;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SearchReferencingDBDs
extends AbstractHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private CatalogSearchView view;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Throwable excDuringSearch;
        IWorkbenchPart part = null;
        CatalogTreeParent treeObject = null;
        try {
            String objectType;
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof CatalogTreeParent && (objectType = (treeObject = (CatalogTreeParent)firstElement).getType()).equals("PSB")) {
                part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof CatalogSearchView) {
                    this.view = (CatalogSearchView)part;
                    SearchRunnable popOp = new SearchRunnable(treeObject);
                    this.view.clearSearchException();
                    new ProgressMonitorDialog(this.view.getSite().getShell()).run(true, false, (IRunnableWithProgress)popOp);
                    this.refresh(popOp.getNewRoot(), treeObject.getName());
                } else if (part instanceof CatalogNav) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    this.view = (CatalogSearchView)page.showView("com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView");
                    SearchRunnable popOp = new SearchRunnable(treeObject);
                    this.view.clearSearchException();
                    new ProgressMonitorDialog(this.view.getSite().getShell()).run(true, false, (IRunnableWithProgress)popOp);
                    this.refresh(popOp.getNewRoot(), treeObject.getName());
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        if ((excDuringSearch = this.view.getSearchException()) != null) {
            this.view.processException();
        }
        return null;
    }

    private void refresh(CatalogTreeParent parent, String name) {
        CatalogTreeObject[] children = parent.getChildren();
        if (children != null && children.length > 0) {
            this.view.setText(children[0], name);
            TreeViewer treeViewer = this.view.getViewer();
            treeViewer.setInput((Object)parent);
            treeViewer.refresh();
            treeViewer.getTree().setRedraw(true);
            treeViewer.expandToLevel(2);
        }
    }

    class SearchRunnable
    implements IRunnableWithProgress {
        private CatalogTreeParent catalogTreeParent;

        public SearchRunnable(CatalogTreeParent catalogTreeParent) {
            this.catalogTreeParent = catalogTreeParent;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                try {
                    monitor.beginTask(CatNavMessages.getLabel().getString("CNS_SEARCH_PROGRESS_INDICATOR", (Object[])new String[]{this.catalogTreeParent.getName()}), -1);
                    this.catalogTreeParent = SearchReferencingDBDs.this.view.buildPsbWithDbds(this.catalogTreeParent);
                }
                catch (Throwable t) {
                    logger.error(t);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public CatalogTreeParent getNewRoot() {
            return this.catalogTreeParent;
        }
    }
}

