/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav.actions;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogViewContentProvider;
import com.ibm.im.ims.catalog.ui.view.nav.actions.CatalogSearchDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchSearchDialogFromCatalog
extends AbstractHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            List<CatalogTreeParent> selTreeObjs = Utility.getSelectedNodes(event);
            List<CatalogTreeConnection> conns = CatalogNav.getImplicatedConns(selTreeObjs);
            CatalogTreeConnection connNode = null;
            if (conns.size() == 1) {
                connNode = conns.get(0);
            } else {
                CatalogNav catNav = CatalogNav.getSingletonInstance();
                if (catNav.getConnectionProfiles().size() > 0) {
                    TreeViewer viewer = catNav.getViewer();
                    viewer.refresh(true);
                    CatalogViewContentProvider contentProvider = (CatalogViewContentProvider)viewer.getContentProvider();
                    CatalogTreeParent parent = (CatalogTreeParent)contentProvider.getInvisibleRoot().getChildren()[0];
                    viewer.setExpandedState((Object)parent, true);
                    if (parent.hasChildren()) {
                        connNode = (CatalogTreeConnection)parent.getChildren()[0];
                        viewer.setSelection((ISelection)new StructuredSelection((Object)connNode), true);
                    }
                }
            }
            if (connNode != null) {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CatalogSearchDialog catSearchDialog = new CatalogSearchDialog(activeShell, CatNavMessages.getLabel().getString("CNSD_TITLE"), selTreeObjs);
                catSearchDialog.open();
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return null;
    }
}

