/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav.actions;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.workbench.wizard.importsrc.ImportSourceWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchImportFromCatalog
extends AbstractHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            LaunchImportFromCatalog.launchImport(event, false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "execute()", e);
            logger.error(e);
        }
        return null;
    }

    public static void launchImport(ExecutionEvent event, boolean createNewProject) throws Exception {
        List<CatalogTreeParent> nodes = Utility.getSelectedNodes(event);
        if (nodes != null && !nodes.isEmpty()) {
            String imsConnName = null;
            Iterator<CatalogTreeParent> iter = nodes.iterator();
            Vector<String> selectedDbds = new Vector<String>();
            Vector<String> selectedPsbs = new Vector<String>();
            boolean instanceCannotBeImported = false;
            boolean specificInstanceSelected = false;
            String instanceTimestamp = null;
            while (iter.hasNext()) {
                CatalogTreeObject currNode = iter.next();
                CatalogTreeConnection treeConn = currNode.getTreeConnectionNode();
                imsConnName = treeConn.getName();
                String name = currNode.getName();
                if (name.contains(" - ")) {
                    if (nodes.size() > 1) {
                        instanceCannotBeImported = true;
                        break;
                    }
                    specificInstanceSelected = true;
                    instanceTimestamp = currNode.getInstanceTimestamp();
                    name = currNode.getAllInstancesSearchSubject().getName();
                }
                if (currNode.getType().equals("DBD")) {
                    selectedDbds.add(name);
                    continue;
                }
                selectedPsbs.add(name);
            }
            if (instanceCannotBeImported) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Information", (String)CatNavMessages.getError().getString("CSRV_IMPORT_MULT_VERSION_UNSUPPORTED"));
            } else {
                ImportSourceWizard wiz = new ImportSourceWizard(selectedPsbs, selectedDbds, imsConnName, createNewProject);
                if (specificInstanceSelected) {
                    wiz.setSpecificInstanceTSVers(instanceTimestamp);
                }
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wiz);
                dialog.open();
            }
        }
    }
}

