/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav.actions;

import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;

public class CatalogViewPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final String SENSEG = "isSenseg";
    private static final String PSB = "isPSBObject";
    private static final String DBD = "isDBDObject";
    private static final String DB_PCB = "isDBPCBObject";
    private static final String DBD_FOLDER = "isDBDFolderObject";
    private static final String PSB_FOLDER = "isPSBFolderObject";
    private static final String CONNECTION = "isConnectionObject";
    private static final String CONNS_FOLDER = "isConnectionFolderObject";
    private static final String IS_SAME_DBD_PSB = "isSameDBDorPSB";
    private static final String NOT_VERSION = "notVersionObject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", new Object[0]);
        }
        boolean retVal = false;
        try {
            ISelection selection;
            List<CatalogTreeParent> selObjects;
            if (PSB.equals(property) || DBD.equals(property) || DB_PCB.equals(property) || DBD_FOLDER.equals(property) || PSB_FOLDER.equals(property) || SENSEG.equals(property) || NOT_VERSION.equals(property)) {
                if (receiver instanceof CatalogTreeParent) {
                    CatalogTreeParent treeObject = (CatalogTreeParent)receiver;
                    if (NOT_VERSION.equals(property)) {
                        retVal = treeObject.getName().indexOf("-") < 0;
                    } else {
                        String objectType = treeObject.getType();
                        if (PSB.equals(property) && objectType.equals("PSB")) {
                            retVal = true;
                        } else if (DBD.equals(property) && objectType.equals("DBD")) {
                            retVal = true;
                        } else if (DB_PCB.equals(property) && objectType.equals("PCB DB")) {
                            retVal = true;
                        } else if (DBD_FOLDER.equals(property) && objectType.equals("DBD FOLDER")) {
                            retVal = true;
                        } else if (PSB_FOLDER.equals(property) && objectType.equals("PSB FOLDER")) {
                            retVal = true;
                        } else if (SENSEG.equals(property) && objectType.equals("SENSEG")) {
                            retVal = true;
                        }
                    }
                }
            } else if (CONNECTION.equals(property)) {
                CatalogTreeParent treeObject;
                if (receiver instanceof CatalogTreeParent && (treeObject = (CatalogTreeParent)receiver).getType().equals("IMS CATALOG CONNECTION")) {
                    retVal = true;
                }
            } else if (CONNS_FOLDER.equals(property)) {
                CatalogTreeParent treeObject;
                if (receiver instanceof CatalogTreeParent && (treeObject = (CatalogTreeParent)receiver).getType().equals("ALL CONNECTIONS")) {
                    retVal = true;
                }
            } else if (IS_SAME_DBD_PSB.equals(property) && (selObjects = Utility.getSelectedNodes(selection = CatalogSearchView.selection)) != null && selObjects.size() == 1) {
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "test(Object receiver, String property, Object[] args, Object expectedValue)", new Object[]{"For Object: " + String.valueOf(receiver) + " For property: " + property + " returning: " + retVal});
        }
        return retVal;
    }
}

