/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav.actions;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogViewContentProvider;
import com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.im.ims.workbench.project.wizard.UIHelper;
import com.ibm.im.ims.workbench.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CatalogSearchDialog
extends Dialog
implements ModifyListener,
SelectionListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final String STORE_CATALOG_SEARCH_DIALOG = "STORE_CATALOG_SEARCH_DIALOG";
    private static final String STORE_LAST_CONNECTION_NAME = "STORE_LAST_CONNECTION_NAME";
    private static final String STORE_LAST_SEARCH_PATTERN = "STORE_LAST_SEARCH_PATTERN";
    private static final String STORE_DBD_SEARCH_OPTION = "STORE_DBD_SEARCH_OPTION";
    private static final String STORE_PSB_SEARCH_OPTION = "STORE_PSB_SEARCH_OPTION";
    private String searchDialogTitle;
    private static final int margin = 10;
    private UIHelper uih;
    private Text searchText;
    private Combo connectionCombo;
    private Button dbdCheckbox;
    private Button psbCheckbox;
    private boolean dbdSearch;
    private boolean psbSearch;
    private List<CatalogTreeConnection> conns = new ArrayList<CatalogTreeConnection>();
    private String connName;
    private String searchPattern;
    private String connectionName;

    public CatalogSearchDialog(Shell parentShell, String searchDialogTitle, List<CatalogTreeParent> selTreeObjs) throws Exception {
        super(parentShell);
        this.searchDialogTitle = searchDialogTitle;
        this.init(selTreeObjs);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.uih = new UIHelper();
    }

    private void init(List<CatalogTreeParent> selTreeObjs) throws Exception {
        CatalogTreeParent parent;
        this.dbdSearch = false;
        this.psbSearch = false;
        this.connectionName = "";
        for (CatalogTreeParent obj : selTreeObjs) {
            if (obj.getType().equals("ALL CONNECTIONS")) {
                CatalogTreeObject[] children = obj.getChildren();
                int i = 0;
                while (i < children.length) {
                    CatalogTreeConnection currChild = (CatalogTreeConnection)children[i];
                    IImsDbConnection currConn = currChild.getConnection();
                    if (currConn != null) {
                        this.conns.add(currChild);
                    }
                    ++i;
                }
                continue;
            }
            if (obj.getType().equals("IMS CATALOG CONNECTION")) {
                CatalogTreeConnection conn = (CatalogTreeConnection)obj;
                if (this.conns.contains(conn)) continue;
                this.conns.add(conn);
                continue;
            }
            CatalogTreeParent theParent = obj.getParent();
            while (!(theParent instanceof CatalogTreeConnection)) {
                theParent = theParent.getParent();
            }
            CatalogTreeConnection conn = (CatalogTreeConnection)theParent;
            if (this.conns.contains(conn)) continue;
            this.conns.add(conn);
        }
        if (this.conns.isEmpty()) {
            CatalogNav catNav = CatalogNav.getSingletonInstance();
            CatalogViewContentProvider contentProv = (CatalogViewContentProvider)catNav.getViewer().getContentProvider();
            this.conns = contentProv.getAllConnections();
        }
        if (selTreeObjs.size() == 1 && (parent = selTreeObjs.get(0)).getType().equals("IMS CATALOG CONNECTION")) {
            this.connectionName = parent.getName();
            CatalogTreeConnection conn = (CatalogTreeConnection)parent;
            if (!this.conns.contains(conn)) {
                this.conns.add(conn);
            }
        }
        if (this.connectionName.isEmpty() && this.conns.size() == 1) {
            this.connectionName = this.conns.get(0).getName();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.searchDialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, CatNavMessages.getLabel().getString("CNSD_SEARCH"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = (Composite)super.createDialogArea(dialogParent);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.widthHint = 500;
        gd.heightHint = 250;
        parent.setLayoutData((Object)gd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        parent.setLayout((Layout)formLayout);
        Display display = parent.getDisplay();
        this.uih.setDisplay(display);
        this.restoreWidgetValues();
        FormData fd_connection = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
        Label connectionLabel = new Label(parent, 64);
        connectionLabel.setText(CatNavMessages.getLabel().getString("CICW_PAGE_CONNECTION_NAME") + CatNavMessages.getColon().getString("COLON"));
        connectionLabel.setToolTipText(CatNavMessages.getLabel().getString("CICW_PAGE_CONNECTION_NAME"));
        connectionLabel.setLayoutData((Object)fd_connection);
        FormData fd_connectionCombo = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment((Control)connectionLabel, 10), new FormAttachment(100, 0));
        this.connectionCombo = new Combo(parent, 2056);
        this.connectionCombo.setLayoutData((Object)fd_connectionCombo);
        this.connectionCombo.setText(CatNavMessages.getLabel().getString("CICW_PAGE_CONNECTION_NAME"));
        this.connectionCombo.setToolTipText(CatNavMessages.getLabel().getString("CICW_PAGE_CONNECTION_NAME"));
        this.connectionCombo.setItems(this.getConnectionnames(this.conns));
        if (this.connectionName != null && !this.connectionName.isEmpty()) {
            this.connectionCombo.setText(this.connectionName);
        }
        FormData fd_dbdButton = this.uih.genFormData(new FormAttachment((Control)this.connectionCombo, 20), null, new FormAttachment(0, 10), null);
        this.dbdCheckbox = new Button(parent, 32);
        this.dbdCheckbox.setText(CatNavMessages.getLabel().getString("CNSD_DBD"));
        this.dbdCheckbox.setToolTipText(CatNavMessages.getLabel().getString("CNSD_DBD"));
        this.dbdCheckbox.setLayoutData((Object)fd_dbdButton);
        this.dbdCheckbox.setSelection(this.dbdSearch);
        FormData fd_psbButton = this.uih.genFormData(new FormAttachment((Control)this.dbdCheckbox, 5), null, new FormAttachment(0, 10), null);
        this.psbCheckbox = new Button(parent, 32);
        this.psbCheckbox.setText(CatNavMessages.getLabel().getString("CNSD_PSB"));
        this.psbCheckbox.setToolTipText(CatNavMessages.getLabel().getString("CNSD_PSB"));
        this.psbCheckbox.setLayoutData((Object)fd_psbButton);
        this.psbCheckbox.setSelection(this.psbSearch);
        FormData fd_search = this.uih.genFormData(new FormAttachment((Control)this.psbCheckbox, 20), null, new FormAttachment(0, 10), null);
        Label searchLabel = new Label(parent, 64);
        searchLabel.setText(CatNavMessages.getLabel().getString("CNSD_SEARCHTEXT") + CatNavMessages.getColon().getString("COLON"));
        searchLabel.setToolTipText(CatNavMessages.getLabel().getString("CNSD_SEARCHTEXT"));
        searchLabel.setLayoutData((Object)fd_search);
        FormData fd_searchTxt = this.uih.genFormData(new FormAttachment((Control)this.psbCheckbox, 20), null, new FormAttachment((Control)searchLabel, 10), new FormAttachment(100, 0));
        this.searchText = new Text(parent, 2116);
        this.searchText.setLayoutData((Object)fd_searchTxt);
        this.searchText.setTextLimit(8);
        this.searchText.setText(this.searchPattern);
        String connection = this.connectionCombo.getText();
        if (connection != null && !connection.isEmpty() && (this.dbdCheckbox.getSelection() || this.psbCheckbox.getSelection())) {
            this.searchText.forceFocus();
        } else {
            this.connectionCombo.forceFocus();
        }
        this.addListeners();
        return parent;
    }

    private void addListeners() {
        this.connectionCombo.addModifyListener((ModifyListener)this);
        this.dbdCheckbox.addSelectionListener((SelectionListener)this);
        this.psbCheckbox.addSelectionListener((SelectionListener)this);
        this.searchText.addModifyListener((ModifyListener)this);
        this.searchText.addVerifyListener((VerifyListener)this);
    }

    private void removeListeners() {
        this.connectionCombo.removeModifyListener((ModifyListener)this);
        this.dbdCheckbox.removeSelectionListener((SelectionListener)this);
        this.psbCheckbox.removeSelectionListener((SelectionListener)this);
        this.searchText.removeModifyListener((ModifyListener)this);
        this.searchText.removeVerifyListener((VerifyListener)this);
    }

    private String[] getConnectionnames(List<CatalogTreeConnection> conns) {
        String[] connectionNames = new String[conns.size()];
        int i = 0;
        while (i < conns.size()) {
            connectionNames[i] = conns.get(i).getName();
            ++i;
        }
        return connectionNames;
    }

    protected void okPressed() {
        this.connName = this.connectionCombo.getText();
        this.searchPattern = this.searchText.getText();
        try {
            SearchRunnable popOp = new SearchRunnable(this.searchPattern);
            new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)popOp);
            List<String> foundDbdNames = popOp.getFoundDbdNames();
            List<String> foundPsbNames = popOp.getFoundPsbNames();
            CatalogTreeConnection connNode = this.getConnectionWithName(this.connName);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            CatalogSearchView view = (CatalogSearchView)page.showView("com.ibm.im.ims.catalog.ui.view.search.CatalogSearchView");
            view.buildSearchResult(connNode, foundDbdNames, foundPsbNames, this.searchPattern);
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "okPressed()", (Throwable)e);
            logger.error((Throwable)e);
        }
        super.okPressed();
    }

    private CatalogTreeConnection getConnectionWithName(String connName) {
        for (CatalogTreeConnection c : this.conns) {
            if (!c.getName().equals(connName)) continue;
            return c;
        }
        return null;
    }

    public void modifyText(ModifyEvent event) {
        try {
            this.updateOKButton();
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void updateOKButton() {
        this.searchPattern = this.searchText.getText();
        this.connectionName = this.connectionCombo.getText();
        this.psbSearch = this.psbCheckbox.getSelection();
        this.dbdSearch = this.dbdCheckbox.getSelection();
        if (this.connectionName != null && !this.connectionName.isEmpty() && this.searchPattern != null && !this.searchPattern.isEmpty() && (this.dbdSearch || this.psbSearch)) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.updateOKButton();
    }

    protected Control createButtonBar(Composite parent) {
        Control bBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.updateOKButton();
        return bBar;
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.connectionName == null || this.connectionName.isEmpty()) {
                this.connectionName = settings.get(STORE_LAST_CONNECTION_NAME);
            }
            this.searchPattern = settings.get(STORE_LAST_SEARCH_PATTERN);
            if (!this.dbdSearch) {
                this.dbdSearch = settings.getBoolean(STORE_DBD_SEARCH_OPTION);
            }
            if (!this.psbSearch) {
                this.psbSearch = settings.getBoolean(STORE_PSB_SEARCH_OPTION);
            }
        }
        if (this.searchPattern == null) {
            this.searchPattern = "";
        }
        if (this.connectionName == null) {
            this.connectionName = "";
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_LAST_CONNECTION_NAME, this.connectionCombo.getText());
            settings.put(STORE_LAST_SEARCH_PATTERN, this.searchPattern);
            settings.put(STORE_DBD_SEARCH_OPTION, this.dbdSearch);
            settings.put(STORE_PSB_SEARCH_OPTION, this.psbSearch);
        }
    }

    public IDialogSettings getDialogSettings() {
        return Utility.getDialogSettings((String)STORE_CATALOG_SEARCH_DIALOG);
    }

    public boolean close() {
        this.saveWidgetValues();
        this.removeListeners();
        return super.close();
    }

    class SearchRunnable
    implements IRunnableWithProgress {
        private String pattern;
        private List<String> foundDbdNames;
        private List<String> foundPsbNames;

        public SearchRunnable(String pattern) {
            this.pattern = pattern;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            try {
                IImsDbConnection connImpl;
                this.foundDbdNames = new ArrayList<String>();
                this.foundPsbNames = new ArrayList<String>();
                monitor.beginTask(CatNavMessages.getLabel().getString("CNS_SEARCH_PROGRESS_INDICATOR", (Object[])new String[]{this.pattern}), -1);
                CatalogNav catNav = CatalogNav.getSingletonInstance();
                CatalogTreeConnection connNode = CatalogSearchDialog.this.getConnectionWithName(CatalogSearchDialog.this.connName);
                CatalogTreeObject[] folders = connNode.getChildren();
                if (CatalogSearchDialog.this.dbdSearch) {
                    List<String> dbdList = catNav.getDbdListFromTreeNodes(connNode);
                    if (dbdList.size() == 0) {
                        connImpl = connNode.getConnection();
                        if (connImpl == null) {
                            ImsDbUtils.doConnect((ConnectionProfile)connNode.getConnectionProfile(), (boolean)false);
                            connImpl = connNode.getConnection();
                        }
                        if (connImpl != null) {
                            catNav.populateDbdFolder((CatalogTreeParent)folders[0]);
                            dbdList = catNav.getDbdListFromTreeNodes(connNode);
                        }
                    }
                    this.foundDbdNames = this.search(dbdList);
                }
                if (CatalogSearchDialog.this.psbSearch) {
                    List<String> psbList = catNav.getPsbListFromTreeNodes(connNode);
                    if (psbList.size() == 0) {
                        connImpl = connNode.getConnection();
                        if (connImpl == null && !CatalogSearchDialog.this.dbdSearch) {
                            ImsDbUtils.doConnect((ConnectionProfile)connNode.getConnectionProfile(), (boolean)false);
                            connImpl = connNode.getConnection();
                        }
                        if (connImpl != null) {
                            catNav.populatePsbFolder((CatalogTreeParent)folders[1]);
                            psbList = catNav.getPsbListFromTreeNodes(connNode);
                        }
                    }
                    this.foundPsbNames = this.search(psbList);
                }
                monitor.done();
            }
            catch (Throwable e) {
                logger.throwing(this.getClass().getName(), "run()", e);
                logger.error(e);
            }
        }

        private List<String> search(List<String> allCandidates) {
            ArrayList<String> results = new ArrayList<String>();
            if (allCandidates != null && !allCandidates.isEmpty()) {
                for (String name : allCandidates) {
                    if (!name.toUpperCase().contains(this.pattern.toUpperCase())) continue;
                    results.add(name);
                }
            }
            return results;
        }

        public List<String> getFoundDbdNames() {
            return this.foundDbdNames;
        }

        public List<String> getFoundPsbNames() {
            return this.foundPsbNames;
        }
    }
}

