/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeDbPcb;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeSenseg;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.sql.SQLException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class ResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final String OPEN_BRACKET = " [->";
    private static final String OPEN_BRACKET_ROOT = " [";
    private static final String CLOSE_BRACKET = "]";
    private static final String ROOT_DECORATION = "**ROOT**";
    private static final String PROCOPT = "PROCOPT=";

    public void decorate(Object obj, IDecoration decoration) {
        try {
            if (obj instanceof CatTreeSenseg) {
                this.decorateTable((CatTreeSenseg)obj, decoration);
            } else if (obj instanceof CatTreeDbPcb) {
                this.decorateSchema((CatTreeDbPcb)obj, decoration);
            } else if (obj instanceof CatalogTreeConnection) {
                this.decorateConnNode((CatalogTreeConnection)obj, decoration);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void decorateTable(CatTreeSenseg table, IDecoration decoration) throws Exception {
        Object prependedBlanks = " ";
        String tableName = table.getName();
        int numBlanksToPrepend = 11 - tableName.length();
        int i = 0;
        while (i < numBlanksToPrepend) {
            prependedBlanks = (String)prependedBlanks + " ";
            ++i;
        }
        String parentSegmentName = table.getParentSegmentName();
        if (parentSegmentName != null && !parentSegmentName.isEmpty()) {
            decoration.addSuffix((String)prependedBlanks + OPEN_BRACKET + parentSegmentName + CLOSE_BRACKET);
        } else {
            decoration.addSuffix((String)prependedBlanks + " [**ROOT**]");
        }
    }

    private void decorateSchema(CatTreeDbPcb schema, IDecoration decoration) throws Exception {
        Object prependedBlanks = " ";
        String schemaName = schema.getName();
        int numBlanksToPrepend = 11 - schemaName.length();
        int i = 0;
        while (i < numBlanksToPrepend) {
            prependedBlanks = (String)prependedBlanks + " ";
            ++i;
        }
        String procopt = schema.getProcopt();
        decoration.addSuffix((String)prependedBlanks + " [PROCOPT=" + procopt + CLOSE_BRACKET);
    }

    private void decorateConnNode(CatalogTreeConnection connNode, IDecoration decoration) throws SQLException {
        IImsDbConnection conn = connNode.getConnection();
        if (conn != null) {
            ImageDescriptor overlayImage = Utility.getImageDescriptor("obj_ovr_server.gif");
            decoration.addOverlay(overlayImage);
        }
    }
}

