/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PopulateFolderJob
extends Job {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private CatalogTreeParent folder;
    private CatalogNav catNav;

    public PopulateFolderJob(String name, CatalogNav catNav) {
        super(name);
        this.catNav = catNav;
    }

    public boolean setFolder(CatalogTreeParent folder) throws SQLException {
        boolean connectionGood = true;
        this.folder = folder;
        CatalogTreeConnection treeConnectionNode = (CatalogTreeConnection)folder.getParent();
        IImsDbConnection conn = treeConnectionNode.getConnection();
        try {
            if (conn == null) {
                connectionGood = false;
            }
        }
        catch (Exception exception) {
            connectionGood = false;
        }
        return connectionGood;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(CatNavMessages.getLabel().getString("CN_RETRIEVE_RESOURCE_LIST"), -1);
                CatalogTreeConnection treeConnectionNode = (CatalogTreeConnection)this.folder.getParent();
                BigInteger fetchSize = new BigInteger("200");
                IImsDbConnection conn = treeConnectionNode.getConnection();
                String resourceType = null;
                List resourceList = new ArrayList();
                String dbdOrPsb = null;
                if (this.folder.getType() == "PSB FOLDER") {
                    resourceType = "PSB";
                    resourceList = conn.getPsbList();
                    if (logger.isLoggable(Level.FINER)) {
                        dbdOrPsb = "PSB_FOLDER";
                    }
                } else {
                    resourceType = "DBD";
                    resourceList = conn.getDbdList();
                    if (logger.isLoggable(Level.FINER)) {
                        dbdOrPsb = "DBD";
                    }
                }
                int counter = 0;
                while (counter < resourceList.size()) {
                    String resourceName = (String)resourceList.get(counter);
                    CatalogTreeParent newDdb = new CatalogTreeParent(resourceName, resourceType, treeConnectionNode);
                    this.folder.addChild(newDdb);
                    if (counter % fetchSize.intValue() == 0) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CatalogNav.getSingletonInstance().refresh(PopulateFolderJob.this.folder);
                            }
                        });
                    }
                    ++counter;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(counter + " user " + dbdOrPsb + " names retrieved.");
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CatalogNav.getSingletonInstance().refresh();
                    }
                });
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PopulateFolderJob.this.catNav.processException(e);
                    }
                });
                monitor.done();
            }
            catch (Throwable t) {
                logger.error(t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

