/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.im.ims.catalog.ui.utilities.Utility;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreeField;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CatalogViewLabelProvider
extends LabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Image CatalogConnectionOpen_image = Utility.getImageDescriptor("jdbc_16.gif").createImage();
    public static final Image DBDFolderOpen_image = Utility.getImageDescriptor("database_folder_open_16.gif").createImage();
    public static final Image Dbd_image = Utility.getImageDescriptor("database_16.gif").createImage();
    public static final Image PSBFolderOpen_image = Utility.getImageDescriptor("programs_folder_open_16.gif").createImage();
    public static final Image Psb_image = Utility.getImageDescriptor("psb_16.gif").createImage();
    public static final Image Pcb_image = Utility.getImageDescriptor("PCB.gif").createImage();
    public static final Image Segment_image = Utility.getImageDescriptor("segments_edit_16.gif").createImage();
    public static final Image Sensegs_image = Utility.getImageDescriptor("sensitiveSegments_readOnly1.gif").createImage();
    public static final Image Schema_image = Utility.getImageDescriptor("schema.gif").createImage();
    public static final Image Table_image = Utility.getImageDescriptor("table.gif").createImage();
    public static final Image Column_image = Utility.getImageDescriptor("columns.gif").createImage();
    public static final Image KeyColumn_image = Utility.getImageDescriptor("pkColumn.gif").createImage();

    public String getText(Object obj) {
        return obj.toString();
    }

    public void dispose() {
        super.dispose();
        CatalogConnectionOpen_image.dispose();
        DBDFolderOpen_image.dispose();
        Dbd_image.dispose();
        PSBFolderOpen_image.dispose();
        Psb_image.dispose();
        Pcb_image.dispose();
        Segment_image.dispose();
        Sensegs_image.dispose();
        Schema_image.dispose();
        Table_image.dispose();
        Column_image.dispose();
        KeyColumn_image.dispose();
    }

    public Image getImage(Object obj) {
        CatalogTreeObject node = null;
        if (!(obj instanceof CatalogTreeObject)) {
            return null;
        }
        node = (CatalogTreeObject)obj;
        if (node.getType() == "IMS CATALOG CONNECTION") {
            return CatalogConnectionOpen_image;
        }
        if (node.getType() == "DBD FOLDER") {
            return DBDFolderOpen_image;
        }
        if (node.getType() == "DBD") {
            return Dbd_image;
        }
        if (node.getType() == "SEGMENT") {
            return Table_image;
        }
        if (node.getType() == "PSB FOLDER") {
            return PSBFolderOpen_image;
        }
        if (node.getType() == "PCB TP" || node.getType() == "PCB DB" || node.getType() == "PCB GSAM") {
            return Schema_image;
        }
        if (node.getType() == "PSB") {
            return Psb_image;
        }
        if (node.getType() == "SENSEG") {
            return Table_image;
        }
        if (node.getType() == "PCB TP FOLDER" || node.getType() == "PCB DB FOLDER" || node.getType() == "PCB GSAM FOLDER" || node.getType() == "ALL CONNECTIONS" || node.getType() == "FAVORITES") {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (node.getType() == "FIELD") {
            if (((CatTreeField)node).isKeyField()) {
                return KeyColumn_image;
            }
            return Column_image;
        }
        return null;
    }
}

