/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.catalog.ui.view.nav;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.catalog.resources.utilities.CatNavMessages;
import com.ibm.im.ims.catalog.ui.view.nav.CatTreePsbModel;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogNav;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogPSBTreeFolder;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeConnection;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeObject;
import com.ibm.im.ims.catalog.ui.view.nav.CatalogTreeParent;
import com.ibm.im.ims.catalog.ui.view.nav.PopulateFolderJob;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CatalogViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private CatalogNav catalogNav;
    private CatalogTreeParent invisibleRoot;
    public static final String[] psbNames = new String[0];
    public static final String[] dbdNames = new String[0];

    public CatalogViewContentProvider(CatalogNav catalogNav) {
        this.catalogNav = catalogNav;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public CatalogTreeParent getInvisibleRoot() {
        return this.invisibleRoot;
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.catalogNav.getViewSite())) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof CatalogTreeObject) {
            return ((CatalogTreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        Object[] retVal = new Object[]{};
        boolean isDisconnectedConnNode = false;
        try {
            if (parent instanceof CatalogTreeParent) {
                boolean addedPendingNode = false;
                String type = ((CatalogTreeParent)parent).getType();
                if (type != "FAVORITES") {
                    if (type == "DBD FOLDER") {
                        PopulateFolderJob popDbdsJob;
                        boolean connectionGood;
                        if (((CatalogTreeParent)parent).getChildren().length == 0 && (connectionGood = (popDbdsJob = new PopulateFolderJob(CatNavMessages.getDescription().getString("CN_LOAD_DBD_LIST"), this.catalogNav)).setFolder((CatalogTreeParent)parent))) {
                            CatalogTreeParent newPending = new CatalogTreeParent(CatNavMessages.getDescription().getString("CN_PENDING"), "PENDING");
                            ((CatalogTreeParent)parent).addChild(newPending);
                            ((CatalogTreeParent)parent).setPendingNode(newPending);
                            addedPendingNode = true;
                            popDbdsJob.schedule();
                        }
                    } else if (type == "PSB FOLDER") {
                        PopulateFolderJob popPsbsJob;
                        boolean connectionGood;
                        if (((CatalogTreeParent)parent).getChildren().length == 0 && (connectionGood = (popPsbsJob = new PopulateFolderJob(CatNavMessages.getDescription().getString("CN_LOAD_PSB_LIST"), this.catalogNav)).setFolder((CatalogTreeParent)parent))) {
                            CatalogTreeParent newPending = new CatalogTreeParent(CatNavMessages.getDescription().getString("CN_PENDING"), "PENDING");
                            ((CatalogTreeParent)parent).addChild(newPending);
                            ((CatalogTreeParent)parent).setPendingNode(newPending);
                            addedPendingNode = true;
                            popPsbsJob.schedule();
                        }
                    } else if (type == "IMS CATALOG CONNECTION") {
                        CatalogTreeConnection connNode = (CatalogTreeConnection)parent;
                        IImsDbConnection conn = connNode.getConnection();
                        if (conn == null) {
                            isDisconnectedConnNode = true;
                        }
                    } else if (parent instanceof CatTreePsbModel) {
                        if (((CatTreePsbModel)parent).isUserPsbConnection) {
                            if (((CatTreePsbModel)parent).getPsbModel() == null) {
                                ((CatTreePsbModel)parent).populatePsbModelFromCatalogAsync();
                            }
                        } else if (((CatTreePsbModel)parent).isCatalogPsbConnection && ((CatTreePsbModel)parent).getPsbModel() == null) {
                            ((CatTreePsbModel)parent).populatePsbModelFromCatalogAsync();
                        }
                    } else if (type == "NONE") {
                        retVal = ((CatalogTreeParent)parent).getChildren();
                    }
                }
                if (!(addedPendingNode || type != "PSB FOLDER" && type != "DBD FOLDER")) {
                    ((CatalogTreeParent)parent).removePendingNode();
                }
                if (!isDisconnectedConnNode) {
                    retVal = ((CatalogTreeParent)parent).getChildren();
                }
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return retVal;
    }

    public boolean hasChildren(Object parent) {
        if (((CatalogTreeObject)parent).getType() == "FIELD" || ((CatalogTreeObject)parent).getType() == "PENDING" || ((CatalogTreeObject)parent).getType() == "DBD") {
            return false;
        }
        if (((CatalogTreeObject)parent).getType() == "PSB" && !(parent instanceof CatTreePsbModel)) {
            return false;
        }
        if (parent instanceof CatalogTreeConnection) {
            IImsDbConnection conn = ((CatalogTreeConnection)parent).getConnection();
            try {
                if (conn == null) {
                    return false;
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static void populatePcbFolders(CatalogTreeParent parent) {
        CatalogTreeConnection treeConnectionNode = parent.getTreeConnectionNode();
        CatalogPSBTreeFolder pcbTp = new CatalogPSBTreeFolder(parent, CatalogPSBTreeFolder.PCB_TP_FOLDER, "PCB TP FOLDER", treeConnectionNode);
        CatalogPSBTreeFolder pcbDb = new CatalogPSBTreeFolder(parent, CatalogPSBTreeFolder.PCB_DB_FOLDER, "PCB DB FOLDER", treeConnectionNode);
        CatalogPSBTreeFolder pcbGsam = new CatalogPSBTreeFolder(parent, CatalogPSBTreeFolder.PCB_GSAM_FOLDER, "PCB GSAM FOLDER", treeConnectionNode);
        parent.addChild(pcbTp);
        parent.addChild(pcbDb);
        parent.addChild(pcbGsam);
    }

    private void populateConnections(CatalogTreeParent parent) {
        List connProfs = ImsDbUtils.getConnectionProfiles();
        int i = 0;
        while (i < connProfs.size()) {
            ConnectionProfile connProf = (ConnectionProfile)connProfs.get(i);
            CatalogTreeConnection connNode = this.createConnNode(connProf);
            parent.addChild(connNode);
            ++i;
        }
    }

    public CatalogTreeConnection addConnection(ConnectionProfile newConnProf) {
        CatalogTreeConnection connNode = this.createConnNode(newConnProf);
        CatalogTreeParent connsFolder = this.getConnsFolder();
        connsFolder.addChild(connNode);
        return connNode;
    }

    private CatalogTreeConnection createConnNode(ConnectionProfile connProf) {
        CatalogTreeConnection connNode = new CatalogTreeConnection(connProf);
        return connNode;
    }

    public void removeConnection(ConnectionProfile connProf) {
        CatalogTreeConnection connNode = this.getConnNode(connProf.getId());
        CatalogTreeParent connsFolder = this.getConnsFolder();
        connsFolder.removeChild(connNode);
    }

    private boolean isNewConnection(CatalogTreeParent parent, String connProfId) {
        int i = 0;
        while (i < parent.getChildren().length) {
            CatalogTreeConnection currConnNode = (CatalogTreeConnection)parent.getChildren()[i];
            if (currConnNode.getConnectionProfileId().equals(connProfId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initialize() {
        CatalogTreeParent connsFolder = new CatalogTreeParent(CatNavMessages.getLabel().getString("CN_CONNECTIONS"), "ALL CONNECTIONS");
        this.populateConnections(connsFolder);
        this.invisibleRoot = new CatalogTreeParent("", "NONE");
        this.invisibleRoot.addChild(connsFolder);
    }

    public List<CatalogTreeConnection> getAllConnections() {
        CatalogTreeParent root = (CatalogTreeParent)this.invisibleRoot.getChildren()[0];
        ArrayList<CatalogTreeConnection> conns = new ArrayList<CatalogTreeConnection>();
        CatalogTreeObject[] catalogTreeObjectArray = root.getChildren();
        int n = catalogTreeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CatalogTreeObject obj = catalogTreeObjectArray[n2];
            conns.add((CatalogTreeConnection)obj);
            ++n2;
        }
        return conns;
    }

    public CatalogTreeConnection getConnNode(String connProfId) {
        CatalogTreeObject currNode;
        CatalogTreeObject retVal = null;
        CatalogTreeObject[] nodes = this.invisibleRoot.getChildren();
        CatalogTreeParent connsFolder = null;
        int i = 0;
        while (i < nodes.length) {
            currNode = nodes[i];
            if (currNode.getType() == "ALL CONNECTIONS") {
                connsFolder = (CatalogTreeParent)currNode;
                break;
            }
            ++i;
        }
        if (connsFolder != null) {
            nodes = connsFolder.getChildren();
            i = 0;
            while (i < nodes.length) {
                currNode = (CatalogTreeConnection)nodes[i];
                if (((CatalogTreeConnection)currNode).getConnectionProfileId().equals(connProfId)) {
                    retVal = currNode;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public CatalogTreeParent getConnsFolder() {
        CatalogTreeParent retVal = null;
        CatalogTreeObject[] nodes = this.invisibleRoot.getChildren();
        int i = 0;
        while (i < nodes.length) {
            CatalogTreeObject currNode = nodes[i];
            if (currNode.getType() == "ALL CONNECTIONS") {
                retVal = (CatalogTreeParent)currNode;
                break;
            }
            ++i;
        }
        return retVal;
    }

    class CatNavRefreshRunner
    implements Runnable {
        private CatalogTreeConnection connNode;

        public CatNavRefreshRunner(CatalogTreeConnection connNode) {
            this.connNode = connNode;
        }

        @Override
        public void run() {
            CatalogViewContentProvider.this.catalogNav.refresh(this.connNode);
        }
    }
}

